/*
** Copyright (C) 2000 Idan Shoham <idan@m-tech.ab.ca>
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

using namespace std;

#include "project.h"
#include "reporter.h"

void Reporter::SlippageReport( Project *project )
{
    TASK *t;
    char buf1[500], buf2[500];
    FILE *ftxt = NULL;
    FILE *ftex = NULL;
    FILE *fhtml = NULL;

    int early;
    int nFinishedTasksOnTime = 0;
    int nFinishedTasksEarly = 0;
    int nFinishedTasksLate = 0;
    int nFinishedDaysEarly = 0;
    int nFinishedDaysLate = 0;
  
    int nOngoingTasksOnTime = 0;
    int nOngoingTasksEarly = 0;
    int nOngoingTasksLate = 0;
    int nOngoingDaysEarly = 0;
    int nOngoingDaysLate = 0;

    if ( slippage_txt_report != NULL )
	ftxt = OpenOutputFile(slippage_txt_report);

    if ( slippage_tex_report != NULL )
	ftex = OpenOutputFile(slippage_tex_report);

    if ( slippage_html_report != NULL )
    {
	fhtml = OpenOutputFile(slippage_html_report);
	fprintf(fhtml, "<html>\n<body>\n\n");
    }
  
//    if ( ( ftxt == NULL ) &&  ( ftex == NULL ) &&  ( fhtml == NULL ) )
//	ftxt = stdout;

    if ( ftxt != NULL )
    {
	fprintf(ftxt, "Schedule changes:\n");
	fprintf(ftxt, "=================\n\n");
	fprintf(ftxt, "%-40s %4s %4s %4s %s %9s\n","Task", "Done", "Old",
		"New", "Chg?", "Remaining");
	fprintf(ftxt, "%-40s %4s %4s %4s %s %9s\n","----", "----", "---",
		"---", "----", "---------");
    }
    if ( ftex != NULL )
    {
	fprintf(ftex, "\\subsection{Schedule changes}\n");
	fprintf(ftex, "\\begin{supertabular}{|l|r|r|r|l|r|}\n");
	fprintf(ftex, "\\hline\n");
	fprintf(ftex, "{\\bf %s} & {\\bf %s} & {\\bf %s} & {\\bf %s} & {\\bf %s} & {\\bf %s} \\\\\n",
		"Task", "\\% Done", "Old", "New", "Chg?", "Remaining");
	fprintf(ftex, "\\hline\n");
	fprintf(ftex, "\\hline\n");
    }
    if ( fhtml != NULL )
    {
	fprintf(fhtml, "<h1>Schedule changes</h1>\n");
	fprintf(fhtml, "<p><table cellpadding=2 border=1>\n");
	fprintf(fhtml, "<tr><th>Task</th><th>%% Done</th><th>Old</th><th>New</th><th>Chg?</th><th>Remaining</th></tr>\n");
    }

    for ( Project::TPLCI pt = project->beginTaskList() ; 
	  pt != project->endTaskList() ; pt++ )
    {
	t = *pt;
	if ( t->percent_complete() == 0 )
	    continue;			/* no work done yet */
#if 0
	if ( ( t->when == NULL ) && ( t->nDays == 0 ) )
	    continue;			/* no info on when work done */
#endif
	// don't look at t->when here because it has been assigned by
	// the scheduler!
	if ( t->nDays() == 0 )
	    continue;			/* no info on when work done */
	
	// Update our statistics:
	if ( t->percent_complete() > 99 ) // finished task
        {
	    if ( t->origfullduration() > t->fullduration() )
	    {
		nFinishedTasksEarly += 1;
		nFinishedDaysEarly += (t->origfullduration() - t->fullduration() );
	    }
	    else if ( t->origfullduration() == t->fullduration() )
	    {
		nFinishedTasksOnTime += 1;
	    }
	    else if ( t->origfullduration() < t->fullduration() )
	    {
		nFinishedTasksLate += 1;
		nFinishedDaysLate += (t->fullduration() - t->origfullduration() );
	    }
        }
	else // ongoing task
        {
	    if ( t->origfullduration() > t->fullduration() )
	    {
		nOngoingTasksEarly += 1;
		nOngoingDaysEarly += (t->origfullduration() - t->fullduration() );
	    }
	    else if ( t->origfullduration() == t->fullduration() )
	    {
		nOngoingTasksOnTime += 1;
	    }
	    else if ( t->origfullduration() < t->fullduration() )
	    {
		nOngoingTasksLate += 1;
		nOngoingDaysLate += (t->fullduration() - t->origfullduration() );
	    }
        }
	
	// record changes to duration
	if ( t->fullduration() != t->origfullduration() )
        {
	    if ( ftxt != NULL )
	    {
		char buf[128];
		if ( task_ids )
		    sprintf(buf, "%s %s", t->id(), t->name() );
		else
		    sprintf(buf, "%s", t->name() );
		fprintf(ftxt, "%-40s %4g %4d %4d %-5s %8d\n",
			buf, t->percent_complete(), 
			t->origfullduration(), t->fullduration(),
			t->fullduration()<t->origfullduration() ? "Early":"Late",
			t->fullduration() - t->nDays() );
	    }
	    if ( ftex != NULL )
	    {
		if ( task_ids )
		    fprintf(ftex, "%s %s",
			    TeXFix(buf1,t->id()),
			    TeXFix(buf2,t->name()));
		else
		    fprintf(ftex, "%s",
			    TeXFix(buf2,t->name()));
		fprintf(ftex," & %g & %d & %d & %s & %d\\\\ \n",
			t->percent_complete(),
			t->origfullduration(), t->fullduration(),
			t->fullduration()<t->origfullduration() ? "Early":"Late",
			t->fullduration() - t->nDays());
	    }
	    if ( fhtml != NULL )
	    {
		fprintf(fhtml, "<tr>");
		if ( task_ids )
		    fprintf(fhtml, "<td>%s %s</td>",
			    HTMLFix(buf1,t->id()),
			    HTMLFix(buf2,t->name()));
		else
		    fprintf(fhtml, "<td>%s</td>",
			    HTMLFix(buf2,t->name()));
		fprintf(fhtml, " <td align=right>%g</td> <td align=right>%d</td> <td align=right>%d</td> <td>%s</td> <td align=right>%d</td></tr>\n",
			t->percent_complete(),
			t->origfullduration(), t->fullduration(),
			t->fullduration()<t->origfullduration() ? "Early":"Late",
			t->fullduration() - t->nDays());
	    }
        }
	else
        {
	    if ( ftxt != NULL )
	    {
		fprintf(ftxt, "%-40s %4g %4d %4d %s\n",
			t->id(), t->percent_complete(), t->origfullduration(),
			t->fullduration(), "-");
	    }
	    if ( ftex != NULL )
	    {
		if ( task_ids )
		    fprintf(ftex, "%s %s",
			    TeXFix(buf1,t->id()),
			    TeXFix(buf2,t->name()));
		else
		    fprintf(ftex, "%s",
			    TeXFix(buf2,t->name()));
		fprintf(ftex, " & %g & %d & %d &  & \\\\ \n",
			t->percent_complete(),
			t->origfullduration(), t->fullduration());
	    }
	    if ( fhtml != NULL )
	    {
		fprintf(fhtml, "<tr>");
		if ( task_ids )
		    fprintf(fhtml, "<td>%s %s</td>",
			    HTMLFix(buf1,t->id()),
			    HTMLFix(buf2,t->name()));
		else
		    fprintf(fhtml, "<td>%s</td>",
			    HTMLFix(buf2,t->name()));
		fprintf(fhtml,
			"<td align=right>%g</td> <td align=right>%d</td> <td align=right>%d</td> <td>&nbsp;</td> <td>&nbsp;</td></tr>\n",
			t->percent_complete(),
			t->origfullduration(), t->fullduration());
	    }
        }
    }

    early = nOngoingDaysEarly + nFinishedDaysEarly -
	(nOngoingDaysLate + nFinishedDaysLate);

    if ( ftxt != NULL )
    {
	fprintf(ftxt,"\nSUMMARY:\n\n");
	fprintf(ftxt,"Completed tasks:\n");
	fprintf(ftxt,
		"   On time: %d   Early: %d (%d days)   Late: %d (%d days)\n",
		nFinishedTasksOnTime,
		nFinishedTasksEarly, nFinishedDaysEarly,
		nFinishedTasksLate, nFinishedDaysLate);
  
	fprintf(ftxt,"Ongoing tasks:\n");
	fprintf(ftxt,
		"   On time: %d   Early: %d (%d days)   Late: %d (%d days)\n",
		nOngoingTasksOnTime,
		nOngoingTasksEarly, nOngoingDaysEarly,
		nOngoingTasksLate, nOngoingDaysLate);
  
	fprintf(ftxt,"The project is %d days %s schedule.\n",
		abs(early), early>0 ? "ahead of":"behind");
    }
    if ( ftex != NULL )
    {
	fprintf(ftex,"\\hline\n");
	fprintf(ftex,"\\end{supertabular}\n\n");
	fprintf(ftex,"\n{\\bf Summary:} \\\\ \n");
	fprintf(ftex,"Completed tasks: \\\\ \n");
	fprintf(ftex,
		"\\mbox{} \\hspace{0.5in} On time: %d   Early: %d (%d days)   Late: %d (%d days) \\\\ \n",
		nFinishedTasksOnTime,
		nFinishedTasksEarly, nFinishedDaysEarly,
		nFinishedTasksLate, nFinishedDaysLate);
  
	fprintf(ftex,"Ongoing tasks: \\\\ \n");
	fprintf(ftex,"\\mbox{} \\hspace{0.5in} On time: %d   Early: %d (%d days)   Late: %d (%d days) \\\\ \n",
		nOngoingTasksOnTime,
		nOngoingTasksEarly, nOngoingDaysEarly,
		nOngoingTasksLate, nOngoingDaysLate);
  
	fprintf(ftex,"The project is %d days %s schedule.\n",
		abs(early), early>0 ? "ahead of":"behind");
    }
    if ( fhtml != NULL )
    {
	fprintf(fhtml,"</table></p>\n\n");
	fprintf(fhtml,"<h2>Summary:</h2>\n");
	fprintf(fhtml,"<p>Completed tasks:</p>\n");
	fprintf(fhtml,"<p>&nbsp;&nbsp;&nbsp;&nbsp; On time: %d   Early: %d (%d days)   Late: %d (%d days)</p>\n",
		nFinishedTasksOnTime,
		nFinishedTasksEarly, nFinishedDaysEarly,
		nFinishedTasksLate, nFinishedDaysLate);
  
	fprintf(fhtml,"<p>Ongoing tasks:<p>\n");
	fprintf(fhtml,"<p>&nbsp;&nbsp;&nbsp;&nbsp; On time: %d   Early: %d (%d days)   Late: %d (%d days)</p>\n",
		nOngoingTasksOnTime,
		nOngoingTasksEarly, nOngoingDaysEarly,
		nOngoingTasksLate, nOngoingDaysLate);
  
	fprintf(fhtml,"<p>The project is %d days %s schedule.</p>\n",
		abs(early), early>0 ? "ahead of":"behind");
    }


    if ( ( ftxt != NULL ) && ( ftxt != stdout ) )
	fclose(ftxt); 
    if ( ftex != NULL )
	fclose(ftex);
    if ( fhtml != NULL )
    {
	fprintf(fhtml, "\n\n</body>\n</html>\n");
	fclose(fhtml);
    }
}
