/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.debug;

import java.io.Serializable;
import org.javagroups.Event;
import org.javagroups.Message;
import org.javagroups.log.Trace;
import org.javagroups.stack.Configurator;
import org.javagroups.stack.Protocol;
import org.javagroups.util.Util;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ProtocolTester {
    Protocol harness;
    Protocol top;
    Protocol bottom;
    String props;
    Configurator config;

    public String getProtocolSpec() {
        return this.props;
    }

    public void stop() {
        if (this.harness != null) {
            Protocol p = this.harness;
            while (p != null) {
                p.stop();
                p = p.getDownProtocol();
            }
            this.config.stopProtocolStack(this.harness);
        } else if (this.top != null) {
            Protocol p = this.top;
            while (p != null) {
                p.stop();
                p = p.getDownProtocol();
            }
            this.config.stopProtocolStack(this.top);
        }
    }

    Protocol getBottomProtocol(Protocol top) {
        if (top == null) {
            return null;
        }
        Protocol tmp = top;
        while (tmp.getDownProtocol() != null) {
            tmp = tmp.getDownProtocol();
        }
        return tmp;
    }

    public static void main(String[] args) {
        boolean trace = false;
        if (args.length < 1 || args.length > 2) {
            System.out.println("ProtocolTester <protocol stack spec> [-trace]");
            return;
        }
        String props = args[0];
        if (args.length == 2 && args[1].equals("-trace")) {
            trace = true;
        }
        try {
            Harness h = new Harness();
            ProtocolTester t = new ProtocolTester(props, h, trace);
            System.out.println("protocol specification is " + t.getProtocolSpec());
            h.down(new Event(16));
            int i = 0;
            while (i < 5) {
                System.out.println("Sending msg #" + i);
                h.down(new Event(1, new Message(null, null, (Serializable)((Object)("Hello world #" + i)))));
                ++i;
            }
            Util.sleep(500L);
            t.stop();
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    private final /* synthetic */ void this() {
        this.harness = null;
        this.props = null;
        this.config = null;
    }

    public ProtocolTester(String prot_spec, Protocol harness, boolean trace) throws Exception {
        this.this();
        if (prot_spec == null || harness == null) {
            throw new Exception("ProtocolTester(): prot_spec or harness is null");
        }
        this.props = prot_spec;
        this.harness = harness;
        this.props = "LOOPBACK:" + this.props;
        if (trace) {
            Trace.init();
        }
        this.config = new Configurator();
        this.top = this.config.setupProtocolStack(this.props, null);
        harness.setDownProtocol(this.top);
        this.top.setUpProtocol(harness);
        this.bottom = this.getBottomProtocol(this.top);
        this.config.startProtocolStack(this.bottom);
    }

    private static class Harness
    extends Protocol {
        public String getName() {
            return "Harness";
        }

        public void up(Event evt) {
            System.out.println("Harness.up(): " + evt);
        }

        private Harness() {
        }
    }
}

