/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.util.Properties;
import org.javagroups.Event;
import org.javagroups.log.Trace;
import org.javagroups.stack.Protocol;
import org.javagroups.util.Util;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DELAY
extends Protocol {
    int in_delay;
    int out_delay;

    public String getName() {
        return "DELAY";
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("in_delay");
        if (str != null) {
            this.in_delay = new Integer(str);
            props.remove("in_delay");
        }
        if ((str = props.getProperty("out_delay")) != null) {
            this.out_delay = new Integer(str);
            props.remove("out_delay");
        }
        if (props.size() > 0) {
            System.err.println("DELAY.setProperties(): these properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    public void up(Event evt) {
        int n = 0;
        if (this.in_delay > 0) {
            n = this.computeDelay(this.in_delay);
        }
        int delay = n;
        switch (evt.getType()) {
            case 1: {
                if (Trace.trace) {
                    Trace.info("DELAY.up()", "delaying incoming message for " + delay + " milliseconds");
                }
                Util.sleep(delay);
                break;
            }
        }
        this.passUp(evt);
    }

    public void down(Event evt) {
        int n = 0;
        if (this.out_delay > 0) {
            n = this.computeDelay(this.out_delay);
        }
        int delay = n;
        switch (evt.getType()) {
            case 1: {
                if (Trace.trace) {
                    Trace.info("DELAY.down()", "delaying outgoing message for " + delay + " milliseconds");
                }
                Util.sleep(delay);
                break;
            }
        }
        this.passDown(evt);
    }

    int computeDelay(int n) {
        return (int)(Math.random() * 1000000.0 % (double)n);
    }

    private final /* synthetic */ void this() {
        this.in_delay = 0;
        this.out_delay = 0;
    }

    public DELAY() {
        this.this();
    }
}

