/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.X509EncodedKeySpec;
import java.util.Properties;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.SecretKeySpec;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Header;
import org.javagroups.Message;
import org.javagroups.View;
import org.javagroups.log.Trace;
import org.javagroups.protocols.PingRsp;
import org.javagroups.stack.Protocol;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ENCRYPT1_4
extends Protocol {
    Address local_addr;
    Address keyServerAddr;
    boolean keyServer;
    String asymAlgorithm;
    String symAlgorithm;
    int asymInit;
    int symInit;
    KeyPair Kpair;
    SecretKey desKey;
    PublicKey pubKey;
    PublicKey serverPubKey;
    Cipher cipher;
    Cipher rsa;
    Vector members;
    Vector notReady;

    public String getName() {
        return "ENCRYPT1_4";
    }

    private final String getAlgorithm(String s) {
        int index = s.indexOf("/");
        if (index == -1) {
            return s;
        }
        return s.substring(0, index);
    }

    public boolean setProperties(Properties props) {
        this.props = props;
        String str = props.getProperty("asymInit");
        if (str != null) {
            this.asymInit = new Integer(str);
            props.remove("asymInit");
            if (Trace.trace) {
                Trace.info("ENCRYPT1_4.setProperties()", "Asym algo bits used is " + this.asymInit);
            }
        }
        if ((str = props.getProperty("symInit")) != null) {
            this.symInit = new Integer(str);
            props.remove("symInit");
            if (Trace.trace) {
                Trace.info("ENCRYPT1_4.setProperties()", "Sym algo bits used is " + this.symInit);
            }
        }
        if ((str = props.getProperty("asymAlgorithm")) != null) {
            this.asymAlgorithm = new String(str).toString();
            props.remove("asymAlgorithm");
            if (Trace.trace) {
                Trace.info("ENCRYPT1_4.setProperties()", "Asym algo used is " + this.asymAlgorithm);
            }
        }
        if ((str = props.getProperty("symAlgorithm")) != null) {
            this.symAlgorithm = new String(str).toString();
            props.remove("symAlgorithm");
            if (Trace.trace) {
                Trace.info("ENCRYPT1_4.setProperties()", "Sym algo used is " + this.symAlgorithm);
            }
        }
        if (props.size() > 0) {
            if (Trace.trace) {
                Trace.error("ENCRYPT1_4.setProperties()", "these properties are not recognized:" + props);
            }
            return false;
        }
        return true;
    }

    public void init() throws Exception {
        KeyPairGenerator KpairGen = KeyPairGenerator.getInstance(this.getAlgorithm(this.asymAlgorithm));
        KpairGen.initialize(this.asymInit, new SecureRandom());
        this.Kpair = KpairGen.generateKeyPair();
        KeyGenerator keyGen = KeyGenerator.getInstance(this.getAlgorithm(this.symAlgorithm));
        keyGen.init(this.symInit);
        this.desKey = keyGen.generateKey();
        this.rsa = Cipher.getInstance(this.asymAlgorithm);
        this.cipher = Cipher.getInstance(this.symAlgorithm);
        if (Trace.trace) {
            Trace.info("ENCRYPT1_4.init()", " Both asym and sym algo initialized with the single shared key");
        }
    }

    public void reset() {
    }

    public void up(Event evt) {
        if (Trace.trace) {
            Trace.info("ENCRYPT1_4.up()", "Event going up is " + evt);
        }
        switch (evt.getType()) {
            case 8: {
                if (Trace.trace) {
                    Trace.info("ENCRYPT1_4.up()", "Set address call");
                }
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 13: {
                Vector member = (Vector)evt.getArg();
                if (Trace.trace) {
                    Trace.info("ENCRYPT1_4.up()", "FIND_INIT members call, left members are " + member.size());
                }
                if (!this.keyServer) {
                    int n = 0;
                    if (member.size() > 0) {
                        n = 1;
                    }
                    this.keyServer = 1 - n;
                }
                this.keyServerAddr = member != null && member.size() > 0 ? ((PingRsp)member.firstElement()).coord_addr : this.local_addr;
                if (!this.keyServer) {
                    this.desKey = null;
                    if (Trace.trace) {
                        Trace.debug("ENCRYPT1_4.up()", "This is not keyserver, deskey set to null");
                    }
                    Message newMsg = new Message(this.keyServerAddr, this.local_addr, this.Kpair.getPublic().getEncoded());
                    newMsg.putHeader("encrypt", new EncryptHeader(1));
                    this.passDown(new Event(1, newMsg));
                }
                if (Trace.trace) {
                    Trace.info("ENCRYPT1_4.up()", "Done parsing for encrypt headers, sending upwards" + evt);
                }
                this.passUp(evt);
                return;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                if (Trace.trace) {
                    Trace.info("ENCRYPT1_4.up()", "This is a message from peer, not control header" + msg);
                }
                if (msg == null) {
                    if (Trace.trace) {
                        Trace.debug("ENCRYPT1_4.up()", "Null message");
                    }
                    this.passUp(evt);
                    return;
                }
                Header obj = msg.removeHeader("encrypt");
                if (Trace.trace) {
                    Trace.info("ENCRYPT1_4.up()", "Stripping the required protocol header");
                }
                if (obj == null || !(obj instanceof EncryptHeader)) {
                    if (Trace.trace) {
                        Trace.info("ENCRYPT1_4.up()", "Dropping package as ENCRYPT1_4 protocol is not been recognized, msg will not be passed up");
                    }
                    return;
                }
                EncryptHeader hdr = (EncryptHeader)obj;
                if (Trace.trace) {
                    Trace.info("ENCRYPT1_4.up()", "Header received " + hdr + ':' + hdr.type);
                }
                switch (hdr.type) {
                    case 1: {
                        try {
                            if (Trace.trace) {
                                Trace.debug("ENCRYPT1_4.up()", "Request for key");
                            }
                            this.notReady.addElement(msg.getSrc());
                            PublicKey pubKey = this.generatePubKey(msg.getBuffer());
                            if (Trace.trace) {
                                Trace.debug("ENCRYPT1_4.up()", "Generated requestors public key");
                            }
                            Message newMsg = new Message(msg.getSrc(), this.local_addr, this.Kpair.getPublic().getEncoded());
                            newMsg.putHeader("encrypt", new EncryptHeader(2));
                            if (Trace.trace) {
                                Trace.debug("ENCRYPT1_4.up()", "Encoded servers public key using clients public key, only client can debug it using its private key and sending it back");
                            }
                            this.passDown(new Event(1, newMsg));
                            this.rsa.init(1, pubKey);
                            byte[] encryptedKey = this.rsa.doFinal(this.desKey.getEncoded());
                            if (Trace.trace) {
                                Trace.debug("ENCRYPT1_4.up()", " Generated encoded key which only client can decode");
                            }
                            newMsg = new Message(msg.getSrc(), this.local_addr, encryptedKey);
                            newMsg.putHeader("encrypt", new EncryptHeader(3));
                            if (Trace.trace) {
                                Trace.debug("ENCRYPT1_4.up()", " Sending encoded key to client");
                            }
                            this.passDown(new Event(1, newMsg));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            System.out.println("" + e + '0');
                        }
                        return;
                    }
                    case 4: {
                        this.notReady.removeElement(msg.getSrc());
                        if (Trace.trace) {
                            Trace.debug("ENCRYPT1_4.up()", "Removed client " + msg.getSrc() + "from notready list");
                        }
                        return;
                    }
                    case 2: {
                        this.serverPubKey = this.generatePubKey(msg.getBuffer());
                        if (Trace.trace) {
                            Trace.debug("ENCRYPT1_4.up()", " Obtained the servers public key");
                        }
                        return;
                    }
                    case 3: {
                        try {
                            this.rsa.init(2, this.Kpair.getPrivate());
                            byte[] encodedKey = this.rsa.doFinal(msg.getBuffer());
                            if (Trace.trace) {
                                Trace.debug("ENCRYPT1_4.up()", "generating encoded key obtained from server-admin");
                            }
                            this.desKey = this.decodedKey(encodedKey);
                            if (this.desKey == null && Trace.trace) {
                                Trace.error("ENCRYPT1_4.up()", "ohh oh !! DES key is null");
                            }
                            Message newMsg = new Message(msg.getSrc(), this.local_addr, null);
                            newMsg.putHeader("encrypt", new EncryptHeader(4));
                            this.passDown(new Event(1, newMsg));
                            if (Trace.trace) {
                                Trace.debug("ENCRYPT1_4.up()", "Got the deskey, sending down sec_Ready header");
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            System.out.println("" + e + '5');
                        }
                        return;
                    }
                }
                if (hdr.type != 0 && Trace.trace) {
                    Trace.error("ENCRYPT1_4.up()", "Error , header is not 0");
                }
                if (this.desKey == null) {
                    return;
                }
                if (Trace.trace) {
                    Trace.info("ENCRYPT1_4.up()", " Starting to decypher messages");
                }
                if (msg.getBuffer() == null) break;
                try {
                    this.cipher.init(2, this.desKey);
                    msg.setBuffer(this.cipher.doFinal(msg.getBuffer()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
        }
        if (Trace.trace) {
            Trace.info("ENCRYPT1_4.up()", "Passing up event");
        }
        this.passUp(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void down(Event evt) {
        block25: {
            leave = false;
            if (Trace.trace) {
                Trace.info("ENCRYPT1_4.down()", "down:evt is " + evt + ':' + evt.getType());
            }
            switch (evt.getType()) {
                case 6: {
                    if (Trace.trace) {
                        Trace.info("ENCRYPT1_4.down()", "View change call, new member coming in");
                    }
                    new_members = ((View)evt.getArg()).getMembers();
                    if (this.members.size() > new_members.size()) {
                        leave = true;
                    }
                    var6_4 = this.members;
                    synchronized (var6_4) {
                        this.members.removeAllElements();
                        if (new_members != null && new_members.size() > 0) {
                            i = 0;
                        }
                        ** GOTO lbl25
                        while (i < new_members.size()) {
                            this.members.addElement(new_members.elementAt(i));
                            ++i;
                        }
lbl25:
                        // 2 sources

                        if (!leave) break;
                    }
                    obj = this.members.firstElement();
                    if (obj.equals(this.local_addr)) {
                        this.keyServer = true;
                        this.keyServerAddr = this.local_addr;
                        this.desKey = null;
                        if (Trace.trace) {
                            Trace.info("ENCRYPT1_4.down()", " leave caused deskey to be null ");
                        }
                        try {
                            keyGen = KeyGenerator.getInstance(this.getAlgorithm(this.symAlgorithm));
                            keyGen.init(this.symInit);
                            this.desKey = keyGen.generateKey();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    this.keyServer = false;
                    this.keyServerAddr = (Address)obj;
                    this.desKey = null;
                    newMsg = new Message(this.keyServerAddr, this.local_addr, this.Kpair.getPublic().getEncoded());
                    newMsg.putHeader("encrypt", new EncryptHeader(1));
                    this.passDown(new Event(1, newMsg));
                    if (!Trace.trace) break;
                    Trace.debug("ENCRYPT1_4.down()", "Requesting new key to be part of group");
                    break;
                }
                case 1: {
                    msg = (Message)evt.getArg();
                    if (Trace.trace) {
                        Trace.debug("ENCRYPT1_4.down()", "Its a message call " + msg);
                    }
                    if (this.notReady.isEmpty()) ** GOTO lbl66
                    System.out.println("not Ready list  :" + this.notReady.toString());
                    if (msg.getDest() != null) ** GOTO lbl59
                    i = 0;
                    if (true) ** GOTO lbl90
lbl59:
                    // 1 sources

                    i = 0;
                    while (i < this.notReady.size()) {
                        if (msg.getDest() == this.notReady.elementAt(i)) {
                            this.passDown(evt);
                            return;
                        }
                        ++i;
                    }
lbl66:
                    // 2 sources

                    if (this.desKey == null) break;
                    if (Trace.trace) {
                        Trace.info(" ENCRYPT1_4.down()", "DESkey is not null, I know it ");
                    }
                    try {
                        if (msg.getBuffer() != null) {
                            this.cipher.init(1, this.desKey);
                            msg.setBuffer(this.cipher.doFinal(msg.getBuffer()));
                            msg.putHeader("encrypt", new EncryptHeader(0));
                            if (!Trace.trace) break;
                            Trace.info(" ENCRYPT1_4.down()", " have DES key , package sent");
                            break;
                        }
                        msg.setBuffer(null);
                        msg.putHeader("encrypt", new EncryptHeader(0));
                        if (!Trace.trace) break;
                        Trace.info(" ENCRYPT1_4.down()", " buffer null, added header");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
            }
            break block25;
            do {
                newMsg = new Message((Address)this.notReady.elementAt(i), this.local_addr, msg.getBuffer());
                this.passDown(new Event(1, newMsg));
                ++i;
lbl90:
                // 2 sources

            } while (i < this.notReady.size());
        }
        if (Trace.trace) {
            Trace.info(" ENCRYPT1_4.down()", "Pass Down: " + evt.toString());
        }
        this.passDown(evt);
    }

    private final SecretKey decodedKey(byte[] encodedKey) {
        SecretKey key = null;
        try {
            SecretKeyFactory KeyFac = SecretKeyFactory.getInstance(this.getAlgorithm(this.symAlgorithm));
            SecretKeySpec desKeySpec = new SecretKeySpec(encodedKey, this.getAlgorithm(this.symAlgorithm));
            key = KeyFac.generateSecret(desKeySpec);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return key;
    }

    private final PublicKey generatePubKey(byte[] encodedKey) {
        PublicKey pubKey = null;
        try {
            KeyFactory KeyFac = KeyFactory.getInstance(this.getAlgorithm(this.asymAlgorithm));
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(encodedKey);
            pubKey = KeyFac.generatePublic(x509KeySpec);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pubKey;
    }

    private final /* synthetic */ void this() {
        this.local_addr = null;
        this.keyServerAddr = null;
        this.keyServer = false;
        this.asymAlgorithm = "RSA";
        this.symAlgorithm = "DES/ECB/PKCS5Padding";
        this.asymInit = 512;
        this.symInit = 56;
        this.desKey = null;
        this.pubKey = null;
        this.serverPubKey = null;
        this.members = new Vector();
        this.notReady = new Vector();
    }

    public ENCRYPT1_4() {
        this.this();
    }

    public static class EncryptHeader
    extends Header {
        static final int ENCRYPT = 0;
        static final int KEY_REQUEST = 1;
        static final int SERVER_PUBKEY = 2;
        static final int SECRETKEY = 3;
        static final int SECRETKEY_READY = 4;
        static final String KEY = "encrypt";
        int type;

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.type);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readInt();
        }

        public String toString() {
            return "[ENCTYPT: <variables> ]";
        }

        public EncryptHeader() {
        }

        public EncryptHeader(int type) {
            this.type = type;
        }
    }
}

