/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Properties;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Message;
import org.javagroups.log.Trace;
import org.javagroups.stack.MessageProtocol;
import org.javagroups.util.ReusableThread;
import org.javagroups.util.RspList;
import org.javagroups.util.Util;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FLOW_CONTROL
extends MessageProtocol
implements Runnable {
    private static final String FLOW_CONTROL = "FLOW_CONTROL";
    private int _numMSGsSentThisPeriod;
    private HashMap _rcvdMSGCounter;
    private int _windowSize;
    private int _fwdMarginSize;
    private int _estimatedRTT;
    private boolean waitingForResponse;
    private ReusableThread _reusableThread;
    private double RTT_WEIGHT;
    private int _msgsSentAfterFCreq;
    private double TIME_OUT_FACTOR;
    private double TIME_OUT_INCR_MULT;
    private double WINDOW_SIZE_REDUCTION;
    private double WINDOW_SIZE_EXPANSION;
    private boolean isBlockState;
    private int _windowsize_cap;

    public String getName() {
        return FLOW_CONTROL;
    }

    public boolean handleDownEvent(Event evt) {
        if (evt.getType() == 1) {
            ++this._numMSGsSentThisPeriod;
            if (this._numMSGsSentThisPeriod > this._windowSize - this._fwdMarginSize && !this.waitingForResponse) {
                this.waitingForResponse = true;
                this._reusableThread.waitUntilDone();
                this._reusableThread.assignTask(this);
            }
            if (this.waitingForResponse) {
                ++this._msgsSentAfterFCreq;
                if (this._msgsSentAfterFCreq >= this._fwdMarginSize && !this.isBlockState) {
                    if (Trace.trace) {
                        Trace.info("FLOW_CONTROL.handleDownEvent()", "ACTION BLOCK");
                    }
                    System.err.println("0;" + System.currentTimeMillis() + ';' + this._windowSize);
                    this.passUp(new Event(54));
                    this.isBlockState = true;
                }
            }
        }
        return true;
    }

    public boolean handleUpEvent(Event evt) {
        if (evt.getType() == 1) {
            Message msg = (Message)evt.getArg();
            Address src = msg.getSrc();
            FCInfo fcForSrc = (FCInfo)this._rcvdMSGCounter.get(src);
            if (fcForSrc == null) {
                fcForSrc = new FCInfo();
                this._rcvdMSGCounter.put(src, fcForSrc);
            }
            fcForSrc.increment(1);
            if (Trace.trace) {
                Trace.info("FLOW_CONTROL.handleUpEvent()", "message (" + fcForSrc.getRcvdMSGCount() + ") received from " + src);
            }
        }
        return true;
    }

    public Object handle(Message req) {
        Address src = req.getSrc();
        Long resp = new Long(((FCInfo)this._rcvdMSGCounter.get(src)).getRcvdMSGCount());
        if (Trace.trace) {
            Trace.info("FLOW_CONTROL.handle()", "Reqest came from " + src + " Prepared response " + resp);
        }
        return resp;
    }

    public void run() {
        if (Trace.trace) {
            Trace.info("FLOW_CONTROL.run()", "--- hit the _fwdMargin. Remaining size " + this._fwdMarginSize);
        }
        this.reqFCInfo();
    }

    public boolean setProperties(Properties props) {
        String str = null;
        String winsizekey = "window_size";
        String fwdmrgnkey = "fwd_mrgn";
        String rttweightkey = "rttweight";
        String sizereductionkey = "reduction";
        String sizeexpansionkey = "expansion";
        String windowsizeCapKey = "window_size_cap";
        str = props.getProperty(windowsizeCapKey);
        if (str != null) {
            this._windowsize_cap = Integer.parseInt(str);
            props.remove(windowsizeCapKey);
        }
        if ((str = props.getProperty(winsizekey)) != null) {
            this._windowSize = Integer.parseInt(str);
            if (this._windowSize > this._windowsize_cap) {
                this._windowSize = this._windowsize_cap;
            }
            props.remove(winsizekey);
        }
        if ((str = props.getProperty(fwdmrgnkey)) != null) {
            this._fwdMarginSize = Integer.parseInt(str);
            props.remove(fwdmrgnkey);
        }
        if ((str = props.getProperty(rttweightkey)) != null) {
            this.RTT_WEIGHT = Double.parseDouble(str);
            props.remove(rttweightkey);
        }
        if ((str = props.getProperty(sizereductionkey)) != null) {
            this.WINDOW_SIZE_REDUCTION = Double.parseDouble(str);
            props.remove(sizereductionkey);
        }
        if ((str = props.getProperty(sizeexpansionkey)) != null) {
            this.WINDOW_SIZE_EXPANSION = Double.parseDouble(str);
            props.remove(sizeexpansionkey);
        }
        if (props.size() > 0) {
            System.err.println("FLOW_CONTROL.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    private final RspList reqFCInfo() {
        RspList rspList = null;
        long reqSentTime = 0L;
        long rspRcvdTime = 0L;
        try {
            reqSentTime = System.currentTimeMillis();
            rspList = this.castMessage(null, new Message(null, null, Util.objectToByteBuffer(FLOW_CONTROL)), 2, 0L);
            rspRcvdTime = System.currentTimeMillis();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        long currentRTT = rspRcvdTime - reqSentTime;
        if (currentRTT > (long)this._estimatedRTT) {
            this._windowSize = (int)((double)this._windowSize * this.WINDOW_SIZE_REDUCTION);
            this._fwdMarginSize = (int)((double)this._fwdMarginSize * this.WINDOW_SIZE_REDUCTION);
        } else {
            this._windowSize = (int)((double)this._windowSize * this.WINDOW_SIZE_EXPANSION);
            if (this._windowSize > this._windowsize_cap) {
                this._windowSize = this._windowsize_cap;
            }
            this._fwdMarginSize = (int)((double)this._fwdMarginSize * this.WINDOW_SIZE_EXPANSION);
        }
        this._estimatedRTT = (int)(this.RTT_WEIGHT * (double)currentRTT + (1.0 - this.RTT_WEIGHT) * (double)this._estimatedRTT);
        this._numMSGsSentThisPeriod = 0;
        this.waitingForResponse = false;
        this._msgsSentAfterFCreq = 0;
        if (this.isBlockState) {
            if (Trace.trace) {
                Trace.warn("FLOW_CONTROL.reqFCInfo()", "ACTION UNBLOCK");
            }
            this.passUp(new Event(55));
            System.err.println("1;" + System.currentTimeMillis() + ';' + this._windowSize);
            this.isBlockState = false;
        }
        if (Trace.trace) {
            Trace.warn("FLOW_CONTROL.reqFCInfo()", "estimatedTimeout = " + this._estimatedRTT);
            Trace.warn("FLOW_CONTROL.reqFCInfo()", "window size = " + this._windowSize + " forward margin size = " + this._fwdMarginSize);
        }
        return rspList;
    }

    private final /* synthetic */ void this() {
        this._numMSGsSentThisPeriod = 0;
        this._rcvdMSGCounter = new HashMap();
        this._windowSize = 1000;
        this._fwdMarginSize = 200;
        this._estimatedRTT = 100000;
        this.waitingForResponse = false;
        this.RTT_WEIGHT = 0.125;
        this._msgsSentAfterFCreq = 0;
        this.TIME_OUT_FACTOR = 0.25;
        this.TIME_OUT_INCR_MULT = 1.25;
        this.WINDOW_SIZE_REDUCTION = 0.75;
        this.WINDOW_SIZE_EXPANSION = 1.25;
        this.isBlockState = false;
        this._windowsize_cap = 1000000;
    }

    public FLOW_CONTROL() {
        this.this();
        this._reusableThread = new ReusableThread(FLOW_CONTROL);
    }

    private class FCInfo
    implements Serializable {
        int _curValue;

        public void increment(int i) {
            this._curValue += i;
        }

        public int getRcvdMSGCount() {
            return this._curValue;
        }

        public String toString() {
            return Integer.toString(this._curValue);
        }
    }
}

