/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Header;
import org.javagroups.Message;
import org.javagroups.View;
import org.javagroups.ViewId;
import org.javagroups.log.Trace;
import org.javagroups.protocols.PingHeader;
import org.javagroups.protocols.PingRsp;
import org.javagroups.protocols.WanPipeAddress;
import org.javagroups.stack.Protocol;
import org.javagroups.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class WANPING
extends Protocol {
    Vector members;
    Vector initial_members;
    Address local_addr;
    String group_addr;
    String groupname;
    long timeout;
    long num_initial_members;
    int port_range;
    List initial_hosts;
    boolean is_server;

    public String getName() {
        return "WANPING";
    }

    public Vector providedUpServices() {
        Vector<Integer> ret = new Vector<Integer>();
        ret.addElement(new Integer(12));
        return ret;
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("timeout");
        if (str != null) {
            this.timeout = new Long(str);
            props.remove("timeout");
        }
        if ((str = props.getProperty("port_range")) != null) {
            this.port_range = new Integer(str);
            props.remove("port_range");
        }
        if ((str = props.getProperty("num_initial_members")) != null) {
            this.num_initial_members = new Integer(str).intValue();
            props.remove("num_initial_members");
        }
        if ((str = props.getProperty("initial_hosts")) != null) {
            props.remove("initial_hosts");
            this.initial_hosts = this.createInitialHosts(str);
            if (Trace.trace) {
                Trace.info("WANPING.setProperties()", "initial_hosts: " + this.initial_hosts);
            }
        }
        if (this.initial_hosts == null || this.initial_hosts.size() == 0) {
            System.err.println("WANPING.setProperties(): hosts to contact for initial membership not specified. Cannot determine coordinator !");
            return false;
        }
        if (props.size() > 0) {
            System.err.println("WANPING.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                Header obj = msg.getHeader(this.getName());
                if (obj == null || !(obj instanceof PingHeader)) {
                    this.passUp(evt);
                    return;
                }
                PingHeader hdr = (PingHeader)msg.removeHeader(this.getName());
                switch (hdr.type) {
                    case 1: {
                        Address coord;
                        if (!this.is_server) {
                            return;
                        }
                        Vector vector = this.members;
                        synchronized (vector) {
                            Address address = this.members.size() > 0 ? (Address)this.members.firstElement() : this.local_addr;
                            coord = address;
                        }
                        Message rsp_msg = new Message(msg.getSrc(), null, null);
                        PingHeader rsp_hdr = new PingHeader(2, new PingRsp(this.local_addr, coord));
                        rsp_msg.putHeader(this.getName(), rsp_hdr);
                        this.passDown(new Event(1, rsp_msg));
                        return;
                    }
                    case 2: {
                        PingRsp rsp = (PingRsp)hdr.arg;
                        Vector vector = this.initial_members;
                        synchronized (vector) {
                            this.initial_members.addElement(rsp);
                            this.initial_members.notify();
                            return;
                        }
                    }
                }
                System.err.println("WANPING.up(): got WANPING header with unknown type (" + hdr.type + ')');
                return;
            }
            case 8: {
                this.passUp(evt);
                this.local_addr = (Address)evt.getArg();
                return;
            }
        }
        this.passUp(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void down(Event evt) {
        gossip_rsps = null;
        switch (evt.getType()) {
            case 12: {
                System.out.println("WANPING.FIND_INITIAL_MBRS");
                hdr = new PingHeader(1, null);
                msg = new Message(null, null, null);
                msg.putHeader(this.getName(), hdr);
                System.out.println("Sending PING to " + this.initial_hosts);
                en = this.initial_hosts.elements();
                while (true) {
                    if (!en.hasMoreElements()) {
                        var11_5 = this.initial_members;
                        // MONITORENTER : var11_5
                        ** try [egrp 0[TRYBLOCK] [2 : 257->329)] { 
lbl15:
                        // 1 sources

                        break;
                    }
                    h = (String)en.nextElement();
                    copy = msg.copy();
                    copy.setDest(new WanPipeAddress(h));
                    if (Trace.trace) {
                        System.out.println("WANPING.down(FIND_INITIAL_MBRS): sending PING request to " + copy.getDest());
                    }
                    this.passDown(new Event(1, copy));
                }
                {
                    this.initial_members.removeAllElements();
                    start_time = System.currentTimeMillis();
                    time_to_wait = this.timeout;
                }
lbl27:
                // 1 sources

                catch (Throwable v0) {
                    // MONITOREXIT : var11_5
                    throw v0;
                }
                while (true) {
                    if ((long)this.initial_members.size() >= this.num_initial_members || time_to_wait <= 0L) break;
                    try {
                        this.initial_members.wait(time_to_wait);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    time_to_wait -= System.currentTimeMillis() - start_time;
                }
                // MONITOREXIT : var11_5
                System.out.println("Initial members are " + this.initial_members);
                this.passUp(new Event(13, this.initial_members));
                return;
            }
            case 6: 
            case 15: {
                tmp = ((View)evt.getArg()).getMembers();
                if (tmp != null) {
                    var14_12 = this.members;
                    // MONITORENTER : var14_12
                    this.members.removeAllElements();
                    i = 0;
                    while (true) {
                        if (i >= tmp.size()) {
                            // MONITOREXIT : var14_12
                            break;
                        }
                        this.members.addElement(tmp.elementAt(i));
                        ++i;
                    }
                }
                this.passDown(evt);
                return;
            }
            case 16: {
                this.passDown(evt);
                this.is_server = true;
                return;
            }
            case 2: {
                this.group_addr = (String)evt.getArg();
                this.passDown(evt);
                return;
            }
            case 4: {
                this.passDown(evt);
                return;
            }
        }
        this.passDown(evt);
    }

    private final View makeView(Vector mbrs) {
        Address coord = null;
        long id = 0L;
        ViewId view_id = new ViewId(this.local_addr);
        coord = view_id.getCoordAddress();
        id = view_id.getId();
        return new View(coord, id, mbrs);
    }

    private final List createInitialHosts(String l) {
        List tmp = new List();
        StringTokenizer tok = new StringTokenizer(l, ",");
        while (tok.hasMoreTokens()) {
            try {
                String t = tok.nextToken();
                tmp.add(t.trim());
            }
            catch (NumberFormatException e) {
                System.err.println("WANPING.createInitialHosts(): " + e);
            }
        }
        return tmp;
    }

    private final /* synthetic */ void this() {
        this.members = new Vector();
        this.initial_members = new Vector();
        this.local_addr = null;
        this.group_addr = null;
        this.groupname = null;
        this.timeout = 3000L;
        this.num_initial_members = 2;
        this.port_range = 5;
        this.initial_hosts = null;
        this.is_server = false;
    }

    public WANPING() {
        this.this();
    }
}

