/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.stack;

import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.javagroups.Event;
import org.javagroups.log.Trace;
import org.javagroups.stack.Protocol;
import org.javagroups.stack.ProtocolStack;

public class Configurator {
    public Protocol setupProtocolStack(String configuration, ProtocolStack st) throws Exception {
        Protocol protocol_stack = null;
        Vector protocol_configs = this.parseConfigurations(configuration);
        Vector protocols = this.createProtocols(protocol_configs, st);
        if (protocols == null) {
            return null;
        }
        protocol_stack = this.connectProtocols(protocols);
        return protocol_stack;
    }

    public void startProtocolStack(Protocol bottom_prot) {
        while (bottom_prot != null) {
            bottom_prot.startDownHandler();
            bottom_prot.startUpHandler();
            bottom_prot = bottom_prot.getUpProtocol();
        }
    }

    public void stopProtocolStack(Protocol start_prot) {
        while (start_prot != null) {
            start_prot.stopInternal();
            start_prot.destroy();
            start_prot = start_prot.getDownProtocol();
        }
    }

    public Protocol findProtocol(Protocol prot_stack, String name) {
        Protocol curr_prot = prot_stack;
        while (true) {
            String s;
            if ((s = curr_prot.getName()) == null) {
                continue;
            }
            if (s.equals(name)) {
                return curr_prot;
            }
            if ((curr_prot = curr_prot.getDownProtocol()) == null) break;
        }
        return null;
    }

    public Protocol getBottommostProtocol(Protocol prot_stack) throws Exception {
        Protocol tmp = null;
        Protocol curr_prot = prot_stack;
        while ((tmp = curr_prot.getDownProtocol()) != null) {
            curr_prot = tmp;
        }
        return curr_prot;
    }

    public Protocol createProtocol(String prot_spec, ProtocolStack stack) throws Exception {
        if (prot_spec == null) {
            throw new Exception("Configurator.createProtocol(): prot_spec is null");
        }
        ProtocolConfiguration config = new ProtocolConfiguration(prot_spec);
        Protocol prot = config.createLayer(stack);
        prot.startDownHandler();
        prot.startUpHandler();
        return prot;
    }

    public void insertProtocol(Protocol prot, int position, String neighbor_prot, ProtocolStack stack) throws Exception {
        if (neighbor_prot == null) {
            throw new Exception("Configurator.insertProtocol(): neighbor_prot is null");
        }
        if (position != 1 && position != 2) {
            throw new Exception("Configurator.insertProtocol(): position has to be ABOVE or BELOW");
        }
    }

    public void removeProtocol(String prot_name) throws Exception {
    }

    private final Protocol connectProtocols(Vector protocol_list) {
        Protocol current_layer = null;
        Protocol next_layer = null;
        int i = 0;
        while (i < protocol_list.size()) {
            current_layer = (Protocol)protocol_list.elementAt(i);
            if (i + 1 >= protocol_list.size()) break;
            next_layer = (Protocol)protocol_list.elementAt(i + 1);
            current_layer.setUpProtocol(next_layer);
            next_layer.setDownProtocol(current_layer);
            ++i;
        }
        return current_layer;
    }

    public Vector parseComponentStrings(String config_str, String delimiter) {
        Vector<String> retval = new Vector<String>();
        StringTokenizer tok = new StringTokenizer(config_str, delimiter, false);
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            retval.addElement(token);
        }
        return retval;
    }

    public Vector parseConfigurations(String configuration) throws Exception {
        Vector<ProtocolConfiguration> retval = new Vector<ProtocolConfiguration>();
        Vector component_strings = this.parseComponentStrings(configuration, ":");
        if (component_strings == null) {
            return null;
        }
        int i = 0;
        while (i < component_strings.size()) {
            String component_string = (String)component_strings.elementAt(i);
            ProtocolConfiguration protocol_config = new ProtocolConfiguration(component_string);
            retval.addElement(protocol_config);
            ++i;
        }
        return retval;
    }

    private final Vector createProtocols(Vector protocol_configs, ProtocolStack stack) throws Exception {
        Vector<Protocol> retval = new Vector<Protocol>();
        int i = 0;
        while (i < protocol_configs.size()) {
            ProtocolConfiguration protocol_config = (ProtocolConfiguration)protocol_configs.elementAt(i);
            Protocol layer = protocol_config.createLayer(stack);
            if (layer == null) {
                return null;
            }
            retval.addElement(layer);
            ++i;
        }
        this.sanityCheck(retval);
        return retval;
    }

    public void sanityCheck(Vector protocols) throws Exception {
        ProtocolReq req;
        int j;
        Protocol prot;
        Vector<String> names = new Vector<String>();
        Vector<ProtocolReq> req_list = new Vector<ProtocolReq>();
        int i = 0;
        while (i < protocols.size()) {
            prot = (Protocol)protocols.elementAt(i);
            String name = prot.getName();
            j = 0;
            while (j < names.size()) {
                if (name.equals(names.elementAt(j))) {
                    throw new Exception("Configurator.sanityCheck(): protocol name " + name + " has been used more than once; protocol names have to be unique !");
                }
                ++j;
            }
            names.addElement(name);
            ++i;
        }
        i = 0;
        while (i < protocols.size()) {
            prot = (Protocol)protocols.elementAt(i);
            req = new ProtocolReq(prot.getName());
            req.up_reqs = prot.requiredUpServices();
            req.down_reqs = prot.requiredDownServices();
            req.up_provides = prot.providedUpServices();
            req.down_provides = prot.providedDownServices();
            req_list.addElement(req);
            ++i;
        }
        i = 0;
        while (i < req_list.size()) {
            int evt_type;
            req = (ProtocolReq)req_list.elementAt(i);
            if (req.up_reqs != null) {
                j = 0;
                while (j < req.up_reqs.size()) {
                    evt_type = (Integer)req.up_reqs.elementAt(j);
                    if (!this.providesDownServices(i, req_list, evt_type)) {
                        throw new Exception("Configurator.sanityCheck(): event " + Event.type2String(evt_type) + " is required by " + req.name + ", but not provided by any of the layers above");
                    }
                    ++j;
                }
            }
            if (req.down_reqs != null) {
                j = 0;
                while (j < req.down_reqs.size()) {
                    evt_type = (Integer)req.down_reqs.elementAt(j);
                    if (!this.providesUpServices(i, req_list, evt_type)) {
                        throw new Exception("Configurator.sanityCheck(): event " + Event.type2String(evt_type) + " is required by " + req.name + ", but not provided by any of the layers below");
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    boolean providesUpServices(int end_index, Vector req_list, int evt_type) {
        int i = 0;
        while (i < end_index) {
            ProtocolReq req = (ProtocolReq)req_list.elementAt(i);
            if (req.providesUpService(evt_type)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean providesDownServices(int start_index, Vector req_list, int evt_type) {
        int i = start_index;
        while (i < req_list.size()) {
            ProtocolReq req = (ProtocolReq)req_list.elementAt(i);
            if (req.providesDownService(evt_type)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Configurator <string>");
            System.exit(0);
        }
        String config_str = args[0];
        Configurator conf = new Configurator();
        Vector protocols = null;
        try {
            Vector protocol_configs = conf.parseConfigurations(config_str);
            protocols = conf.createProtocols(protocol_configs, null);
            if (protocols == null) {
                return;
            }
            Protocol protocol_stack = conf.connectProtocols(protocols);
            Thread.currentThread();
            Thread.sleep(3000L);
            conf.stopProtocolStack(protocol_stack);
        }
        catch (Exception e) {
            System.err.println(e);
        }
        System.err.println(protocols);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class ProtocolReq {
        Vector up_reqs;
        Vector down_reqs;
        Vector up_provides;
        Vector down_provides;
        String name;

        boolean providesUpService(int evt_type) {
            if (this.up_provides != null) {
                int i = 0;
                while (i < this.up_provides.size()) {
                    int type = (Integer)this.up_provides.elementAt(i);
                    if (type == evt_type) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }

        boolean providesDownService(int evt_type) {
            if (this.down_provides != null) {
                int i = 0;
                while (i < this.down_provides.size()) {
                    int type = (Integer)this.down_provides.elementAt(i);
                    if (type == evt_type) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }

        public String toString() {
            StringBuffer ret = new StringBuffer();
            ret.append("\n" + this.name + ':');
            if (this.up_reqs != null) {
                ret.append("\nRequires from above: " + this.printUpReqs());
            }
            if (this.down_reqs != null) {
                ret.append("\nRequires from below: " + this.printDownReqs());
            }
            if (this.up_provides != null) {
                ret.append("\nProvides to above: " + this.printUpProvides());
            }
            if (this.down_provides != null) {
                ret.append("\nProvides to below: " + this.printDownProvides());
            }
            return ret.toString();
        }

        String printUpReqs() {
            StringBuffer ret = new StringBuffer("[");
            if (this.up_reqs != null) {
                int i = 0;
                while (i < this.up_reqs.size()) {
                    ret.append(Event.type2String((Integer)this.up_reqs.elementAt(i)) + ' ');
                    ++i;
                }
            }
            return ret.toString() + ']';
        }

        String printDownReqs() {
            StringBuffer ret = new StringBuffer("[");
            if (this.down_reqs != null) {
                int i = 0;
                while (i < this.down_reqs.size()) {
                    ret.append(Event.type2String((Integer)this.down_reqs.elementAt(i)) + ' ');
                    ++i;
                }
            }
            return ret.toString() + ']';
        }

        String printUpProvides() {
            StringBuffer ret = new StringBuffer("[");
            if (this.up_provides != null) {
                int i = 0;
                while (i < this.up_provides.size()) {
                    ret.append(Event.type2String((Integer)this.up_provides.elementAt(i)) + ' ');
                    ++i;
                }
            }
            return ret.toString() + ']';
        }

        String printDownProvides() {
            StringBuffer ret = new StringBuffer("[");
            if (this.down_provides != null) {
                int i = 0;
                while (i < this.down_provides.size()) {
                    ret.append(Event.type2String((Integer)this.down_provides.elementAt(i)) + ' ');
                    ++i;
                }
            }
            return ret.toString() + ']';
        }

        private final /* synthetic */ void this() {
            this.up_reqs = null;
            this.down_reqs = null;
            this.up_provides = null;
            this.down_provides = null;
            this.name = null;
        }

        ProtocolReq(String name) {
            this.this();
            this.name = name;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class ProtocolConfiguration {
        private String protocol_name;
        private String properties_str;
        private Properties properties;
        private final String protocol_prefix = "org.javagroups.protocols";

        public String getProtocolName() {
            return this.protocol_name;
        }

        public Properties getProperties() {
            return this.properties;
        }

        void setContents(String config_str) throws Exception {
            Vector components;
            int index = config_str.indexOf(40);
            int end_index = config_str.lastIndexOf(41);
            if (index == -1) {
                this.protocol_name = config_str;
            } else {
                if (end_index == -1) {
                    throw new Exception("Configurator.ProtocolConfiguration.setContents(): closing ')' not found in " + config_str + ": properties cannot be set !");
                }
                this.properties_str = config_str.substring(index + 1, end_index);
                this.protocol_name = config_str.substring(0, index);
            }
            if (this.properties_str != null && (components = Configurator.this.parseComponentStrings(this.properties_str, ";")).size() > 0) {
                int i = 0;
                while (i < components.size()) {
                    String comp = (String)components.elementAt(i);
                    index = comp.indexOf(61);
                    if (index == -1) {
                        throw new Exception("Configurator.ProtocolConfiguration.setContents(): '=' not found in " + comp);
                    }
                    String name = comp.substring(0, index);
                    String value = comp.substring(index + 1, comp.length());
                    this.properties.put(name, value);
                    ++i;
                }
            }
        }

        Protocol createLayer(ProtocolStack prot_stack) throws Exception {
            Protocol retval = null;
            if (this.protocol_name == null) {
                return null;
            }
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                String defaultProtocolName = "org.javagroups.protocols." + this.protocol_name;
                Class<?> clazz = null;
                try {
                    clazz = loader.loadClass(defaultProtocolName);
                }
                catch (ClassNotFoundException cnfe) {
                    try {
                        loader = this.getClass().getClassLoader();
                        clazz = loader.loadClass(defaultProtocolName);
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    try {
                        loader = this.getClass().getClassLoader();
                        if (clazz == null) {
                            clazz = loader.loadClass(this.protocol_name);
                        }
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    try {
                        loader = Thread.currentThread().getContextClassLoader();
                        if (clazz == null) {
                            clazz = loader.loadClass(this.protocol_name);
                        }
                    }
                    catch (ClassNotFoundException cnfe2) {
                        throw new Exception("Configurator.ProtocolConfiguration.createLayer(): unable to load class for protocol " + this.protocol_name + " (either as an absolute - " + this.protocol_name + " - or relative - " + defaultProtocolName + " - package name)!");
                    }
                }
                retval = (Protocol)clazz.newInstance();
                if (retval == null) {
                    throw new Exception("Configurator.ProtocolConfiguration.createLayer(): creation of instance for protocol " + this.protocol_name + "failed !");
                }
                retval.setProtocolStack(prot_stack);
                if (this.properties != null && !retval.setPropertiesInternal(this.properties)) {
                    return null;
                }
                retval.init();
            }
            catch (InstantiationException inst_ex) {
                Trace.error("Configurator.ProtocolConfiguration.createLayer()", "an instance of " + this.protocol_name + " could not be created. Please check that it implements interface Protocol and that is has a public empty constructor !");
                throw inst_ex;
            }
            return retval;
        }

        public String toString() {
            StringBuffer retval = new StringBuffer();
            retval.append("Protocol: ");
            if (this.protocol_name == null) {
                retval.append("<unknown>");
            } else {
                retval.append(this.protocol_name);
            }
            if (this.properties != null) {
                retval.append("(" + this.properties + ')');
            }
            return retval.toString();
        }

        private final /* synthetic */ void this() {
            this.protocol_name = null;
            this.properties_str = null;
            this.properties = new Properties();
            this.protocol_prefix = "org.javagroups.protocols";
        }

        public ProtocolConfiguration(String config_str) throws Exception {
            this.this();
            this.setContents(config_str);
        }
    }
}

