/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.stack;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import java.util.HashMap;
import org.javagroups.Address;
import org.javagroups.log.Trace;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class IpAddress
implements Address {
    protected static HashMap sAddrCache = new HashMap();
    static final transient char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private InetAddress ip_addr;
    private int port;
    private byte[] additional_data;

    public InetAddress getIpAddress() {
        return this.ip_addr;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isMulticastAddress() {
        boolean bl = false;
        if (this.ip_addr != null) {
            bl = this.ip_addr.isMulticastAddress();
        }
        return bl;
    }

    public byte[] getAdditionalData() {
        return this.additional_data;
    }

    public void setAdditionalData(byte[] additional_data) {
        this.additional_data = additional_data;
    }

    public int compare(IpAddress other) {
        return this.compareTo(other);
    }

    public int compareTo(Object o) {
        int n;
        int rc;
        int n2;
        int h2;
        if (o == null || !(o instanceof IpAddress)) {
            throw new ClassCastException("IpAddress.compareTo(): comparison between different classes");
        }
        IpAddress other = (IpAddress)o;
        if (this.ip_addr == null) {
            if (other.ip_addr == null) {
                int n3;
                if (this.port < other.port) {
                    n3 = -1;
                } else {
                    n3 = 0;
                    if (this.port > other.port) {
                        n3 = 1;
                    }
                }
                return n3;
            }
            return -1;
        }
        int h1 = this.ip_addr.hashCode();
        if (h1 < (h2 = other.ip_addr.hashCode())) {
            n2 = -1;
        } else {
            n2 = 0;
            if (h1 > h2) {
                n2 = rc = 1;
            }
        }
        if (rc != 0) {
            n = rc;
        } else if (this.port < other.port) {
            n = -1;
        } else {
            n = 0;
            if (this.port > other.port) {
                n = 1;
            }
        }
        return n;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        boolean bl = false;
        if (this.compareTo(obj) == 0) {
            bl = true;
        }
        return bl;
    }

    public int hashCode() {
        int retval = this.ip_addr != null ? this.ip_addr.hashCode() + this.port : this.port;
        return retval;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.ip_addr == null) {
            sb.append("<null>");
        } else if (this.ip_addr.isMulticastAddress()) {
            sb.append(this.ip_addr.getHostAddress());
        } else {
            this.appendShortName(this.ip_addr.getHostName(), sb);
        }
        sb.append(":" + this.port);
        if (this.additional_data != null) {
            sb.append(" (additional data: ").append(this.additional_data.length).append(" bytes)");
        }
        return sb.toString();
    }

    private final void appendShortName(String hostname, StringBuffer sb) {
        int index = hostname.indexOf(46);
        if (hostname == null) {
            return;
        }
        if (index > 0 && !Character.isDigit(hostname.charAt(0))) {
            sb.append(hostname.substring(0, index));
        } else {
            sb.append(hostname);
        }
    }

    private static final String addressToString(byte[] address) {
        int q;
        int r = 0;
        int charPos = 15;
        char[] buf = new char[15];
        int dot = 46;
        int i = address[3] & 0xFF;
        do {
            q = i * 52429 >>> 19;
            r = i - ((q << 3) + (q << 1));
            buf[--charPos] = digits[r];
        } while ((i = q) != 0);
        buf[--charPos] = dot;
        i = address[2] & 0xFF;
        do {
            q = i * 52429 >>> 19;
            r = i - ((q << 3) + (q << 1));
            buf[--charPos] = digits[r];
        } while ((i = q) != 0);
        buf[--charPos] = dot;
        i = address[1] & 0xFF;
        do {
            q = i * 52429 >>> 19;
            r = i - ((q << 3) + (q << 1));
            buf[--charPos] = digits[r];
        } while ((i = q) != 0);
        buf[--charPos] = dot;
        i = address[0] & 0xFF;
        do {
            q = i * 52429 >>> 19;
            r = i - ((q << 3) + (q << 1));
            buf[--charPos] = digits[r];
        } while ((i = q) != 0);
        return new String(buf, charPos, 15 - charPos);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        byte[] address = this.ip_addr.getAddress();
        out.write(address);
        out.writeInt(this.port);
        if (this.additional_data != null) {
            out.writeInt(this.additional_data.length);
            out.write(this.additional_data, 0, this.additional_data.length);
        } else {
            out.writeInt(0);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int len = 0;
        byte[] a = new byte[4];
        in.readFully(a);
        this.port = in.readInt();
        this.ip_addr = IpAddress.getIpAddress(a);
        len = in.readInt();
        if (len > 0) {
            this.additional_data = new byte[len];
            in.readFully(this.additional_data, 0, this.additional_data.length);
        }
    }

    protected static InetAddress getIpAddress(byte[] addr) {
        try {
            HashKey key = new HashKey(addr);
            InetAddress result = (InetAddress)sAddrCache.get(key);
            if (result == null) {
                result = InetAddress.getByName(IpAddress.addressToString(addr));
                sAddrCache.put(key, result);
            }
            return result;
        }
        catch (Exception x) {
            x.printStackTrace();
            Trace.error("IpAddress", x.getMessage());
            return null;
        }
    }

    private final /* synthetic */ void this() {
        this.ip_addr = null;
        this.port = 0;
        this.additional_data = null;
    }

    public IpAddress() {
        this.this();
    }

    public IpAddress(String i, int p) {
        this.this();
        try {
            this.ip_addr = InetAddress.getByName(i);
        }
        catch (Exception e) {
            Trace.warn("IpAddress.IpAddress()", "failed to get " + i + ':' + p + ", using \"127.0.0.1\"");
            try {
                this.ip_addr = InetAddress.getByName("127.0.0.1");
            }
            catch (Exception ex) {
                Trace.warn("IpAddress.IpAddress()", "exception: " + ex);
            }
        }
        this.port = p;
    }

    public IpAddress(InetAddress i, int p) {
        this.this();
        this.ip_addr = i;
        this.port = p;
    }

    public IpAddress(int port) {
        this.this();
        try {
            this.ip_addr = InetAddress.getLocalHost();
            this.port = port;
        }
        catch (Exception e) {
            Trace.warn("IpAddress.IpAddress()", "exception: " + e);
        }
    }

    static class HashKey {
        private byte[] mIpAddress;

        public int hashCode() {
            if (this.mIpAddress.length > 0) {
                return this.mIpAddress[0];
            }
            return 0;
        }

        public byte[] getIpBytes() {
            return this.mIpAddress;
        }

        public boolean equals(Object o) {
            if (o != null && o instanceof HashKey) {
                byte[] other = ((HashKey)o).getIpBytes();
                if (other.length != this.mIpAddress.length) {
                    return false;
                }
                boolean result = true;
                int i = 0;
                while (i < other.length && result) {
                    boolean bl = false;
                    if (other[i] == this.mIpAddress[i]) {
                        bl = true;
                    }
                    result &= bl;
                    ++i;
                }
                return result;
            }
            return false;
        }

        public HashKey(byte[] ipaddress) {
            this.mIpAddress = ipaddress == null ? new byte[0] : ipaddress;
        }
    }
}

