/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.stack;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.javagroups.Event;
import org.javagroups.JChannel;
import org.javagroups.Message;
import org.javagroups.Transport;
import org.javagroups.conf.ClassConfigurator;
import org.javagroups.log.Trace;
import org.javagroups.stack.Configurator;
import org.javagroups.stack.Protocol;
import org.javagroups.util.Queue;
import org.javagroups.util.TimeScheduler;
import org.javagroups.util.Util;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ProtocolStack
extends Protocol
implements Transport {
    public static final int ABOVE = 1;
    public static final int BELOW = 2;
    private Protocol top_prot;
    private Protocol bottom_prot;
    private Configurator conf;
    private Object mutex;
    private String setup_string;
    private JChannel channel;
    private Object local_addr;
    private boolean stopped;
    public TimeScheduler timer;

    public Vector getProtocols() {
        Vector<Protocol> v = new Vector<Protocol>();
        Protocol p = this.top_prot;
        while (p != null) {
            v.addElement(p);
            p = p.getDownProtocol();
        }
        return v;
    }

    public String printProtocolSpec(boolean include_properties) {
        StringBuffer sb = new StringBuffer();
        Protocol prot = this.top_prot;
        while (prot != null) {
            Properties props;
            String name = prot.getName();
            if (name == null) continue;
            if (name.equals("ProtocolStack")) break;
            sb.append(name);
            if (include_properties && (props = prot.getProperties()) != null) {
                sb.append("\n");
                Iterator<Map.Entry<Object, Object>> it = props.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<Object, Object> entry = it.next();
                    sb.append("" + entry + '\n');
                }
            }
            sb.append("\n");
            prot = prot.getDownProtocol();
        }
        return sb.toString();
    }

    public void setup() throws Exception {
        if (this.top_prot == null) {
            this.top_prot = this.conf.setupProtocolStack(this.setup_string, this);
            if (this.top_prot == null) {
                throw new Exception("ProtocolStack.setup(): couldn't create protocol stack");
            }
            this.top_prot.setUpProtocol(this);
            this.bottom_prot = this.conf.getBottommostProtocol(this.top_prot);
            this.conf.startProtocolStack(this.bottom_prot);
        }
    }

    public Protocol createProtocol(String prot_spec) throws Exception {
        return this.conf.createProtocol(prot_spec, this);
    }

    public void insertProtocol(Protocol prot, int position, String neighbor_prot) throws Exception {
        this.conf.insertProtocol(prot, position, neighbor_prot, this);
    }

    public void removeProtocol(String prot_name) throws Exception {
        this.conf.removeProtocol(prot_name);
    }

    public Protocol findProtocol(String name) {
        Protocol tmp = this.top_prot;
        while (tmp != null) {
            String prot_name = tmp.getName();
            if (prot_name != null && prot_name.equals(name)) {
                return tmp;
            }
            tmp = tmp.getDownProtocol();
        }
        return null;
    }

    public void destroy() {
        if (this.top_prot != null) {
            this.conf.stopProtocolStack(this.top_prot);
            this.top_prot = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() throws Exception {
        Vector prots = this.getProtocols();
        if (!this.stopped) {
            return;
        }
        this.timer.start();
        Object object = this.mutex;
        synchronized (object) {
            int i = 0;
            while (true) {
                if (i >= prots.size()) {
                    this.stopped = false;
                    return;
                }
                Protocol p = (Protocol)prots.elementAt(i);
                p.start();
                ++i;
            }
        }
    }

    public void startUpHandler() {
    }

    public void startDownHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() {
        if (this.timer != null) {
            try {
                this.timer.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.stopped) {
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            Vector prots = this.getProtocols();
            int i = 0;
            while (true) {
                if (i >= prots.size()) {
                    this.stopped = true;
                    return;
                }
                Protocol p = (Protocol)prots.elementAt(i);
                Queue down_queue = p.getDownQueue();
                if (down_queue != null) {
                    while (down_queue.size() > 0 && !down_queue.closed()) {
                        Util.sleep(100L);
                    }
                }
                p.stop();
                ++i;
            }
        }
    }

    public void stopInternal() {
    }

    public void send(Message msg) throws Exception {
        this.down(new Event(1, msg));
    }

    public Object receive(long timeout) throws Exception {
        throw new Exception("ProtocolStack.receive(): not implemented !");
    }

    public String getName() {
        return "ProtocolStack";
    }

    public void up(Event evt) {
        switch (evt.getType()) {
            case 8: {
                this.local_addr = evt.getArg();
                break;
            }
        }
        if (this.channel != null) {
            this.channel.up(evt);
        }
    }

    public void down(Event evt) {
        if (this.top_prot != null) {
            this.top_prot.receiveDownEvent(evt);
        } else {
            Trace.error("ProtocolStack.down()", "no down protocol available !");
        }
    }

    protected void receiveUpEvent(Event evt) {
        this.up(evt);
    }

    public void startWork() {
    }

    public void stopWork() {
    }

    private final /* synthetic */ void this() {
        this.top_prot = null;
        this.bottom_prot = null;
        this.conf = new Configurator();
        this.mutex = new Object();
        this.channel = null;
        this.local_addr = null;
        this.stopped = true;
        this.timer = new TimeScheduler(5000L);
    }

    public ProtocolStack(JChannel channel, String setup_string) {
        this.this();
        this.setup_string = setup_string;
        this.channel = channel;
        ClassConfigurator.getInstance();
    }
}

