/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.stack;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import org.javagroups.Address;
import org.javagroups.log.Trace;
import org.javagroups.stack.IpAddress;
import org.javagroups.util.List;
import org.javagroups.util.Util;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Router {
    public static final int GET = -10;
    public static final int REGISTER = -11;
    public static final int DUMP = -21;
    Hashtable groups;
    int port;
    ServerSocket srv_sock;
    InetAddress bind_address;

    public void start() {
        if (this.bind_address == null) {
            this.bind_address = this.srv_sock.getInetAddress();
        }
        Date d = new Date();
        if (Trace.trace) {
            Trace.info("Router.start()", "Router started at " + d);
            Trace.info("Router.start()", "Listening on port " + this.port + " bound on address " + this.bind_address + '\n');
        }
        d = null;
        block7: while (true) {
            try {
                Socket sock = this.srv_sock.accept();
                sock.setSoLinger(true, 500);
                IpAddress peer_addr = new IpAddress(sock.getInetAddress(), sock.getPort());
                DataOutputStream output = new DataOutputStream(sock.getOutputStream());
                byte[] buf = Util.objectToByteBuffer(peer_addr);
                output.writeInt(buf.length);
                output.write(buf, 0, buf.length);
                DataInputStream input = new DataInputStream(sock.getInputStream());
                int type = input.readInt();
                String gname = input.readUTF();
                switch (type) {
                    case -10: {
                        this.processGetRequest(sock, output, gname);
                        continue block7;
                    }
                    case -21: {
                        this.processDumpRequest(peer_addr, sock, output);
                        continue block7;
                    }
                    case -11: {
                        int len = input.readInt();
                        buf = new byte[len];
                        input.readFully(buf, 0, buf.length);
                        Address addr = (Address)Util.objectFromByteBuffer(buf);
                        this.addEntry(gname, new AddressEntry(addr, sock, output));
                        new SocketThread(sock, input).start();
                        continue block7;
                    }
                    default: {
                        Trace.error("Router.start()", "request of type " + type + " not recognized");
                        break;
                    }
                }
                continue;
            }
            catch (Exception e) {
                Trace.error("Router.start()", "exception=" + e);
                continue;
            }
            break;
        }
    }

    public void stop() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void processGetRequest(Socket sock, DataOutputStream output, String groupname) {
        List grpmbrs = (List)this.groups.get(groupname);
        List ret = null;
        if (grpmbrs != null && grpmbrs.size() > 0) {
            ret = new List();
            Enumeration e = grpmbrs.elements();
            while (e.hasMoreElements()) {
                AddressEntry entry = (AddressEntry)e.nextElement();
                ret.add(entry.addr);
            }
        }
        try {
            block13: {
                try {
                    if (ret == null || ret.size() == 0) {
                        output.writeInt(0);
                        break block13;
                    }
                    byte[] buf = Util.objectToByteBuffer(ret);
                    output.writeInt(buf.length);
                    output.write(buf, 0, buf.length);
                }
                catch (Exception e) {
                    Trace.error("Router.processGetRequest()", "exception=" + e);
                }
            }
            Object var9_12 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            try {
                if (output != null) {
                    output.close();
                }
                sock.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {
            return;
        }
        if (output != null) {
            output.close();
        }
        sock.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void processDumpRequest(Address peerAddress, Socket sock, DataOutputStream output) {
        block25: {
            block22: {
                sb = new StringBuffer();
                var5_5 = this.groups;
                synchronized (var5_5) {
                    block21: {
                        if (this.groups.size() != 0) break block21;
                        sb.append("empty routing table");
                        break block22;
                    }
                    i = this.groups.keySet().iterator();
                    break block24;
                }
            }
            try {
                try {
                    output.writeUTF(sb.toString());
                }
                catch (Exception e) {
                    Trace.error("Router.processDumpRequest()", "Error sending the answer back to the client: " + e);
                }
                var6_14 = null;
            }
            catch (Throwable var5_6) {
                var6_13 = null;
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (Exception e) {
                    Trace.error("Router.processDumpRequest()", "Error closing the output stream: " + e);
                }
                try {
                    sock.close();
                    throw var5_6;
                }
                catch (Exception e) {
                    Trace.error("Router.processDumpRequest()", "Error closing the socket: " + e);
                }
                throw var5_6;
            }
            ** try [egrp 3[TRYBLOCK] [4 : 280->291)] { 
lbl41:
            // 1 sources

            if (output != null) {
                output.close();
            }
            break block25;
lbl44:
            // 1 sources

            catch (Exception e) {
                Trace.error("Router.processDumpRequest()", "Error closing the output stream: " + e);
            }
        }
        try {}
        catch (Exception e) {
            Trace.error("Router.processDumpRequest()", "Error closing the socket: " + e);
            return;
        }
        sock.close();
        return;
lbl-1000:
        // 1 sources

        {
            block24: {
                gname = (String)i.next();
                sb.append("GROUP: '" + gname + "'\n");
                l = (List)this.groups.get(gname);
                if (l == null) {
                    sb.append("\tnull list of addresses\n");
                } else if (l.size() == 0) {
                    sb.append("\tempty list of addresses\n");
                } else {
                    e = l.elements();
                    while (e.hasMoreElements()) {
                        ae = (AddressEntry)e.nextElement();
                        sb.append("\t");
                        sb.append(ae.toString());
                        sb.append("\n");
                    }
                }
            }
            if (i.hasNext()) ** GOTO lbl-1000
        }
    }

    synchronized void route(Address dest, String dest_group, byte[] msg) {
        if (dest == null) {
            if (dest_group == null) {
                Trace.error("Router.route()", "both dest address and group are null");
                return;
            }
            this.sendToAllMembersInGroup(dest_group, msg);
        } else {
            DataOutputStream out = this.findSocket(dest);
            if (out != null) {
                this.sendToMember(out, msg);
            } else {
                Trace.error("Router.route()", "routing of message to " + dest + " failed; outstream is null !");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void addEntry(String groupname, AddressEntry e) {
        if (groupname == null) {
            Trace.error("Router.addEntry()", "groupname was null, not added !");
            return;
        }
        Hashtable hashtable = this.groups;
        synchronized (hashtable) {
            AddressEntry old_entry;
            List val = (List)this.groups.get(groupname);
            if (val == null) {
                val = new List();
                this.groups.put(groupname, val);
            }
            if (val.contains(e) && (old_entry = (AddressEntry)val.removeElement(e)) != null) {
                old_entry.destroy();
            }
            val.add(e);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void removeEntry(Socket sock) {
        Hashtable hashtable = this.groups;
        synchronized (hashtable) {
            AddressEntry entry;
            List val;
            Enumeration e = this.groups.keys();
            block5: while (true) {
                if (!e.hasMoreElements()) {
                    return;
                }
                val = (List)this.groups.get(e.nextElement());
                Enumeration e2 = val.elements();
                do {
                    if (!e2.hasMoreElements()) continue block5;
                    entry = (AddressEntry)e2.nextElement();
                } while (entry.sock != sock);
                break;
            }
            try {
                entry.sock.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            val.removeElement(entry);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void removeEntry(OutputStream out) {
        Hashtable hashtable = this.groups;
        synchronized (hashtable) {
            AddressEntry entry;
            List val;
            Enumeration e = this.groups.keys();
            block5: while (true) {
                if (!e.hasMoreElements()) {
                    return;
                }
                val = (List)this.groups.get(e.nextElement());
                Enumeration e2 = val.elements();
                do {
                    if (!e2.hasMoreElements()) continue block5;
                    entry = (AddressEntry)e2.nextElement();
                } while (entry.output != out);
                break;
            }
            try {
                if (entry.sock != null) {
                    entry.sock.close();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            val.removeElement(entry);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void removeEntry(String groupname, Address addr) {
        Hashtable hashtable = this.groups;
        synchronized (hashtable) {
            List val = (List)this.groups.get(groupname);
            if (val == null || val.size() == 0) {
                return;
            }
            Enumeration e2 = val.elements();
            while (e2.hasMoreElements()) {
                AddressEntry entry = (AddressEntry)e2.nextElement();
                if (!entry.addr.equals(addr)) continue;
                try {
                    if (entry.sock != null) {
                        entry.sock.close();
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                val.removeElement(entry);
                return;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    DataOutputStream findSocket(Address addr) {
        Hashtable hashtable = this.groups;
        synchronized (hashtable) {
            AddressEntry entry;
            Enumeration e = this.groups.keys();
            block3: while (true) {
                if (!e.hasMoreElements()) {
                    return null;
                }
                List val = (List)this.groups.get(e.nextElement());
                Enumeration e2 = val.elements();
                do {
                    if (!e2.hasMoreElements()) continue block3;
                    entry = (AddressEntry)e2.nextElement();
                } while (!addr.equals(entry.addr));
                break;
            }
            return entry.output;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void sendToAllMembersInGroup(String groupname, byte[] msg) {
        Hashtable hashtable = this.groups;
        synchronized (hashtable) {
            List val = (List)this.groups.get(groupname);
            if (val == null || val.size() == 0) {
                return;
            }
            Enumeration e = val.elements();
            while (e.hasMoreElements()) {
                this.sendToMember(((AddressEntry)e.nextElement()).output, msg);
            }
            return;
        }
    }

    void sendToMember(DataOutputStream out, byte[] msg) {
        try {
            if (out != null) {
                out.writeInt(msg.length);
                out.write(msg, 0, msg.length);
            }
        }
        catch (Exception e) {
            Trace.error("Router.sendToMember()", "exception=" + e);
            this.removeEntry(out);
        }
    }

    public static void main(String[] args) throws Exception {
        int port = 8080;
        Router router = null;
        InetAddress address = null;
        System.out.println("Router is starting...");
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (arg.equals("-help")) {
                System.out.println("Router [-port <port>] [-bindaddress <address>]");
                return;
            }
            if (arg.equals("-port")) {
                port = new Integer(args[++i]);
            } else if (arg.equals("-bindaddress")) {
                address = InetAddress.getByName(args[++i]);
            }
            ++i;
        }
        Trace.init();
        try {
            router = address == null ? new Router(port) : new Router(port, address);
            router.start();
            System.out.println("Router was created at " + new Date());
            System.out.println("Listening on port " + port + " and bound to address " + address);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    private final /* synthetic */ void this() {
        this.groups = new Hashtable();
        this.port = 8080;
        this.srv_sock = null;
    }

    public Router(int port) throws Exception {
        this.this();
        this.port = port;
        this.srv_sock = new ServerSocket(port, 50);
    }

    public Router(int port, InetAddress bind_address) throws Exception {
        this.this();
        this.port = port;
        this.bind_address = bind_address;
        this.srv_sock = new ServerSocket(port, 50, bind_address);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class AddressEntry {
        Address addr;
        Socket sock;
        DataOutputStream output;

        void destroy() {
            if (this.output != null) {
                try {
                    this.output.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.output = null;
            }
            if (this.sock != null) {
                try {
                    this.sock.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.sock = null;
            }
        }

        public boolean equals(Object other) {
            return this.addr.equals(((AddressEntry)other).addr);
        }

        public String toString() {
            return "addr=" + this.addr + ", sock=" + this.sock;
        }

        private final /* synthetic */ void this() {
            this.addr = null;
            this.sock = null;
            this.output = null;
        }

        public AddressEntry(Address addr, Socket sock, DataOutputStream output) {
            this.this();
            this.addr = addr;
            this.sock = sock;
            this.output = output;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class SocketThread
    extends Thread {
        Socket sock;
        DataInputStream input;

        void closeSocket() {
            try {
                if (this.input != null) {
                    this.input.close();
                }
                if (this.sock != null) {
                    this.sock.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void run() {
            Address dst_addr = null;
            while (true) {
                try {
                    byte[] buf;
                    String gname = this.input.readUTF();
                    int len = this.input.readInt();
                    if (len == 0) {
                        dst_addr = null;
                    } else {
                        buf = new byte[len];
                        this.input.readFully(buf, 0, buf.length);
                        dst_addr = (Address)Util.objectFromByteBuffer(buf);
                    }
                    len = this.input.readInt();
                    if (len == 0) {
                        Trace.warn("Router.SocketThread.run()", "received null message");
                        continue;
                    }
                    buf = new byte[len];
                    this.input.readFully(buf, 0, buf.length);
                    Router.this.route(dst_addr, gname, buf);
                }
                catch (IOException io_ex) {
                    if (Trace.trace) {
                        Trace.info("Router.SocketThread.run()", "client " + this.sock.getInetAddress().getHostName() + ':' + this.sock.getPort() + " closed connection; removing it from routing table");
                    }
                    Router.this.removeEntry(this.sock);
                    return;
                }
                catch (Exception e) {
                    Trace.error("Router.SocketThread.run()", "exception=" + e);
                    this.closeSocket();
                    return;
                }
            }
        }

        private final /* synthetic */ void this() {
            this.sock = null;
            this.input = null;
        }

        public SocketThread(Socket sock, DataInputStream ois) {
            this.this();
            this.sock = sock;
            this.input = ois;
        }
    }
}

