/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.tests;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.javagroups.Address;
import org.javagroups.Message;
import org.javagroups.blocks.ConnectionTable;
import org.javagroups.log.Trace;
import org.javagroups.stack.IpAddress;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ConnectionTableTest
implements ConnectionTable.Receiver,
ConnectionTable.ConnectionListener {
    ConnectionTable ct;
    String dst_host;
    int dst_port;

    public void receive(Message m) {
        String s = new String(m.getBuffer());
        System.out.println("<-- " + s + " (from " + m.getSrc() + ')');
    }

    public void connectionOpened(Address peer_addr) {
        System.out.println("** Connection to " + peer_addr + " opened");
    }

    public void connectionClosed(Address peer_addr) {
        System.out.println("** Connection to " + peer_addr + " closed");
    }

    public void start(int local_port, String dst_host, int dst_port, long reaper_interval, long conn_expire_time) throws Exception {
        this.ct = reaper_interval > 0L || conn_expire_time > 0L ? new ConnectionTable(local_port, reaper_interval, conn_expire_time) : new ConnectionTable(local_port);
        this.ct.addConnectionListener(this);
        this.dst_host = dst_host;
        this.dst_port = dst_port;
        this.ct.setReceiver(this);
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            try {
                System.out.print("> ");
                System.out.flush();
                String line = in.readLine();
                if (line.startsWith("quit".toLowerCase()) || line.startsWith("exit".toLowerCase())) break;
                if (line.startsWith("conns")) {
                    System.out.println(this.ct);
                    continue;
                }
                Message msg = new Message((Address)new IpAddress(dst_host, dst_port), null, line.getBytes());
                this.ct.send(msg);
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
        this.ct.stop();
    }

    public static void main(String[] args) {
        String host = "localhost";
        int port = 6666;
        int local_port = 5555;
        long reaper_interval = 0L;
        long conn_expire_time = 0L;
        int i = 0;
        while (i < args.length) {
            String tmp = args[i];
            if (tmp.equals("-local_port")) {
                local_port = Integer.parseInt(args[++i]);
            } else if (tmp.equals("-remote_host")) {
                host = args[++i];
            } else if (tmp.equals("-remote_port")) {
                port = Integer.parseInt(args[++i]);
            } else if (tmp.equals("-reaper_interval")) {
                reaper_interval = Long.parseLong(args[++i]);
            } else if (tmp.equals("-conn_expire_time")) {
                conn_expire_time = Long.parseLong(args[++i]);
            } else {
                ConnectionTableTest.help();
                return;
            }
            ++i;
        }
        try {
            Trace.init();
            if (reaper_interval > 0L || conn_expire_time > 0L) {
                if (reaper_interval <= 0L) {
                    reaper_interval = 60000L;
                }
                if (conn_expire_time <= 0L) {
                    conn_expire_time = 300000L;
                }
                new ConnectionTableTest().start(local_port, host, port, reaper_interval, conn_expire_time);
            } else {
                new ConnectionTableTest().start(local_port, host, port, 0L, 0L);
            }
        }
        catch (Exception ex) {
            System.err.println("ConnectionTableTest.main(): " + ex);
        }
    }

    static void help() {
        System.out.println("ConnectionTableTest [-help] [-local_port <port>] [-remote_host <host>] [-remote_port <port>] [-reaper_interval <interval (msecs)>] [-conn_expire_time <time (msecs)>]");
    }

    private final /* synthetic */ void this() {
        this.ct = null;
        this.dst_host = null;
        this.dst_port = 0;
    }

    public ConnectionTableTest() {
        this.this();
    }
}

