/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.tests;

import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.javagroups.JChannel;
import org.javagroups.Message;
import org.javagroups.MessageListener;
import org.javagroups.blocks.PullPushAdapter;
import org.javagroups.debug.Debugger;
import org.javagroups.log.Trace;
import org.javagroups.util.Util;

public class MessageLoadTest
extends TestCase {
    public static boolean USE_DEBUGGER = false;
    public static boolean CUMMULATIVE = false;
    public static boolean LOOPBACK = false;
    public static int MESSAGE_NUMBER = 5000;
    public static boolean SLEEP_BETWEEN_SENDING = true;
    public static int SLEEP_TIME = 1;
    public static final String NETWORK_TRANSPORT = "UDP(mcast_addr=224.0.0.35;mcast_port=45566;ip_ttl=1;mcast_send_buf_size=150000;mcast_recv_buf_size=80000;down_thread=false):";
    public static final String LOOPBACK_TRANSPORT = "LOOPBACK(down_thread=false;up_thread=false):";
    public static final String JAVAGROUPS_STACK = "PING(timeout=500;num_initial_members=1;down_thread=false;up_thread=false):FD(down_thread=false;up_thread=false):VERIFY_SUSPECT(timeout=1500;down_thread=false;up_thread=false):pbcast.NAKACK(gc_lag=50;retransmit_timeout=300,600,1200,2400,4800;down_thread=false):pbcast.STABLE(desired_avg_gossip=200;down_thread=false;up_thread=false):FRAG(frag_size=4096):pbcast.GMS(join_timeout=5000;join_retry_timeout=1000;shun=false;print_local_addr=false;down_thread=true;up_thread=true)";
    protected JChannel channel1;
    protected PullPushAdapter adapter1;
    protected Debugger debugger1;
    protected JChannel channel2;
    protected PullPushAdapter adapter2;
    protected Debugger debugger2;
    protected boolean finishedReceiving;
    static /* synthetic */ Class class$org$javagroups$tests$MessageLoadTest;

    public static String getProtocolStack() {
        return (LOOPBACK ? LOOPBACK_TRANSPORT : NETWORK_TRANSPORT) + JAVAGROUPS_STACK;
    }

    protected static void printSelectedOptions() {
        System.out.println("will sleep : " + SLEEP_BETWEEN_SENDING);
        if (SLEEP_BETWEEN_SENDING) {
            System.out.println("sleep time : " + SLEEP_TIME);
        }
        System.out.println("msg num : " + MESSAGE_NUMBER);
        System.out.println("loopback : " + LOOPBACK);
    }

    protected void setUp() throws Exception {
        Trace.init();
        MessageLoadTest.printSelectedOptions();
        this.channel1 = new JChannel(MessageLoadTest.getProtocolStack());
        System.out.print("Connecting to channel...");
        this.channel1.connect("LOAD_TEST");
        System.out.println("connected.");
        this.adapter1 = new PullPushAdapter(this.channel1);
        if (USE_DEBUGGER) {
            this.debugger1 = new Debugger(this.channel1, CUMMULATIVE, "channel 1");
            this.debugger1.start();
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        if (!LOOPBACK) {
            this.channel2 = new JChannel(MessageLoadTest.getProtocolStack());
            this.channel2.connect("LOAD_TEST");
            this.adapter2 = new PullPushAdapter(this.channel2);
            if (USE_DEBUGGER) {
                this.debugger2 = new Debugger(this.channel2, CUMMULATIVE, "channel 2");
                this.debugger2.start();
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected void tearDown() throws Exception {
        if (!LOOPBACK) {
            this.adapter2.stop();
            this.channel2.close();
        }
        this.adapter1.stop();
        this.channel1.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testLoad() {
        try {
            startMessage = "start";
            stopMessage = "stop";
            mutex = new Object();
            receivedTimes = new Vector<E>(MessageLoadTest.MESSAGE_NUMBER);
            normalMessages = new Vector<E>(MessageLoadTest.MESSAGE_NUMBER);
            tooQuickMessages = new Vector<E>();
            tooSlowMessages = new Vector<E>();
            if (MessageLoadTest.USE_DEBUGGER) {
                System.out.println("Press any key to continue...");
                try {
                    System.in.read();
                }
                catch (IOException ioex) {
                    // empty catch block
                }
            }
            this.adapter1.setListener(new MessageListener(this, mutex, tooQuickMessages, receivedTimes, normalMessages, tooSlowMessages){
                private boolean started;
                private boolean stopped;
                final /* synthetic */ MessageLoadTest this$0;
                final /* synthetic */ Object val$mutex;
                final /* synthetic */ Vector val$tooQuickMessages;
                final /* synthetic */ Vector val$receivedTimes;
                final /* synthetic */ Vector val$normalMessages;
                final /* synthetic */ Vector val$tooSlowMessages;

                public final byte[] getState() {
                    return null;
                }

                public final void setState(byte[] state) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public final void receive(Message jgMessage) {
                    Object message = jgMessage.getObject();
                    if ("start".equals(message)) {
                        this.started = true;
                        this.this$0.finishedReceiving = false;
                        return;
                    }
                    if ("stop".equals(message)) {
                        this.stopped = true;
                        this.this$0.finishedReceiving = true;
                        Object object = this.val$mutex;
                        synchronized (object) {
                            this.val$mutex.notifyAll();
                            return;
                        }
                    }
                    if (!(message instanceof Long)) return;
                    Long travelTime = new Long(System.currentTimeMillis() - (Long)message);
                    if (!this.started) {
                        this.val$tooQuickMessages.add(message);
                        return;
                    }
                    if (this.started && !this.stopped) {
                        this.val$receivedTimes.add(travelTime);
                        this.val$normalMessages.add(message);
                        return;
                    }
                    this.val$tooSlowMessages.add(message);
                }

                private final /* synthetic */ void this() {
                    this.started = false;
                    this.stopped = false;
                }
                {
                    this.this$0 = messageLoadTest;
                    this.val$mutex = object;
                    this.val$tooQuickMessages = vector;
                    this.val$receivedTimes = vector2;
                    this.val$normalMessages = vector3;
                    this.val$tooSlowMessages = vector4;
                    this.this();
                }
            });
            System.out.println("Free memory: " + Runtime.getRuntime().freeMemory());
            System.out.println("Total memory: " + Runtime.getRuntime().totalMemory());
            System.out.println("Starting sending messages.");
            time = System.currentTimeMillis();
            startJgMessage = new Message();
            startJgMessage.setObject((Serializable)"start");
            sender = MessageLoadTest.LOOPBACK != false ? this.channel1 : this.channel2;
            sender.send(startJgMessage);
            i = 0;
            while (i < MessageLoadTest.MESSAGE_NUMBER) {
                message = new Long(System.currentTimeMillis());
                jgMessage = new Message();
                jgMessage.setObject(message);
                sender.send(jgMessage);
                if (i % 1000 == 0) {
                    System.out.println("sent " + i + " messages.");
                }
                if (MessageLoadTest.SLEEP_BETWEEN_SENDING) {
                    Util.sleep(1L, true);
                }
                ++i;
            }
            stopJgMessage = new Message();
            stopJgMessage.setObject((Serializable)"stop");
            sender.send(stopJgMessage);
            time = System.currentTimeMillis() - time;
            System.out.println("Finished sending messages. Operation took " + time);
            var13_17 = mutex;
            synchronized (var13_17) {
                received = 0;
                if (true) ** GOTO lbl58
                do {
                    mutex.wait(1000L);
                    if (receivedTimes.size() != received) {
                        received = receivedTimes.size();
                        System.out.println();
                        System.out.print("Received " + receivedTimes.size() + " messages.");
                        continue;
                    }
                    System.out.print(".");
lbl58:
                    // 3 sources

                } while (!this.finishedReceiving);
            }
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (Exception avgDeliveryTime) {
                // empty catch block
            }
            avgDeliveryTime = -1.0;
            maxDeliveryTime = -9223372036854775808L;
            minDeliveryTime = 0x7FFFFFFFFFFFFFFFL;
            iterator = receivedTimes.iterator();
            while (iterator.hasNext()) {
                message = (Long)iterator.next();
                avgDeliveryTime = avgDeliveryTime == -1.0 ? (double)message.longValue() : (avgDeliveryTime + message.doubleValue()) / (double)2;
                if (message > maxDeliveryTime) {
                    maxDeliveryTime = message;
                }
                if (message >= minDeliveryTime) continue;
                minDeliveryTime = message;
            }
            System.out.println("Sent " + MessageLoadTest.MESSAGE_NUMBER + " messages.");
            System.out.println("Received " + receivedTimes.size() + " messages.");
            System.out.println("Average delivery time " + avgDeliveryTime + " ms");
            System.out.println("Minimum delivery time " + minDeliveryTime + " ms");
            System.out.println("Maximum delivery time " + maxDeliveryTime + " ms");
            System.out.println("Received " + tooQuickMessages.size() + " too quick messages");
            System.out.println("Received " + tooSlowMessages.size() + " too slow messages");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.out.println("Free memory: " + Runtime.getRuntime().freeMemory());
        System.out.println("Total memory: " + Runtime.getRuntime().totalMemory());
        System.out.println("Performing GC");
        Runtime.getRuntime().gc();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        System.out.println("Free memory: " + Runtime.getRuntime().freeMemory());
        System.out.println("Total memory: " + Runtime.getRuntime().totalMemory());
        if (MessageLoadTest.USE_DEBUGGER == false) return;
        System.out.println("Press any key to finish...");
        try {
            System.in.read();
            return;
        }
        catch (IOException var1_4) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-sleep")) {
                SLEEP_BETWEEN_SENDING = true;
                if (i >= args.length - 1) {
                    throw new RuntimeException("You have to specify sleep time");
                }
                try {
                    SLEEP_TIME = Integer.parseInt(args[++i]);
                }
                catch (NumberFormatException nfex) {
                    throw new RuntimeException("Cannot parse sleep time");
                }
            } else if (args[i].equals("-msg_num")) {
                if (i >= args.length - 1) {
                    throw new RuntimeException("You have to specify messages number");
                }
                try {
                    MESSAGE_NUMBER = Integer.parseInt(args[++i]);
                }
                catch (NumberFormatException nfex) {
                    throw new RuntimeException("Cannot parse messages number");
                }
            } else if (args[i].equals("-loopback")) {
                LOOPBACK = true;
            } else if (args[i].equals("-debug")) {
                USE_DEBUGGER = true;
            } else if (args[i].equals("-cummulative")) {
                CUMMULATIVE = true;
            } else if (args[i].equals("-help")) {
                MessageLoadTest.help();
                return;
            }
            ++i;
        }
        Class clazz = class$org$javagroups$tests$MessageLoadTest;
        if (clazz == null) {
            clazz = class$org$javagroups$tests$MessageLoadTest = MessageLoadTest.class$("[Lorg.javagroups.tests.MessageLoadTest;", false);
        }
        TestRunner.run((Class)clazz);
    }

    static void help() {
        System.out.println("MessageLoadTest [-help] [-sleep <sleep time between sends (ms)>]  [-msg_num <number of msgs to send>] [-debug [-cummulative]] [-loopback]");
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public MessageLoadTest(String string) {
        super(string);
    }
}

