/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.tests;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import org.javagroups.util.Util;

public class Probe {
    MulticastSocket mcast_sock;
    DatagramSocket sock;

    public void start(InetAddress addr, int port, int ttl, long timeout) throws Exception {
        this.mcast_sock = new MulticastSocket(port);
        this.mcast_sock.setTimeToLive(ttl);
        this.mcast_sock.joinGroup(addr);
        this.sock = new DatagramSocket();
        byte[] probe_buf = new byte[]{100, 105, 97, 103};
        DatagramPacket probe = new DatagramPacket(probe_buf, 0, probe_buf.length, addr, port);
        this.sock.send(probe);
        System.out.println("\n-- send probe on " + addr + ':' + port + '\n');
        int i = 0;
        new Thread(this, timeout){
            final /* synthetic */ Probe this$0;
            final /* synthetic */ long val$timeout;

            public final void run() {
                Util.sleep(this.val$timeout);
                this.this$0.sock.close();
            }
            {
                this.this$0 = probe;
                this.val$timeout = l;
            }
        }.start();
        while (true) {
            byte[] buf = new byte[65000];
            DatagramPacket rsp = new DatagramPacket(buf, 0, buf.length);
            try {
                this.sock.receive(rsp);
            }
            catch (Throwable t) {
                System.out.println("\n");
                return;
            }
            System.out.println("\n#" + ++i + ": " + new String(rsp.getData()));
        }
    }

    public static void main(String[] args) {
        InetAddress addr = null;
        int port = 0;
        int ttl = 32;
        long timeout = 10000L;
        try {
            int i = 0;
            while (i < args.length) {
                if (args[i].equals("-addr")) {
                    addr = InetAddress.getByName(args[++i]);
                } else if (args[i].equals("-port")) {
                    port = Integer.parseInt(args[++i]);
                } else if (args[i].equals("-ttl")) {
                    ttl = Integer.parseInt(args[++i]);
                } else if (args[i].equals("-timeout")) {
                    timeout = Long.parseLong(args[++i]);
                } else {
                    Probe.help();
                    return;
                }
                ++i;
            }
            Probe p = new Probe();
            p.start(addr, port, ttl, timeout);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static void help() {
        System.out.println("Probe [-help] [-addr <addr>] [-port <port>] [-ttl <ttl>] [-timeout <timeout>]");
    }
}

