/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.tests;

import org.javagroups.util.LinkedListQueue;
import org.javagroups.util.Queue;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class QueueSpeedTest {
    int num_elements;
    final int NUM = 10;

    public void start() throws Exception {
        double q1 = 0.0;
        double q2 = 0.0;
        System.out.println("warming up cache");
        this.measureQueue();
        this.measureLinkedListQueue();
        System.out.println("running insertions 10 times (will take average)");
        int i = 0;
        while (i < 10) {
            System.out.println("Round #" + (i + 1));
            q1 += (double)this.measureQueue();
            q2 += (double)this.measureLinkedListQueue();
            ++i;
        }
        System.out.println("Time to insert and remove " + this.num_elements + " into Queue:           " + (q1 /= 10.0) + " ms");
        System.out.println("Time to insert and remove " + this.num_elements + " into LinkedListQueue: " + (q2 /= 10.0) + " ms");
        double diff = (long)(q2 - q1);
        System.out.println("diff is " + Math.abs(diff) + "; " + (q2 < q1 ? "LinkedListQueue" : "Queue") + " is faster");
    }

    long measureQueue() throws Exception {
        Queue q = new Queue();
        long start = System.currentTimeMillis();
        int i = 0;
        while (i < this.num_elements) {
            if (i % 2 == 0) {
                q.add(new Integer(i));
            } else {
                q.addAtHead(new Integer(i));
            }
            ++i;
        }
        while (q.size() > 0) {
            q.remove();
        }
        long stop = System.currentTimeMillis();
        return stop - start;
    }

    long measureLinkedListQueue() throws Exception {
        LinkedListQueue q = new LinkedListQueue();
        long start = System.currentTimeMillis();
        int i = 0;
        while (i < this.num_elements) {
            if (i % 2 == 0) {
                q.add(new Integer(i));
            } else {
                q.addAtHead(new Integer(i));
            }
            ++i;
        }
        while (q.size() > 0) {
            q.remove();
        }
        long stop = System.currentTimeMillis();
        return stop - start;
    }

    public static void main(String[] args) {
        int num_elements = 1000000;
        int i = 0;
        while (i < args.length) {
            if (!args[i].equals("-num_elements")) {
                QueueSpeedTest.help();
                return;
            }
            num_elements = Integer.parseInt(args[++i]);
            ++i;
        }
        try {
            new QueueSpeedTest(num_elements).start();
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    static void help() {
        System.out.println("QueueSpeedTest [-help] [-num_elements <num>]");
    }

    private final /* synthetic */ void this() {
        this.num_elements = 1000000;
        this.NUM = 10;
    }

    public QueueSpeedTest(int num_elements) {
        this.this();
        this.num_elements = num_elements;
    }
}

