/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.util;

import java.util.Vector;
import org.javagroups.TimeoutException;
import org.javagroups.log.Trace;
import org.javagroups.util.QueueClosedException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Queue {
    private static final Object endMarker = new Object();
    Element head;
    Element tail;
    boolean closed;
    int size;
    Object mutex;
    int num_markers;

    public Object getFirst() {
        return this.head != null ? this.head.obj : null;
    }

    public Object getLast() {
        return this.tail != null ? this.tail.obj : null;
    }

    public boolean closed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void add(Object obj) throws QueueClosedException {
        if (obj == null) {
            Trace.error("Queue.add()", "argument must not be null");
            return;
        }
        if (this.closed) {
            throw new QueueClosedException();
        }
        if (this.num_markers > 0) {
            throw new QueueClosedException("Queue.add(): queue has been closed. You can not add more elements. Waiting for removal of remaining elements.");
        }
        Object object = this.mutex;
        synchronized (object) {
            block7: {
                Element el;
                block6: {
                    el = new Element(obj);
                    if (this.head != null) break block6;
                    this.tail = this.head = el;
                    this.size = 1;
                    break block7;
                }
                this.tail.next = el;
                this.tail = el;
                ++this.size;
            }
            this.mutex.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addAtHead(Object obj) throws QueueClosedException {
        if (obj == null) {
            Trace.error("Queue.addAtHead()", "argument must not be null");
            return;
        }
        if (this.closed) {
            throw new QueueClosedException();
        }
        if (this.num_markers > 0) {
            throw new QueueClosedException("Queue.addAtHead(): queue has been closed. You can not add more elements. Waiting for removal of remaining elements.");
        }
        Object object = this.mutex;
        synchronized (object) {
            block7: {
                Element el;
                block6: {
                    el = new Element(obj);
                    if (this.head != null) break block6;
                    this.tail = this.head = el;
                    this.size = 1;
                    break block7;
                }
                el.next = this.head;
                this.head = el;
                ++this.size;
            }
            this.mutex.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object remove() throws QueueClosedException {
        retval = null;
        var2_2 = this.mutex;
        synchronized (var2_2) {
            while (true) lbl-1000:
            // 3 sources

            {
                if (this.size != 0) {
                    if (!this.closed) ** break;
                    throw new QueueClosedException();
                }
                if (this.closed) {
                    throw new QueueClosedException();
                }
                try {
                    this.mutex.wait();
                }
                catch (IllegalMonitorStateException ex) {
                    throw ex;
                }
                catch (InterruptedException ex) {
                    // empty catch block
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
            retval = this.removeInternal();
            if (retval == null) {
                Trace.error("Queue.remove()", "element was null, should never be the case");
            }
            ** if (retval != Queue.endMarker) goto lbl29
        }
lbl-1000:
        // 1 sources

        {
            this.close(false);
            throw new QueueClosedException();
        }
lbl29:
        // 1 sources

        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object remove(long timeout) throws QueueClosedException, TimeoutException {
        Object retval = null;
        Object object = this.mutex;
        synchronized (object) {
            block11: {
                if (this.size != 0) break block11;
                if (this.closed) {
                    throw new QueueClosedException();
                }
                try {
                    this.mutex.wait(timeout);
                }
                catch (IllegalMonitorStateException ex) {
                    throw ex;
                }
                catch (IllegalArgumentException ex2) {
                    throw ex2;
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            if (this.closed) {
                throw new QueueClosedException();
            }
            retval = this.removeInternal();
            if (retval == null) {
                throw new TimeoutException();
            }
            if (retval == endMarker) {
                this.close(false);
                throw new QueueClosedException();
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeElement(Object obj) throws QueueClosedException {
        if (obj == null) {
            Trace.error("Queue.removeElement()", "argument must not be null");
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            Element el = this.head;
            if (el == null) {
                return;
            }
            if (el.obj.equals(obj)) {
                this.head = el.next;
                el.next = null;
                if (this.size == 1) {
                    this.tail = this.head;
                }
                this.decrementSize();
                return;
            }
            while (el.next != null) {
                if (el.next.obj.equals(obj)) {
                    Element tmp_el = el.next;
                    if (tmp_el == this.tail) {
                        this.tail = el;
                    }
                    el.next = el.next.next;
                    tmp_el.next = null;
                    this.decrementSize();
                    break;
                }
                el = el.next;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object peek() throws QueueClosedException {
        retval = null;
        var2_2 = this.mutex;
        synchronized (var2_2) {
            while (true) lbl-1000:
            // 3 sources

            {
                if (this.size != 0) {
                    if (!this.closed) ** break;
                    throw new QueueClosedException();
                }
                if (this.closed) {
                    throw new QueueClosedException();
                }
                try {
                    this.mutex.wait();
                }
                catch (IllegalMonitorStateException ex) {
                    throw ex;
                }
                catch (InterruptedException ex) {
                    // empty catch block
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
            v1 = retval = this.head != null ? this.head.obj : null;
            if (retval == null) {
                Trace.error("Queue.peek()", "retval is null: head=" + this.head + ", tail=" + this.tail + ", size()=" + this.size() + ", num_markers=" + this.num_markers + ", closed()=" + this.closed());
            }
            ** if (retval != Queue.endMarker) goto lbl29
        }
lbl-1000:
        // 1 sources

        {
            this.close(false);
            throw new QueueClosedException();
        }
lbl29:
        // 1 sources

        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object peek(long timeout) throws QueueClosedException, TimeoutException {
        Object retval = null;
        Object object = this.mutex;
        synchronized (object) {
            block11: {
                if (this.size != 0) break block11;
                if (this.closed) {
                    throw new QueueClosedException();
                }
                try {
                    this.mutex.wait(timeout);
                }
                catch (IllegalMonitorStateException ex) {
                    throw ex;
                }
                catch (IllegalArgumentException ex2) {
                    throw ex2;
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            if (this.closed) {
                throw new QueueClosedException();
            }
            Object object2 = retval = this.head != null ? this.head.obj : null;
            if (retval == null) {
                throw new TimeoutException();
            }
            if (retval == endMarker) {
                this.close(false);
                throw new QueueClosedException();
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close(boolean flush_entries) {
        if (flush_entries) {
            try {
                this.add(endMarker);
                ++this.num_markers;
                return;
            }
            catch (QueueClosedException queueClosedException) {
                // empty catch block
            }
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            this.closed = true;
            try {
                this.mutex.notifyAll();
            }
            catch (Exception e) {
                Trace.error("Queue.close()", "exception=" + e);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reset() {
        this.num_markers = 0;
        if (!this.closed) {
            this.close(false);
        }
        Object object = this.mutex;
        synchronized (object) {
            this.size = 0;
            this.head = null;
            this.tail = null;
            this.closed = false;
            return;
        }
    }

    public int size() {
        return this.size - this.num_markers;
    }

    public String toString() {
        return "Queue (" + this.size() + ") messages";
    }

    public String debug() {
        return this.toString() + ", head=" + this.head + ", tail=" + this.tail + ", closed()=" + this.closed() + ", contents=" + this.getContents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector getContents() {
        Vector<Object> retval = new Vector<Object>();
        Object object = this.mutex;
        synchronized (object) {
            Element el = this.head;
            while (el != null) {
                retval.addElement(el.obj);
                el = el.next;
            }
            return retval;
        }
    }

    private final Object removeInternal() {
        if (this.head == null) {
            return null;
        }
        Element retval = this.head;
        this.head = this.head.next;
        if (this.head == null) {
            this.tail = null;
        }
        this.decrementSize();
        if (this.head != null && this.head.obj == endMarker) {
            this.closed = true;
        }
        retval.next = null;
        return retval.obj;
    }

    void decrementSize() {
        --this.size;
        if (this.size < 0) {
            this.size = 0;
        }
    }

    private final /* synthetic */ void this() {
        this.head = null;
        this.tail = null;
        this.closed = false;
        this.size = 0;
        this.mutex = new Object();
        this.num_markers = 0;
    }

    public Queue() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Element {
        Object obj;
        Element next;

        public String toString() {
            return this.obj != null ? this.obj.toString() : "null";
        }

        private final /* synthetic */ void this() {
            this.obj = null;
            this.next = null;
        }

        Element(Object o) {
            this.this();
            this.obj = o;
        }
    }
}

