/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.BindException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.StringTokenizer;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Message;
import org.javagroups.log.Trace;
import org.javagroups.stack.IpAddress;

public class Util {
    private static Object mutex = new Object();
    private static ByteArrayOutputStream out_stream = new ByteArrayOutputStream((char)-1);
    public static final int MAX_PORT = 65535;
    public static final String DIAG_GROUP = "DIAG_GROUP-BELA-322649";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object objectFromByteBuffer(byte[] buffer) throws Exception {
        Object object = mutex;
        synchronized (object) {
            if (buffer == null) {
                return null;
            }
            Object retval = null;
            ByteArrayInputStream in_stream = new ByteArrayInputStream(buffer);
            ObjectInputStream in = new ObjectInputStream(in_stream);
            retval = in.readObject();
            in.close();
            if (retval == null) {
                return null;
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] objectToByteBuffer(Object obj) throws Exception {
        byte[] result = null;
        ByteArrayOutputStream byteArrayOutputStream = out_stream;
        synchronized (byteArrayOutputStream) {
            out_stream.reset();
            ObjectOutputStream out = new ObjectOutputStream(out_stream);
            out.writeObject(obj);
            result = out_stream.toByteArray();
            out.close();
            return result;
        }
    }

    public static void sleep(long timeout) {
        try {
            Thread.currentThread();
            Thread.sleep(timeout);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void sleep(long msecs, boolean busy_sleep) {
        if (!busy_sleep) {
            Util.sleep(msecs);
            return;
        }
        long start = System.currentTimeMillis();
        long stop = start + msecs;
        while (stop > start) {
            start = System.currentTimeMillis();
        }
    }

    public static long random(long range) {
        return (long)(Math.random() * 100000.0 % (double)range) + 1L;
    }

    public static void sleepRandom(long timeout) {
        if (timeout <= 0L) {
            Trace.println("Util.sleepRandom()", 4, "timeout must be > 0 !");
            return;
        }
        long r = (int)(Math.random() * 100000.0 % (double)timeout) + 1;
        try {
            Thread.currentThread();
            Thread.sleep(r);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static boolean tossWeightedCoin(double probability) {
        long cutoff;
        long r = Util.random(100L);
        return r < (cutoff = (long)(probability * 100.0));
    }

    public static String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            return "localhost";
        }
    }

    public static void dumpStack(boolean exit) {
        try {
            throw new Exception("Dumping stack:");
        }
        catch (Exception e) {
            e.printStackTrace();
            if (exit) {
                System.exit(0);
            }
            return;
        }
    }

    public static String printStackTrace(Throwable t) {
        StringWriter s = new StringWriter();
        PrintWriter p = new PrintWriter(s);
        t.printStackTrace(p);
        return s.toString();
    }

    public static String printStackTrace() {
        try {
            throw new Exception("Dumping stack:");
        }
        catch (Throwable t) {
            StringWriter s = new StringWriter();
            PrintWriter p = new PrintWriter(s);
            t.printStackTrace(p);
            return s.toString();
        }
    }

    public static String print(Throwable t) {
        return Util.printStackTrace(t);
    }

    public static void crash() {
        System.exit(-1);
    }

    public static String printEvent(Event evt) {
        Message msg;
        if (evt.getType() == 1 && (msg = (Message)evt.getArg()) != null) {
            if (msg.getBuffer() != null) {
                return Util.printMessage(msg);
            }
            return msg.printObjectHeaders();
        }
        return evt.toString();
    }

    public static String printMessage(Message msg) {
        if (msg == null) {
            return "";
        }
        byte[] buf = msg.getBuffer();
        if (buf == null) {
            return null;
        }
        try {
            Object obj = Util.objectFromByteBuffer(buf);
            return obj.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String printMethodCall(Message msg) {
        if (msg == null) {
            return "";
        }
        byte[] buf = msg.getBuffer();
        if (buf == null) {
            return "";
        }
        try {
            Object obj = Util.objectFromByteBuffer(buf);
            return obj.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static void printThreads() {
        Thread[] threads = new Thread[Thread.activeCount()];
        Thread.enumerate(threads);
        System.out.println("------- Threads -------");
        int i = 0;
        while (i < threads.length) {
            System.out.println("#" + i + ": " + threads[i]);
            ++i;
        }
        System.out.println("------- Threads -------\n");
    }

    public static String activeThreads() {
        StringBuffer sb = new StringBuffer();
        Thread[] threads = new Thread[Thread.activeCount()];
        Thread.enumerate(threads);
        sb.append("------- Threads -------\n");
        int i = 0;
        while (i < threads.length) {
            sb.append("#" + i + ": " + threads[i] + '\n');
            ++i;
        }
        sb.append("------- Threads -------\n");
        return sb.toString();
    }

    public static byte[][] fragmentBuffer(byte[] buf, int frag_size) {
        long total_size = buf.length;
        int accumulated_size = 0;
        int tmp_size = 0;
        int index = 0;
        int num_frags = buf.length % frag_size == 0 ? buf.length / frag_size : buf.length / frag_size + 1;
        byte[][] retval = new byte[num_frags][];
        while ((long)accumulated_size < total_size) {
            tmp_size = (long)(accumulated_size + frag_size) <= total_size ? frag_size : (int)(total_size - (long)accumulated_size);
            byte[] fragment = new byte[tmp_size];
            System.arraycopy(buf, accumulated_size, fragment, 0, tmp_size);
            retval[index++] = fragment;
            accumulated_size += tmp_size;
        }
        return retval;
    }

    public static byte[] defragmentBuffer(byte[][] fragments) {
        int total_length = 0;
        int index = 0;
        if (fragments == null) {
            return null;
        }
        int i = 0;
        while (i < fragments.length) {
            if (fragments[i] != null) {
                total_length += fragments[i].length;
            }
            ++i;
        }
        byte[] ret = new byte[total_length];
        i = 0;
        while (i < fragments.length) {
            if (fragments[i] != null) {
                System.arraycopy(fragments[i], 0, ret, index, fragments[i].length);
                index += fragments[i].length;
            }
            ++i;
        }
        return ret;
    }

    public static void printFragments(byte[][] frags) {
        int i = 0;
        while (i < frags.length) {
            System.out.println("'" + new String(frags[i]) + '\'');
            ++i;
        }
    }

    public static String array2String(long[] array) {
        StringBuffer ret = new StringBuffer("[");
        if (array != null) {
            int i = 0;
            while (i < array.length) {
                ret.append("" + array[i] + ' ');
                ++i;
            }
        }
        ret.append("]");
        return ret.toString();
    }

    public static String array2String(int[] array) {
        StringBuffer ret = new StringBuffer("[");
        if (array != null) {
            int i = 0;
            while (i < array.length) {
                ret.append("" + array[i] + ' ');
                ++i;
            }
        }
        ret.append("]");
        return ret.toString();
    }

    public static String array2String(boolean[] array) {
        StringBuffer ret = new StringBuffer("[");
        if (array != null) {
            int i = 0;
            while (i < array.length) {
                ret.append("" + array[i] + ' ');
                ++i;
            }
        }
        ret.append("]");
        return ret.toString();
    }

    public static Vector pickSubset(Vector members, double subset_percentage) {
        Vector ret = new Vector();
        int num_mbrs = members.size();
        if (num_mbrs == 0) {
            return ret;
        }
        int subset_size = (int)Math.ceil((double)num_mbrs * subset_percentage);
        Vector tmp_mbrs = (Vector)members.clone();
        int i = subset_size;
        while (i > 0 && tmp_mbrs.size() > 0) {
            int index = (int)(Math.random() * (double)num_mbrs % (double)tmp_mbrs.size());
            ret.addElement(tmp_mbrs.elementAt(index));
            tmp_mbrs.removeElementAt(index);
            --i;
        }
        return ret;
    }

    public static Vector determineLeftMembers(Vector old_mbrs, Vector new_mbrs) {
        Vector retval = new Vector();
        if (old_mbrs == null || new_mbrs == null) {
            return retval;
        }
        int i = 0;
        while (i < old_mbrs.size()) {
            Object mbr = old_mbrs.elementAt(i);
            if (!new_mbrs.contains(mbr)) {
                retval.addElement(mbr);
            }
            ++i;
        }
        return retval;
    }

    public static String printMembers(Vector v) {
        StringBuffer sb = new StringBuffer("(");
        boolean first = true;
        if (v != null) {
            int i = 0;
            while (i < v.size()) {
                if (!first) {
                    sb.append(", ");
                } else {
                    first = false;
                }
                Object el = v.elementAt(i);
                if (el instanceof Address) {
                    sb.append(el);
                } else {
                    sb.append(el);
                }
                ++i;
            }
        }
        sb.append(")");
        return sb.toString();
    }

    public static void doubleWrite(byte[] buf, OutputStream out) throws Exception {
        if (buf.length > 1) {
            out.write(buf, 0, 1);
            out.write(buf, 1, buf.length - 1);
        } else {
            out.write(buf, 0, 0);
            out.write(buf);
        }
    }

    public static long sizeOf(String classname) {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Object inst = loader.loadClass(classname).newInstance();
            byte[] data = Util.objectToByteBuffer(inst);
            return data.length;
        }
        catch (Exception ex) {
            Trace.error("Util.sizeOf()", "exception=" + ex);
            return 0L;
        }
    }

    public static long sizeOf(Object inst) {
        try {
            byte[] data = Util.objectToByteBuffer(inst);
            return data.length;
        }
        catch (Exception ex) {
            Trace.error("Util.sizeOf()", "exception+" + ex);
            return 0L;
        }
    }

    public static boolean sameHost(Address one, Address two) {
        if (one == null || two == null) {
            return false;
        }
        if (!(one instanceof IpAddress) || !(two instanceof IpAddress)) {
            Trace.error("Util.sameHost()", "addresses have to be of type IpAddress to be compared");
            return false;
        }
        InetAddress a = ((IpAddress)one).getIpAddress();
        InetAddress b = ((IpAddress)two).getIpAddress();
        if (a == null || b == null) {
            return false;
        }
        String host_a = a.getHostAddress();
        String host_b = b.getHostAddress();
        return host_a.equals(host_b);
    }

    public static void removeFile(String fname) {
        if (fname == null) {
            return;
        }
        try {
            new File(fname).delete();
        }
        catch (Exception ex) {
            Trace.error("Util.removeFile()", "exception=" + ex);
        }
    }

    public static boolean fileExists(String fname) {
        return new File(fname).exists();
    }

    public static long[] parseCommaDelimitedLongs(String s) {
        Vector<Long> v = new Vector<Long>();
        long[] retval = null;
        if (s == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(s, ",");
        while (tok.hasMoreTokens()) {
            Long l = new Long(tok.nextToken());
            v.addElement(l);
        }
        if (v.size() == 0) {
            return null;
        }
        retval = new long[v.size()];
        int i = 0;
        while (i < v.size()) {
            retval[i] = (Long)v.elementAt(i);
            ++i;
        }
        return retval;
    }

    public static String shortName(String hostname) {
        StringBuffer sb = new StringBuffer();
        if (hostname == null) {
            return null;
        }
        int index = hostname.indexOf(46);
        if (index > 0 && !Character.isDigit(hostname.charAt(0))) {
            sb.append(hostname.substring(0, index));
        } else {
            sb.append(hostname);
        }
        return sb.toString();
    }

    public static ServerSocket createServerSocket(int start_port) {
        ServerSocket ret = null;
        while (true) {
            try {
                ret = new ServerSocket(start_port);
            }
            catch (BindException bind_ex) {
                ++start_port;
                continue;
            }
            catch (IOException io_ex) {
                Trace.error("Util.createServerSocket()", "exception is " + io_ex);
            }
            break;
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    public static DatagramSocket createDatagramSocket(InetAddress addr, int port) throws Exception {
        block10: {
            block9: {
                sock = null;
                if (addr != null) break block9;
                if (port != 0) ** GOTO lbl12
                return new DatagramSocket();
lbl-1000:
                // 1 sources

                {
                    try {
                        return new DatagramSocket(port);
                    }
                    catch (BindException bind_ex) {
                        ++port;
                        continue;
                    }
                    catch (Exception ex) {
                        throw ex;
                    }
lbl12:
                    // 2 sources

                    ** while (port < (char)-1)
                }
lbl13:
                // 1 sources

                break block10;
            }
            if (port == 0) {
                port = 1024;
            }
            while (port < (char)-1) {
                try {
                    return new DatagramSocket(port, addr);
                }
                catch (BindException bind_ex) {
                    ++port;
                }
                catch (Exception ex) {
                    throw ex;
                }
            }
        }
        return sock;
    }

    public static boolean checkForLinux() {
        String os = System.getProperty("os.name");
        boolean bl = false;
        if (os != null && os.toLowerCase().startsWith("linux")) {
            bl = true;
        }
        return bl;
    }

    public static boolean checkForSolaris() {
        String os = System.getProperty("os.name");
        boolean bl = false;
        if (os != null && os.toLowerCase().startsWith("sun")) {
            bl = true;
        }
        return bl;
    }

    public static boolean checkForWindows() {
        String os = System.getProperty("os.name");
        boolean bl = false;
        if (os != null && os.toLowerCase().startsWith("win")) {
            bl = true;
        }
        return bl;
    }

    public static void main(String[] args) {
        System.out.println("Check for Linux:   " + Util.checkForLinux());
        System.out.println("Check for Solaris: " + Util.checkForSolaris());
        System.out.println("Check for Windows: " + Util.checkForWindows());
    }
}

