/*****************************************************************************
 *                                                                           *
 * Program:   paul                                                           *
 *            (P)rogramm zur (A)uswertung und (U)mformung von                *
 *            (L)aserbildern                                                 *
 * Uses:      GTK+ 1.2, Imlib                                                *
 * Modul:     screen.c                                                       *
 *            Show image in window and resize window                         *
 * Author:    Andreas Tille                                                  *
 * Date:      23.02.1998                                                     *
 * Copyright: Andreas Tille, 1999; GNU Public License                        *
 *                                                                           *
 *****************************************************************************/

#include <gdk/gdk.h>
#include <gdk/gdkkeysyms.h>
#include <stdio.h>

#include "paul.h"

static double SCALE = 1;

int SHOW_SLOW = 1;

int ApplyPicture(GdkWindow *win, PICTURE *bild)
/* Display image
 * --- Parameter: ---
 * GdkWindow *win           : window to draw in
 * PICTURE   *bild          : image to display
 * --- Return: ---
 * int        ApplyPicture(): RET_ERR or RET_OK
 */
{
  GdkPixmap   *pp, *m = NULL;
  int          x, y;
  register int W, H;

  g_return_val_if_fail ( win , RET_ERR );
  g_return_val_if_fail ( IS_PICTURE(bild) , RET_ERR );

  W = bild->W;
  H = bild->H;
  if ( SHOW_SLOW ) {
    gdk_window_get_size(win, &x, &y);
    if ( SCALE != 1 ) {
      W *= SCALE;
      H *= SCALE;
    }
    if ( x != W || y != H ) gdk_window_resize(win, W, H);
    m = gdk_imlib_move_mask(bild->im);
  }
  g_return_val_if_fail ( gdk_imlib_render(bild->im, W, H), RET_ERR );
  pp  = gdk_imlib_move_image(bild->im);
  gdk_window_set_back_pixmap(win, pp, 0);

  /* If there was a mask to the image, set the Image's mask to it */
  if (m) gdk_window_shape_combine_mask(win, m, 0, 0); 

  gdk_window_clear(win); 
  gdk_imlib_free_pixmap(pp);
  if ( SHOW_SLOW ) gdk_window_set_title(win, bild->file);
  gdk_window_show(win);
  gdk_flush();
/* printf("%s(%i) ApplyPicture(%s)\n", __FILE__, __LINE__, bild->file);*/

#ifdef PHYSICAL_PAUL
  if ( PG ) ShowPhasePoint(NULL, bild);
#endif

  return RET_OK;
}

static void ScalePic(GdkWindow *win, PICTURE *bild)
/* Scale the image visually (the RGB data remain unchanged)
 * --- Parameter: ---
 * GdkWindow *win  : window to display image
 * PICTURE   *bild : image structure
 */
{
  register int tw, th;
   
  tw = (int)((th = bild->W) * SCALE);
  
  if (tw > gdk_screen_width() << 1 || tw < 10 || tw > th << 4 ) {
    gdk_beep();
    return;
  }
  if ( abs(tw - th) < (int)(th / 5) ) { /* we have reached normality */
    tw    = th;
    th    = bild->H;
    SCALE = 1;
  }
  else th = (int)((th = bild->H) * SCALE);

  UPDATE_IMAGE = 1;
  gdk_window_resize(win, tw, th);   
}

void GrowPic(GdkWindow *win, PICTURE *bild)
/* increase picture size (after pressing "+")
 * --- Parameter: ---
 * GdkWindow *win  : window to display image
 * PICTURE   *bild : image structure
 */
{
  SCALE = SCALE * 4 / 3;
  ScalePic(win, bild);
}

void ShrinkPic(GdkWindow *win, PICTURE *bild)
/* Shrink image (after pressing "-")
 * --- Parameter: ---
 * GdkWindow *win  : window to display image
 * PICTURE   *bild : image structure
 */
{
  SCALE = SCALE * 3 / 4;
  ScalePic(win, bild);
}






