/*
 * Copyright (C) 2002-2003  Jean-Charles Salzeber <jc@varspool.net>
 *
 * This file is part of penggy.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *                
 * $Id: tunnel.h,v 1.10 2003/02/01 13:45:29 chupa Exp $
 *               
 */

#ifndef __IPTUNNEL_TUNNEL_H__
#define __IPTUNNEL_TUNNEL_H__

#if HAVE_CONFIG_H
# include "config.h"
#endif

#if HAVE_SYS_TYPES_H
# include <sys/types.h>
#endif

#include "buffer.h"
#include "iptunnel/vjcompress.h"

struct short_ip
{
  u_int8_t ipnum;
#if WORDS_BIGENDIAN
  u_int8_t long_bit :1;
  u_int8_t len      :7;
#else
  u_int8_t len      :7;
  u_int8_t long_bit :1;
#endif
};

struct long_ip
{
  u_int8_t ipnum;
  u_int16_t len;
}
__attribute__ ((packed));

#define IP_LEN_MASK 0x7fff


extern struct vjcompress vj_comp;
extern buffer_t *acout, *ifout;

extern int ipnum;

#endif /* __IPTUNNEL_TUNNEL_H__ */
