/*
 * Copyright (C) 2002-2003  Jean-Charles Salzeber <jc@varspool.net>
 *
 * This file is part of penggy.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 * $Id: mat.c,v 1.3 2003/02/01 13:45:30 chupa Exp $
 *
 */

#if HAVE_CONFIG_H
# include "config.h"
#endif

#if STDC_HEADERS
# include <stdlib.h>
# include <stddef.h>
#else
# if HAVE_STDLIB_H
#  include <stdlib.h>
# endif
#endif

#include "fdo/atoms.h"


const atomdef_t mat_atom_tab[] = {
  {"mat-bool-vertical-scroll"       , MAT_BOOL_VERTICAL_SCROLL       , bool},
  {"mat-bool-disabled"              , MAT_BOOL_DISABLED              , bool},
  {"mat-bool-default"               , MAT_BOOL_DEFAULT               , bool},
  {"mat-bool-resize-vertical"       , MAT_BOOL_RESIZE_VERTICAL       , bool},
  {"mat-bool-resize-horizontal"     , MAT_BOOL_RESIZE_HORIZONTAL     , bool},
  {"mat-bool-modal"                 , MAT_BOOL_MODAL                 , bool},
  {"mat-bool-invisible"             , MAT_BOOL_INVISIBLE             , bool},
  {"mat-bool-hidden"                , MAT_BOOL_HIDDEN                , bool},
  {"mat-orientation"                , MAT_ORIENTATION                , orient},
  {"mat-capacity"                   , MAT_CAPACITY                   , dword},
  {"mat-font-sis"                   , MAT_FONT_SIS                   , multi},
  {"mat-relative-tag"               , MAT_RELATIVE_TAG               , dword},
  {"mat-object-id"                  , MAT_OBJECT_ID                  , gid},
  {"mat-art-id"                     , MAT_ART_ID                     , gid},
  {"mat-width"                      , MAT_WIDTH                      , dword},
  {"mat-height"                     , MAT_HEIGHT                     , dword},
  {"mat-title-pos"                  , MAT_TITLE_POS                  , byte},
  {"mat-ruler"                      , MAT_RULER                      , bytelist},
  {"mat-object-color"               , MAT_OBJECT_COLOR               , bytelist},
  {"mat-vertical-spacing"           , MAT_VERTICAL_SPACING           , dword},
  {"mat-iconify-as"                 , MAT_ICONIFY_AS                 , raw},
  {"mat-plus-group"                 , MAT_PLUS_GROUP                 , raw},
  {"mat-size"                       , MAT_SIZE                       , multi},
  {"mat-title"                      , MAT_TITLE                      , str},
  {"mat-title-width"                , MAT_TITLE_WIDTH                , dword},
  {"mat-bool-list-icons"            , MAT_BOOL_LIST_ICONS            , bool},
  {"mat-bool-graphic-view"          , MAT_BOOL_GRAPHIC_VIEW          , bool},
  {"mat-bool-palette"               , MAT_BOOL_PALETTE               , bool},
  {"mat-bool-horizontal-scroll"     , MAT_BOOL_HORIZONTAL_SCROLL     , bool},
  {"mat-bool-force-scroll"          , MAT_BOOL_FORCE_SCROLL          , bool},
  {"mat-bool-protected-input"       , MAT_BOOL_PROTECTED_INPUT       , bool},
  {"mat-bool-force-no-scroll"       , MAT_BOOL_FORCE_NO_SCROLL       , bool},
  {"mat-bool-non-closeable"         , MAT_BOOL_NON_CLOSEABLE         , bool},
  {"mat-bool-exportable"            , MAT_BOOL_EXPORTABLE            , bool},
  {"mat-bool-importable"            , MAT_BOOL_IMPORTABLE            , bool},
  {"mat-bool-writeable"             , MAT_BOOL_WRITEABLE             , bool},
  {"mat-bool-floating"              , MAT_BOOL_FLOATING              , bool},
  {"mat-bool-contiguous"            , MAT_BOOL_CONTIGUOUS            , bool},
  {"mat-bool-menu"                  , MAT_BOOL_MENU                  , bool},
  {"mat-bool-default-send"          , MAT_BOOL_DEFAULT_SEND          , bool},
  {"mat-bool-double-space"          , MAT_BOOL_DOUBLE_SPACE          , bool},
  {"mat-object-type"                , MAT_OBJECT_TYPE                , objst},
  {"mat-vert-scroll-capacity"       , MAT_VERT_SCROLL_CAPACITY       , dword},
  {"mat-horz-scroll-capacity"       , MAT_HORZ_SCROLL_CAPACITY       , dword},
  {"mat-font-id"                    , MAT_FONT_ID                    , byte},
  {"mat-font-size"                  , MAT_FONT_SIZE                  , dword},
  {"mat-font-style"                 , MAT_FONT_STYLE                 , byte},
  {"mat-value"                      , MAT_VALUE                      , dword},
  {"mat-border"                     , MAT_BORDER                     , raw},
  {"mat-command-key"                , MAT_COMMAND_KEY                , raw},
  {"mat-dirty-query"                , MAT_DIRTY_QUERY                , bool},
  {"mat-managed-by"                 , MAT_MANAGED_BY                 , dword},
  {"mat-validation"                 , MAT_VALIDATION                 , dword},
  {"mat-horizontal-spacing"         , MAT_HORIZONTAL_SPACING         , dword},
  {"mat-style-id"                   , MAT_STYLE_ID                   , gid},
  {"mat-minimum"                    , MAT_MINIMUM                    , dword},
  {"mat-maximum"                    , MAT_MAXIMUM                    , dword},
  {"mat-horz-scroll-value"          , MAT_HORZ_SCROLL_VALUE          , dword},
  {"mat-vert-scroll-value"          , MAT_VERT_SCROLL_VALUE          , dword},
  {"mat-bool-invert"                , MAT_BOOL_INVERT                , bool},
  {"mat-position"                   , MAT_POSITION                   , byte},
  {"mat-log-object"                 , MAT_LOG_OBJECT                 , byte},
  {"mat-paragraph"                  , MAT_PARAGRAPH                  , bool},
  {"mat-scroll-threshold"           , MAT_SCROLL_THRESHOLD           , dword},
  {"mat-shortcut-key"               , MAT_SHORTCUT_KEY               , str},
  {"mat-sort-order"                 , MAT_SORT_ORDER                 , byte},
  {"mat-unfocused"                  , MAT_UNFOCUSED                  , bool},
  {"mat-bool-permanent"             , MAT_BOOL_PERMANENT             , bool},
  {"mat-bool-ignore"                , MAT_BOOL_IGNORE                , bool},
  {"mat-increment"                  , MAT_INCREMENT                  , dword},
  {"mat-bool-no-border"             , MAT_BOOL_NO_BORDER             , bool},
  {"mat-bool-modified"              , MAT_BOOL_MODIFIED              , bool},
  {"mat-link-content-to-rid"        , MAT_LINK_CONTENT_TO_RID        , dword},
  {"mat-bool-precise"               , MAT_BOOL_PRECISE               , bool},
  {"mat-precise-width"              , MAT_PRECISE_WIDTH              , dword},
  {"mat-precise-height"             , MAT_PRECISE_HEIGHT             , dword},
  {"mat-precise-x"                  , MAT_PRECISE_X                  , dword},
  {"mat-precise-y"                  , MAT_PRECISE_Y                  , dword},
  {"mat-color-face"                 , MAT_COLOR_FACE                 , bytelist},
  {"mat-color-text"                 , MAT_COLOR_TEXT                 , bytelist},
  {"mat-color-top-edge"             , MAT_COLOR_TOP_EDGE             , bytelist},
  {"mat-color-bottom-edge"          , MAT_COLOR_BOTTOM_EDGE          , bytelist},
  {"mat-bool-gradual-shadow"        , MAT_BOOL_GRADUAL_SHADOW        , bool},
  {"mat-frame-style"                , MAT_FRAME_STYLE                , word},
  {"mat-trigger-style"              , MAT_TRIGGER_STYLE              , word},
  {"mat-color-selected"             , MAT_COLOR_SELECTED             , bytelist},
  {"mat-color-text-shadow"          , MAT_COLOR_TEXT_SHADOW          , bytelist},
  {"mat-timer-event"                , MAT_TIMER_EVENT                , dword},
  {"mat-timer-duration"             , MAT_TIMER_DURATION             , dword},
  {"mat-bool-background-pic"        , MAT_BOOL_BACKGROUND_PIC        , bool},
  {"mat-bool-background-flood"      , MAT_BOOL_BACKGROUND_FLOOD      , bool},
  {"mat-color-frame-hilight"        , MAT_COLOR_FRAME_HILIGHT        , bytelist},
  {"mat-color-frame-shadow"         , MAT_COLOR_FRAME_SHADOW         , bytelist},
  {"mat-art-frame"                  , MAT_ART_FRAME                  , dword},
  {"mat-art-animation-rate"         , MAT_ART_ANIMATION_RATE         , dword},
  {"mat-art-animation-seq"          , MAT_ART_ANIMATION_SEQ          , bytelist},
  {"mat-bool-repeat-animation"      , MAT_BOOL_REPEAT_ANIMATION      , bool},
  {"mat-bool-background-tile"       , MAT_BOOL_BACKGROUND_TILE       , bool},
  {"mat-context-help"               , MAT_CONTEXT_HELP               , str},
  {"mat-drop-data-type"             , MAT_DROP_DATA_TYPE             , dword},
  {"mat-field-script"               , MAT_FIELD_SCRIPT               , byte},
  {"mat-encode-type"                , MAT_ENCODE_TYPE                , raw},
  {"mat-bool-first-script"          , MAT_BOOL_FIRST_SCRIPT          , bool},
  {"mat-bool-list-allow-entry"      , MAT_BOOL_LIST_ALLOW_ENTRY      , bool},
  {"mat-url"                        , MAT_URL                        , str},
  {"mat-bool-expand-to-fit"         , MAT_BOOL_EXPAND_TO_FIT         , bool},
  {"mat-sink"                       , MAT_SINK                       , str},
  {"mat-bool-sane"                  , MAT_BOOL_SANE                  , bool},
  {"mat-bool-url-sink"              , MAT_BOOL_URL_SINK              , bool},
  {"mat-bool-drop-at-top"           , MAT_BOOL_DROP_AT_TOP           , bool},
  {"mat-form-icon"                  , MAT_FORM_ICON                  , gid},
  {"mat-content-tag"                , MAT_CONTENT_TAG                , str},
  {"mat-bool-language-popup"        , MAT_BOOL_LANGUAGE_POPUP        , bool},
  {"mat-language-sensitive"         , MAT_LANGUAGE_SENSITIVE         , dword},
  {"mat-bool-palette-art"           , MAT_BOOL_PALETTE_ART           , bool},
  {"mat-set-dflt-extract-type"      , MAT_SET_DFLT_EXTRACT_TYPE      , dword},
  {"mat-art-hint-width"             , MAT_ART_HINT_WIDTH             , dword},
  {"mat-art-hint-height"            , MAT_ART_HINT_HEIGHT            , dword},
  {"mat-art-hint-title"             , MAT_ART_HINT_TITLE             , str},
  {"mat-art-hint-placeholder-id"    , MAT_ART_HINT_PLACEHOLDER_ID    , gid},
  {"mat-art-hint-title-x"           , MAT_ART_HINT_TITLE_X           , dword},
  {"mat-bool-tool-group"            , MAT_BOOL_TOOL_GROUP            , bool},
  {"mat-art-hint-title-y"           , MAT_ART_HINT_TITLE_Y           , dword},
  {"mat-art-hint-title-font-size"   , MAT_ART_HINT_TITLE_FONT_SIZE   , dword},
  {"mat-art-hint-title-font-id"     , MAT_ART_HINT_TITLE_FONT_ID     , dword},
  {"mat-art-hint-title-font-style"  , MAT_ART_HINT_TITLE_FONT_STYLE  , dword},
  {"mat-bool-small-icon"            , MAT_BOOL_SMALL_ICON            , bool},
  {"mat-art-hint-select-placeholder", MAT_ART_HINT_SELECT_PLACEHOLDER, dword},
  {"mat-object-index"               , MAT_OBJECT_INDEX               , dword},
  {"mat-bool-encode-unicode"        , MAT_BOOL_ENCODE_UNICODE        , bool},
  {"mat-text-on-picture-pos"        , MAT_TEXT_ON_PICTURE_POS        , byte},
  {"mat-secure-form"                , MAT_SECURE_FORM                , token},
  {"mat-fp-compose-mail"            , MAT_FP_COMPOSE_MAIL            , raw},
  {"mat-fp-send-im"                 , MAT_FP_SEND_IM                 , raw},
  {"mat-fp-save-to-fp"              , MAT_FP_SAVE_TO_FP              , raw},
  {"mat-bool-page-control"          , MAT_BOOL_PAGE_CONTROL          , bool},
  {"mat-bool-spinner"               , MAT_BOOL_SPINNER               , bool},
  {"mat-bool-detached"              , MAT_BOOL_DETACHED              , bool},
  {"mat-bool-customizable"          , MAT_BOOL_CUSTOMIZABLE          , bool},
  {"mat-bool-detachable"            , MAT_BOOL_DETACHABLE            , bool},
  {"mat-bool-dock-horizontal"       , MAT_BOOL_DOCK_HORIZONTAL       , bool},
  {"mat-bool-dock-vertical"         , MAT_BOOL_DOCK_VERTICAL         , bool},
  {"mat-bool-children-removable"    , MAT_BOOL_CHILDREN_REMOVABLE    , bool},
  {"mat-bool-children-movable"      , MAT_BOOL_CHILDREN_MOVABLE      , bool},
  {"mat-bool-child-removable"       , MAT_BOOL_CHILD_REMOVABLE       , bool},
  {"mat-bool-child-movable"         , MAT_BOOL_CHILD_MOVABLE         , bool},
  {"mat-bool-child-line-feed"       , MAT_BOOL_CHILD_LINE_FEED       , bool},
  {"mat-title-append-screen-name"   , MAT_TITLE_APPEND_SCREEN_NAME   , byte},
  {"mat-url-list"                   , MAT_URL_LIST                   , byte},
  {"mat-tab-set-cur-sel"            , MAT_TAB_SET_CUR_SEL            , dword},
  {"mat-tab-get-cur-sel"            , MAT_TAB_GET_CUR_SEL            , raw},
  {"mat-bool-shared-style"          , MAT_BOOL_SHARED_STYLE          , bool},
  {"mat-bool-active-offline"        , MAT_BOOL_ACTIVE_OFFLINE        , bool},
  {"mat-bool-active-online"         , MAT_BOOL_ACTIVE_ONLINE         , bool},
  {"mat-bool-inactive-for-guest"    , MAT_BOOL_INACTIVE_FOR_GUEST    , bool},
  {"mat-bool-dropdown-button"       , MAT_BOOL_DROPDOWN_BUTTON       , bool},
  {"mat-bool-popup-menu"            , MAT_BOOL_POPUP_MENU            , bool},
  {"mat-bool-ignore-url-list"       , MAT_BOOL_IGNORE_URL_LIST       , bool},
  {"mat-popup-relative-id"          , MAT_POPUP_RELATIVE_ID          , dword},
  {"mat-popup-pfc-path"             , MAT_POPUP_PFC_PATH             , str},
  {"mat-bool-draw-focus"            , MAT_BOOL_DRAW_FOCUS            , bool},
  {"mat-url-next"                   , MAT_URL_NEXT                   , str},
  {"mat-url-prev"                   , MAT_URL_PREV                   , str},
  {"mat-url-parent"                 , MAT_URL_PARENT                 , str},
  {"mat-bool-loggable"              , MAT_BOOL_LOGGABLE              , bool},
  {"mat-secure-field"               , MAT_SECURE_FIELD               , dword},
  {"mat-bool-hide-url"              , MAT_BOOL_HIDE_URL              , bool},
  {"mat-bool-auto-closeable"        , MAT_BOOL_AUTO_CLOSEABLE        , bool},
  {"mat-bool-signoff-menu"          , MAT_BOOL_SIGNOFF_MENU          , bool},
  {"mat-bool-ignore-url"            , MAT_BOOL_IGNORE_URL            , bool},
  {"mat-bool-savable-to-pfc"        , MAT_BOOL_SAVABLE_TO_PFC        , bool},
  {"mat-bool-static-url"            , MAT_BOOL_STATIC_URL            , bool},
  {"mat-intl-font-sis"              , MAT_INTL_FONT_SIS              , multi},
  {"mat-navarrow-pos"               , MAT_NAVARROW_POS               , raw},
  {"mat-navarrow-art"               , MAT_NAVARROW_ART               , dword},
  {"mat-navarrow-pos-x"             , MAT_NAVARROW_POS_X             , dword},
  {"mat-navarrow-pos-y"             , MAT_NAVARROW_POS_Y             , dword},
  {"mat-art-seq"                    , MAT_ART_SEQ                    , multi},
  {"mat-sage-context-help"          , MAT_SAGE_CONTEXT_HELP          , str},
  {"mat-auto-complete"              , MAT_AUTO_COMPLETE              , multi},
  {"mat-left-spacing"               , MAT_LEFT_SPACING               , byte},
  {"mat-top-spacing"                , MAT_TOP_SPACING                , byte},
  {"mat-right-spacing"              , MAT_RIGHT_SPACING              , byte},
  {"mat-bottom-spacing"             , MAT_BOTTOM_SPACING             , byte},
  {"mat-spacing"                    , MAT_SPACING                    , byte},
  {"mat-factory-id"                 , MAT_FACTORY_ID                 , gid},
  {"mat-treectrl-set-class"         , MAT_TREECTRL_SET_CLASS         , dword},
  {"mat-title-access"               , MAT_TITLE_ACCESS               , str},
  {"mat-ctrl-attribute"             , MAT_CTRL_ATTRIBUTE             , dword},
  {"mat-title-access-rids"          , MAT_TITLE_ACCESS_RIDS          , multi},
  {"mat-title-access-rid"           , MAT_TITLE_ACCESS_RID           , dword},
  {"mat-thumb-size"                 , MAT_THUMB_SIZE                 , dword},
  {"mat-bool-hide-ticks"            , MAT_BOOL_HIDE_TICKS            , bool},
  {"mat-color-thumb"                , MAT_COLOR_THUMB                , bytelist},
  {"mat-color-channel"              , MAT_COLOR_CHANNEL              , bytelist},
  {"mat-bool-is-slider"             , MAT_BOOL_IS_SLIDER             , bool},
  {"mat-bool-allow-tabbing"         , MAT_BOOL_ALLOW_TABBING         , bool},
  {"mat-bool-default-trigger"       , MAT_BOOL_DEFAULT_TRIGGER       , bool},
  {"mat-use-style-guide"            , MAT_USE_STYLE_GUIDE            , byte},
  {NULL, -1, na}
};
