/* ----------------------------------------------- */
/* company : pentamedia
 * author  : elcosmki
 * file    : avifunc.c 
 * date    : 2000-06-20
 * modify  : 2001-12-13 by elcomski
 */
/* ----------------------------------------------- */
#include <arpa/inet.h>
#include <net/if.h>
#include <sys/ioctl.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>

#include "../../share/xptype.h"
#include "../../share/ifdef.h"
#include "../libif/pentapi.h"
#include "avifunc.h"


/*--------------------------------*/
/* Variable definitions */
/*--------------------------------*/
int g_if_count;
struct ifreq g_if_list[100];
unsigned long g_user_pid = 0;
/* Begin Change for Fixed Key */
char g_user_even_cw[8];
char g_user_odd_cw[8];
/* End Change for Fixed Key */

extern str_trans_data g_trans_data;
extern str_pid_data g_pid_data;
extern str_ip_data g_sip_data;
extern int g_if_num;
extern char g_dev_name[100];

/* Begin Change for Fixed Key */
unsigned char g_even_cw[8][8];
unsigned char g_odd_cw[8][8];
/* End Change for Fixed Key */



/*--------------------------------*/
/* Function definitions */
/*--------------------------------*/
/*
 * Func : set_pid_info
 * Context :
 */
void set_pid_info( void )
{
	int i; 

   	sm_queue_pid_clear(g_dev_name);
	for(i = 0;i < g_pid_data.count; i++){
		printf("[PID%d: %d]\n",i,g_pid_data.pid[i]);
		sm_queue_pid_add_with_cw( g_dev_name, g_pid_data.pid[i], g_even_cw[i], g_odd_cw[i] );
	}
		
	if(g_user_pid){
		printf("[PID: %d]\n",(unsigned int)g_user_pid);
		sm_queue_pid_add_with_cw(g_dev_name,g_user_pid,g_user_even_cw,g_user_odd_cw);
	}

}


/*
 * Func : reset_pid_info_as_cw
 * Context : change cw
 * 	return 0 -> change ok
 * 	return -1 -> change nok
 */
int reset_pid_info_as_cw( void )
{
	int i,iret; 

	for(i = 0;i < g_pid_data.count; i++){
		printf("[PID%d: %d]\n",i,g_pid_data.pid[i]);
		iret = sm_queue_pid_set_cw(g_dev_name,g_pid_data.pid[i],g_even_cw[i],g_odd_cw[i]);

		if( iret < 0 ){
			printf("->Invalid PID : %d \n",g_pid_data.pid[i]);
		}
	}
		
	if(g_user_pid){
		printf("[PID: %d]\n",(unsigned int)g_user_pid);
		iret = sm_queue_pid_set_cw(g_dev_name,g_user_pid,g_user_even_cw,g_user_odd_cw);
		if( iret < 0 ){
			printf("->Invalid PID : %d \n",(unsigned int)g_user_pid);
		}
	}

	return iret;
}


/*
 * Func : set_tuner
 * Context :
 * 	return 0 = lock nok
 * 	return 1 = lock ok
 */
int set_tuner(str_trans_data trans)
{
	int iRet;

    	iRet = sm_tuner_start_tunning(g_dev_name, trans);

	return iRet;
}


/*
 * Func : set_filter_info
 * Context :
 */
void set_filter_info( void )
{
	int i;
	struct sockaddr_in *psock_in;
	unsigned long laddr;
	char *pstr;
	struct in_addr taddr;

   	sm_filter_ip_clear(g_dev_name);

	for(i = 0;i < g_if_count; i++){
    	    	psock_in = (struct sockaddr_in*) &g_if_list[i].ifr_addr;
		laddr = ntohl(psock_in->sin_addr.s_addr);
		taddr.s_addr = htonl(laddr);
		pstr = inet_ntoa(taddr);
		printf("[IP%d: %s]\n",i,pstr);
		sm_filter_ip_add(g_dev_name, laddr);
	}

	for(i = 0; i < g_sip_data.count; i++){
	    	laddr = g_sip_data.ip[i];
		taddr.s_addr = htonl(laddr);
		pstr = inet_ntoa(taddr);
		printf("[SIP%d: %s]\n",i,pstr);
		sm_filter_ip_add(g_dev_name, laddr);
	}
	
	sm_filter_ip_active(g_dev_name );
}


/*
 * Func : get_if_list
 * Context :
 */
void get_if_list( void )
{
    	int iVal,iRet;
    	int sockfd;
  	struct ifconf ifc; 
  	int i;

	if(g_if_count) return;
	
   	sockfd = socket(AF_INET, SOCK_DGRAM,0);

	ifc.ifc_buf = (char*)&g_if_list[0];
	ifc.ifc_len = sizeof(struct ifreq) * 100;
	iRet = ioctl(sockfd, SIOCGIFCONF, (struct ifreq*) &ifc);
	
	g_if_count = ifc.ifc_len / sizeof(struct ifreq);
	for(i=0;i<g_if_count;i++)
	{
      		iVal = ioctl(sockfd, 0x8915, &g_if_list[i]);
	}
  
	close(sockfd);	
}
