%define ver      1.15
%define rel      1
%define prefix   /usr

#Uncomment these if they are not defined by your rpm macros file
#%define _prefix                /usr
#%define _exec_prefix           %{_prefix}
#%define _bindir                %{_exec_prefix}/bin
#%define _sbindir               %{_exec_prefix}/sbin
#%define _libexecdir            %{_exec_prefix}/libexec
#%define _datadir               %{_prefix}/share
#%define _sysconfdir            %{_prefix}/etc
#%define _sharedstatedir        %{_prefix}/com
%define _localstatedir          /var
#%define _lib                   lib
#%define _libdir                %{_exec_prefix}/%{_lib}
#%define _includedir            %{_prefix}/include
#%define _oldincludedir         /usr/include
#%define _infodir               %{_prefix}/info
#%define _mandir                %{_prefix}/man

Summary: Mail Retrieval Proxy
Name: perdition
Version: %ver
Release: %rel
Copyright: GPL
Group: Applications/Internet
Source: http://www.vergenet.net/linux/perdition/%{ver}/perdition-%{ver}.tar.gz
BuildRoot: /var/tmp/perdition-%{PACKAGE_VERSION}-root
Packager: Horms <horms@verge.net.au>
URL: http://vergenet.net/linux/perdition/
Docdir: %{prefix}/doc
Provides: perdition-%{ver}-%{rel}
BuildPrereq: automake autoconf libtool vanessa_logger-devel >= 0.0.6 vanessa_adt-devel >= 0.0.6  vanessa_socket-devel >= 0.0.7  gdbm-devel mysql-devel postgresql-devel openldap-devel popt pam-devel zlib-devel openssl-devel ghostscript tetex-latex tetex-dvips libtiff unixODBC-devel /usr/include/db.h
Requires: vanessa_logger >= 0.0.6 vanessa_adt >= 0.0.6 vanessa_socket >= 0.0.7

%description
Perdition is a fully featured POP3 and IMAP4 proxy server. It is able to
handle both SSL and non-SSL connections and redirect users to a
real-server based on a database lookup. Perdition supports modular based
database access. ODBC, MySQL, PostgreSQL, GDBM, POSIX Regular Expression
and NIS modules ship with the distribution. The API for modules is open
allowing abitary modules to be written to allow access to any data store.

Perdition can be used to: Create large mail systems where a users mailbox
may be stored on one of several hosts.  Integrate different mail systems
together. Migrate between different email infastructure. And in firewall
applications.

%package devel
Summary: Headers and static libraries for perditiondb library development
Group: Development/Libraries
Requires: perdition-%{ver}-%{rel}

%description devel
Perdition allows for arbitrary user database access through
shared libraries much in the manner of NSS in glibc. This package
provides headers and libraries that may be useful in the development
of perditiondb libraries.


%package bdb
Summary: Library to allow perdition to access Berkely DB based pop maps.
Group: Applications/Internet
Copyright: GPL
Requires: perdition-%{ver}-%{rel}
Provides: perdition-ldap-%{ver}-%{rel}

%description bdb
Perdition allows for arbitrary user database access through shared
libraries much in the manner of NSS in glibc. This package allows a user
database to be sourced from a Berkely DB.


%package ldap
Summary: Library to allow perdition to access LDAP based pop maps.
Group: Applications/Internet
Copyright: GPL
Requires: perdition-%{ver}-%{rel}
Provides: perdition-ldap-%{ver}-%{rel}

%description ldap
Perdition allows for arbitrary user database access through shared
libraries much in the manner of NSS in glibc. This package allows a user
database to be sourced from LDAP.


%package mysql
Summary: Library to allow perdition to access MySQL based pop maps.
Group: Applications/Internet
Copyright: GPL
Requires: perdition-%{ver}-%{rel}
Provides: perdition-mysql-%{ver}-%{rel}

%description mysql
Perdition allows for arbitrary user database access through shared
libraries much in the manner of NSS in glibc. This package allows a user
database stored in a MySQL database.


%package postgresql
Summary: Library to allow perdition to access PostgreSQL based pop maps.
Group: Applications/Internet
Copyright: GPL
Requires: perdition-%{ver}-%{rel}
Provides: perdition-postgresql-%{ver}-%{rel}

%description postgresql
Perdition allows for arbitrary user database access through shared
libraries much in the manner of NSS in glibc. This package allows a user
database stored in a PostgreSQL database.


%package odbc
Summary: Library to allow perdition to access pop maps via ODBC.
Group: Applications/Internet
Copyright: GPL
Requires: perdition-%{ver}-%{rel} unixODBC
Provides: perdition-odbc-%{ver}-%{rel}

%description odbc
Perdition allows for arbitrary user database access through shared
libraries much in the manner of NSS in glibc. This package allows a user
access databases via ODBC.





%prep
%setup

%build

# I am providing my own configure macro replacement. Hopefully this
# will result in fewer portability problems than using the one supplied
# by various vendours. I fear that I hope in vein.
CFLAGS="${CFLAGS:-%optflags} -I/usr/kerberos/include" ; export CFLAGS
if [ -f confgure.in ]; then
	aclocal
	libtoolize --force --copy
	autoheader
	automake
	autoconf
fi
./configure %{_target_platform} \
       --prefix=%{_prefix} \
       --exec-prefix=%{_exec_prefix} \
       --bindir=%{_bindir} \
       --sbindir=%{_sbindir} \
       --sysconfdir=/etc \
       --datadir=%{_datadir} \
       --includedir=%{_includedir} \
       --libdir=%{_libdir} \
       --libexecdir=%{_libexecdir} \
       --localstatedir=%{_localstatedir} \
       --sharedstatedir=%{_sharedstatedir} \
       --mandir=%{_mandir} \
       --infodir=%{_infodir} \
       --with-ldap-schema-directory=/etc/openldap/schema \
       --enable-shared

make

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p ${RPM_BUILD_ROOT}/etc/{rc.d/init.d,sysconfig}

make DESTDIR=$RPM_BUILD_ROOT install-strip

install -m755 \
  ${RPM_BUILD_DIR}/perdition-%{ver}/etc/rc.d/init.d/perdition.rh \
  ${RPM_BUILD_ROOT}/etc/rc.d/init.d/perdition
install -m644 ${RPM_BUILD_DIR}/perdition-%{ver}/etc/sysconfig/perdition \
  ${RPM_BUILD_ROOT}/etc/sysconfig/perdition
  

%clean
rm -rf $RPM_BUILD_ROOT

%post
/sbin/chkconfig --add perdition
make -q -C /etc/perdition/
true

%postun

%preun
/sbin/chkconfig --del perdition
make -q -C /etc/perdition/ clean
true


%files
%defattr(-,root,root)
%doc %attr(-, root, root) README
%doc %attr(-, root, root) ChangeLog NEWS CODING_LOCATIONS TODO
%{_sbindir}/perdition
%{_sbindir}/perdition.pop3
%{_sbindir}/perdition.pop3s
%{_sbindir}/perdition.imap4
%{_sbindir}/perdition.imap4s
%{_sbindir}/perdition.imaps
%{_libdir}/libjain.so
%{_libdir}/libjain.so.0
%{_libdir}/libjain.so.0.0.0
/etc/pam.d/perdition
/etc/rc.d/init.d/perdition
%config /etc/sysconfig/perdition
%config /etc/perdition/perdition.conf
%{_mandir}/man8/perdition.*
%{_mandir}/man5/perditiondb.*

# nis map
%{_libdir}/libperditiondb_nis.a
%{_libdir}/libperditiondb_nis.la
%{_libdir}/libperditiondb_nis.so
%{_libdir}/libperditiondb_nis.so.0
%{_libdir}/libperditiondb_nis.so.0.0.0

# posix_regex map
%{_libdir}/libperditiondb_posix_regex.a
%{_libdir}/libperditiondb_posix_regex.la
%{_libdir}/libperditiondb_posix_regex.so
%{_libdir}/libperditiondb_posix_regex.so.0
%{_libdir}/libperditiondb_posix_regex.so.0.0.0
%config /etc/perdition/popmap.re

# gdbm map
%{_libdir}/libperditiondb_gdbm.a
%{_libdir}/libperditiondb_gdbm.la
%{_libdir}/libperditiondb_gdbm.so
%{_libdir}/libperditiondb_gdbm.so.0
%{_libdir}/libperditiondb_gdbm.so.0.0.0
%{_bindir}/makegdbm
/etc/perdition/Makefile
/etc/perdition/Makefile.popmap
%{_mandir}/man1/makegdbm.*
%config /etc/perdition/popmap

# daemon map
%{_libdir}/libperditiondb_daemon.a
%{_libdir}/libperditiondb_daemon.la
%{_libdir}/libperditiondb_daemon.so
%{_libdir}/libperditiondb_daemon.so.0
%{_libdir}/libperditiondb_daemon.so.0.0.0

%files bdb
%defattr(-,root,root)
%{_libdir}/libperditiondb_bdb.a
%{_libdir}/libperditiondb_bdb.la
%{_libdir}/libperditiondb_bdb.so
%{_libdir}/libperditiondb_bdb.so.0
%{_libdir}/libperditiondb_bdb.so.0.0.0
%{_bindir}/makebdb
%{_mandir}/man1/makebdb.*

%files ldap
%defattr(-,root,root)
%doc %attr(-, root, root) perdition/db/ldap/doc/perdition_ldap.pdf
%{_libdir}/libperditiondb_ldap.a
%{_libdir}/libperditiondb_ldap.la
%{_libdir}/libperditiondb_ldap.so
%{_libdir}/libperditiondb_ldap.so.0
%{_libdir}/libperditiondb_ldap.so.0.0.0
%{_sbindir}/perditiondb_ldap_makedb
%{_mandir}/man8/perditiondb_ldap_makedb.*
/etc/openldap/schema/perdition.schema

%files mysql
%defattr(-,root,root)
%{_libdir}/libperditiondb_mysql.a
%{_libdir}/libperditiondb_mysql.la
%{_libdir}/libperditiondb_mysql.so
%{_libdir}/libperditiondb_mysql.so.0
%{_libdir}/libperditiondb_mysql.so.0.0.0
%{_sbindir}/perditiondb_mysql_makedb
%{_mandir}/man8/perditiondb_mysql_makedb.*

%files postgresql
%defattr(-,root,root)
%{_libdir}/libperditiondb_postgresql.a
%{_libdir}/libperditiondb_postgresql.la
%{_libdir}/libperditiondb_postgresql.so
%{_libdir}/libperditiondb_postgresql.so.0
%{_libdir}/libperditiondb_postgresql.so.0.0.0
%{_sbindir}/perditiondb_postgresql_makedb
%{_mandir}/man8/perditiondb_postgresql_makedb.*

%files odbc
%defattr(-,root,root)
%{_libdir}/libperditiondb_odbc.a
%{_libdir}/libperditiondb_odbc.la
%{_libdir}/libperditiondb_odbc.so
%{_libdir}/libperditiondb_odbc.so.0
%{_libdir}/libperditiondb_odbc.so.0.0.0
%{_sbindir}/perditiondb_odbc_makedb
%{_mandir}/man8/perditiondb_odbc_makedb.*

%files devel
%defattr(-,root,root)
%{_includedir}/jain.h
%{_libdir}/libjain.a
%{_libdir}/libjain.la


%changelog
* Fri Mar  1 2004 Horms <horms@verge.net.au>
- Set localstatedir to /var

* Fri Oct 30 2002 Horms <horms@verge.net.au>
- Fixed BDB mess!

* Fri Mar 31 2002 Horms <horms@verge.net.au>
- added BDB

* Tue Mar 26 2002 Horms <horms@verge.net.au>
- added ODBC

* Sat Dec 29 2001 Horms <horms@verge.net.au>
- Forked SuSE (lsb) spec file

* Fri Dec 14 2001 Horms <horms@verge.net.au>
- Revamped configure to use %{_libdir} and friends. This should be more
  distribution indepentant. With thanks to Scot W. Hetzel <scot@genroco.com>

* Wed Apr 18 2001 Horms <horms@verge.net.au>
- Broke MySQL, PostgreSQL and LDAP back out into separate packages

* Wed Apr 18 2001 Horms <horms@verge.net.au>
- Merged db packages into main package

* Mon Nov 27 2000 Horms <horms@verge.net.au>
- Modified to reflect build process handling instalation of config files
- Split GDBM and Posix_Regex into separate packages

* Mon Oct 16 2000 Horms <horms@verge.net.au>
- added NIS library

* Mon May 15 2000 Horms <horms@verge.net.au>
- added sysconfig file
- split libraries into separate packages so that packages such
  as postgress and mysql don't have to be installed for perdition
  to install cleanly.
- added sample ldap server configuration

* Thu May  4 2000 Horms <horms@verge.net.au>
- added perditiondb_ldap files
- added missing perditiondb_postgresql devel files

* Thu Apr 20 2000 Horms <horms@verge.net.au>
- added perditiondb_postgresql files

* Tue Jan  4 2000 Horms <horms@verge.net.au>
- added libraries
- added headers
- made devel package
- made libtcp_socket and libtcp_socket-devel package
- Included mysql and posix_regex stuff in /etc

* Mon Nov 29 1999 Horms <horms@verge.net.au>
- Added perdition.conf

* Sat Sep 18 1999 Horms <horms@verge.net.au>
- updated for 0.1.0

* Sat May 29 1999 Horms <horms@verge.net.au>
- inital release
