#include	<stdio.h>
#include	"pic.h"
#include	"picy.h"

print()
{
	struct obj *p;
	int i, m;
	float x0, y0, x1, y1, ox, oy, dx, dy, ndx, ndy;

	for (i = 0; i < nobj; i++) {
		p = objlist[i];
		ox = p->o_x;
		oy = p->o_y;
		if (p->o_count >= 1)
			x1 = p->o_val[0];
		if (p->o_count >= 2)
			y1 = p->o_val[1];
		m = p->o_mode;
		switch (p->o_type) {
		case TEX:
			troff(text[p->o_nt1].t_val);
			break;
		case BOX:
		case BLOCK:
			if (p->o_attr & WHITEOBJ) fig_whiten();
			if (p->o_attr & SHADEDOBJ) fig_shade();
			move(ox, oy);
			x0 = ox - x1 / 2;
			y0 = oy - y1 / 2;
			x1 = ox + x1 / 2;
			y1 = oy + y1 / 2;
			if (p->o_attr & INVIS || p->o_type == BLOCK)
				;	/* nothing at all */
			else if (p->o_dotdash == 0)
				box(x0, y0, x1, y1);
			else
				dotbox(x0, y0, x1, y1, p->o_dotdash, p->o_ddval
);
			move(ox, oy);	/* for any text strings */
			dotext(p);	/* if there are any text strings */
			if (ishor(m))
				move(isright(m) ? x1 : x0, oy);	/* right side *
/
			else
				move(ox, isdown(m) ? y0 : y1);	/* bottom */
			break;
		case BLOCKEND:
			x0 = ox - x1 / 2;
			y0 = oy - y1 / 2;
			x1 = ox + x1 / 2;
			y1 = oy + y1 / 2;
			if (ishor(m))
				move(isright(m) ? x1 : x0, oy);	/* right side *
/
			else
				move(ox, isdown(m) ? y0 : y1);	/* bottom */
			break;
		case CIRCLE:
			if (p->o_attr & WHITEOBJ) fig_whiten();
			if (p->o_attr & SHADEDOBJ) fig_shade();
			move(ox, oy);
			if ((p->o_attr & INVIS) == 0)
				circle(ox, oy, x1);
			dotext(p);
			if (ishor(m))
				move(ox + isright(m) ? x1 : -x1, oy);
			else
				move(ox, oy + isup(m) ? x1 : -x1);
			break;
		case ELLIPSE:
			if (p->o_attr & WHITEOBJ) fig_whiten();
			if (p->o_attr & SHADEDOBJ) fig_shade();
			move(ox, oy);
			if ((p->o_attr & INVIS) == 0)
				ellipse(ox, oy, x1, y1);
			dotext(p);
			if (ishor(m))
				move(ox + isright(m) ? x1 : -x1, oy);
			else
				move(ox, oy - isdown(m) ? y1 : -y1);
			break;
		case ARC:
			move(ox, oy);
			dotext(p);
			if (p->o_attr & HEAD1)
				arrow(x1 - (y1 - oy), y1 + (x1 - ox),
				      x1, y1, p->o_val[4], p->o_val[5]);
                        if (p->o_attr & INVIS)
                                /* probably wrong when it's cw */
                                move(x1, y1);
                        else
				arc(ox, oy, x1, y1, p->o_val[2], p->o_val[3],
					p->o_val[6]);
			if (p->o_attr & HEAD2)
				arrow(p->o_val[2] + p->o_val[3] - oy, p->o_val[3] - (p->o_val[2] - ox),
				      p->o_val[2], p->o_val[3], p->o_val[4], p->o_val[5]);
			if (p->o_attr & CW_ARC)
				move(x1, y1);	/* because drawn backwards */
			break;
		case LINE:
		case ARROW:
		case SPLINE:
			move((ox + x1)/2, (oy + y1)/2);	/* center */
			dotext(p);
			if (p->o_attr & HEAD1)
				arrow(ox + p->o_val[5], oy + p->o_val[6], ox,
					oy, p->o_val[2], p->o_val[3]);
                        if (p->o_attr & INVIS)
                                move(x1, y1);
			else if (p->o_type == SPLINE)
				tpspline(ox, oy, p->o_val[4], &p->o_val[5]);
			else {
				int i, j;
				dx = ox;
				dy = oy;
				for (i=0, j=5; i < p->o_val[4]; i++, j += 2) {
					ndx = dx + p->o_val[j];
					ndy = dy + p->o_val[j+1];
					if (p->o_dotdash == 0)
						line(dx, dy, ndx, ndy);
					else
						dotline(dx, dy, ndx, ndy,
						    p->o_dotdash, p->o_ddval);
					dx = ndx;
					dy = ndy;
				}
			}
			if (p->o_attr & HEAD2) {
				int i, j;
				dx = ox;
				dy = oy;
				for (i = 0, j = 5; i < p->o_val[4] - 1; i++, j 
+= 2) {
					dx += p->o_val[j];
					dy += p->o_val[j+1];
				}
				arrow(dx, dy, x1, y1, p->o_val[2], p->o_val[3])
;
			}
			break;
		case MOVE:
			move(ox, oy);
			dotext(p);
			break;
		case TEXT:
			move(ox, oy);
			label((char *)p->o_attr, p->o_dotdash, 0);	/* stri
ng in funny place */
			free((char *)p->o_attr);
			break;
		}
	}
}

dotline(x0, y0, x1, y1, ddtype, ddval) /* dotted line */
	float x0, y0, x1, y1;
	int ddtype;
	float ddval;
{
	static float prevval = 0.05;	/* 20 per inch by default */
	extern double sqrt();

	fig_flush();
	if (ddval == 0)
		ddval = prevval;
	prevval = ddval;
	/* don't save dot/dash value */
	dashed_line(x0, y0, x1, y1, prevval, ddtype == DOT);
	prevval = 0.05;
}

dotbox(x0, y0, x1, y1, ddtype, ddval)	/* dotted or dashed box */
	float x0, y0, x1, y1;
	int ddtype;
	float ddval;
{
	dotline(x0, y0, x1, y0, ddtype, ddval);
	dotline(x1, y0, x1, y1, ddtype, ddval);
	dotline(x1, y1, x0, y1, ddtype, ddval);
	dotline(x0, y1, x0, y0, ddtype, ddval);
}

dotext(p)	/* print text strings of p in proper vertical spacing */
	struct obj *p;
{
	int i, nhalf;

	fig_flush();
	nhalf = p->o_nt2 - p->o_nt1 - 1;
	for (i = p->o_nt1; i < p->o_nt2; i++) {
		label(text[i].t_val, text[i].t_type, nhalf);
		nhalf -= 2;
	}
}
