/* handle the list of connections */

#include <time.h>
#include <unistd.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#include "server.h"

struct pkspxy_conn *pkspxy_new_conn (void)
{
  return calloc (1, sizeof (struct pkspxy_conn));
}

void pkspxy_notify_conn (struct pkspxy_conn *conn)
{
  conn->state = CS_REPLY;
}

void pkspxy_conn_add_data (struct pkspxy_conn *conn, const char *b, size_t l)
{
  size_t n = conn->bufflen + l;

  if (Debug)
  {
    fprintf (stderr, "%s: adding %d bytes of data, fd = %d\n",
	     Progname, l, conn->fd);
  }
  
  conn->buff = realloc (conn->buff, n);
  memcpy (conn->buff + conn->bufflen, b, l);
  
  for (n = conn->bufflen; n < conn->bufflen + l; n++)
  {
    if (conn->buff[n] == '\n')
    {
      if (Debug) fprintf (stderr, "%s: found NL\n", Progname);
      conn->state = CS_UPDATE;
      conn->buff[n] = '\0';
      if (n && conn->buff[n-1] == '\r')
	conn->buff[n-1] = '\0';

      break;
    }
  }

  conn->bufflen += l;
}

struct pkspxy_conn *pkspxy_find_conn (int fd)
{
  struct pkspxy_conn *p = Connections;
  
  for (; p; p = p->next)
    if (p->fd == fd)
      break;
  
  return p;
}

void pkspxy_free_conn (struct pkspxy_conn **cp)
{
  if (!cp || !*cp)
    return;
  
  if ((*cp)->buff) free ((*cp)->buff);
  if ((*cp)->query) free ((*cp)->query);
  free (*cp);
  *cp = NULL;
}

void pkspxy_delete_conn (int fd)
{
  struct pkspxy_conn *p;
  struct pkspxy_conn **q;

  q = &Connections; 
  p = Connections;

  while (p)
  {
    if (p->fd == fd)
    {
      *q = p->next;
      pkspxy_free_conn (&p);
      break;
    }
    else
    {
      q = &p->next;
      p = p->next;
    }
  }
}
      
void pkspxy_add_conn (int fd)
{
  struct pkspxy_conn *p = pkspxy_new_conn ();
  
  p->fd = fd;
  p->state = CS_READREQ;
  p->stamp = time (NULL);
  p->next = Connections;
  Connections = p;
}

