/***************************************************************************
                          lvi_artist.cpp  -  description
                             -------------------
    begin                : Sun May 6 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "lvi_artist.h"

#include <qimage.h>

#include "gui.h"

LVI_Artist::LVI_Artist(QListView *parent, ARTIST *artist)
  : QListViewItem(parent)
{
  setText(0, artist->name);
  id          = artist->id;
  total       = artist->total;
  local       = artist->local;
  isFavourite = artist->isFavourite;
  
  adjustIcon();
}

LVI_Artist::LVI_Artist(QListView *parent, LVI_Artist *lvi)
  : QListViewItem(parent)
{
  setText(0, lvi->text(0));
  id          = lvi->id;
  total       = lvi->total;
  local       = lvi->local;
  isFavourite = lvi->isFavourite;
  
  adjustIcon();
}

LVI_Artist::LVI_Artist(QListView *parent, int _id, DELTAINFO *delta)
  : QListViewItem(parent)
{
  setText(0, delta->name);
  id          = _id;
  total       = delta->total;
  local       = delta->local;
  isFavourite = false;
  
  adjustIcon();
}

bool LVI_Artist::applyDelta(DELTAINFO *delta)
{
  total += delta->total;
  local += delta->local;

  adjustIcon();

  return (total != 0);
}

void LVI_Artist::changeLocal(int delta)
{
  local += delta;
  adjustIcon();
}

void LVI_Artist::setFavourite(bool state)
{
  isFavourite = state;
  adjustIcon();	
}

void LVI_Artist::adjustIcon()
{
  if(local != 0) {
    if(isFavourite) setPixmap(0, QPixmap(PROKYON_HOME + "/images/lvi_artist_favourite.png"));
    else setPixmap(0, QPixmap(PROKYON_HOME + "/images/lvi_artist.png"));
  } else {
    if(isFavourite) setPixmap(0, GUI::fadeOutIcon(PROKYON_HOME + "/images/lvi_artist_favourite.png"));
    else setPixmap(0, GUI::fadeOutIcon(PROKYON_HOME + "/images/lvi_artist.png"));
  }
}


