/* Header for module Strings, generated by p2c */
#ifndef STRINGS_H
#define STRINGS_H



#ifdef STRINGS_G
# define vextern
#else
# define vextern extern
#endif



/********************************************************************/



#define pstr_EmptyString ""



/*A constant empty string*/
/*Pointer to the chars*/
/*Maximum size*/
/*Number of chars now stored*/
/*Pointer to the array of string-pointers*/
/*Maximum string index*/
/*Max used string index (used for tables)*/
/*Used in sorting lists*/

typedef Char pstr_StrBuf[];

typedef Char *pstr_StrAdr[];

typedef struct pstr_Buffer {
    Char *bufp;
    long bufsiz, buflen;
    Char **adrp;
    long adrsiz, adrlen;
} pstr_Buffer;



extern Void pstr_NewPAC PP((Char **bufp, long siz));
extern Void pstr_NewBuffer PP((pstr_Buffer *buf, long bsiz, long adsiz));
extern Void pstr_ClearBuffer PP((pstr_Buffer *buf));
extern Char *pstr_StringAt PP((pstr_Buffer *buf, long index));
extern boolean pstr_StringAtPut PP((pstr_Buffer *buf, long index, Char *st));
extern Void pstr_StringDelete PP((pstr_Buffer *buf, long index));
extern Void pstr_CopyBuffer PP((pstr_Buffer *src, pstr_Buffer *dest));
extern long pstr_LookUp PP((pstr_Buffer buf, Char *name));
extern boolean pstr_GetValue PP((pstr_Buffer buf, Char *name, Char **value));
extern boolean pstr_PutValue PP((pstr_Buffer *buf, Char *name, Char *value));
extern Void pstr_SortBuffer PP((pstr_Buffer *buf, long recsize, long max,
				_PROCEDURE proc));
extern Void pstr_NullSwapProc PP((long i, long j));



#undef vextern

#endif /*STRINGS_H*/

/* End. */

