########################################################################
#
# File Name:            Literals.py
#
#
"""

Definition of Literal Types

WWW: http://4suite.org/4XSLT        e-mail: support@4suite.org

Copyright (c) 1999-2001 Fourthought Inc, USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

import DataTypes
from Ft.Lib import boolean, number

class Literal:
    """
    Base class for all Literals
    """
    def __init__(self, val):
        self.value = val
        return

    def evaluate(self,con):
        return self.value


class NumberLiteral(Literal):
    """
    A Number Literal
    """
    def __init__(self, val):
        self.value = val
        #self.value = DataTypes.ToNumber(val)
        return


class StringLiteral(Literal):
    """
    A String Literal
    """
    def __init__(self, val):
        self.value = DataTypes.ToString(val)
        self.value = self.value.replace("\\'", "'")
        self.value = self.value.replace('\\"', '"')
        return


class BooleanLiteral(Literal):
    """
    A Boolean Literal
    """
    def __init__(self, val):
        self.value = val
##        if val == "true":
##            self.value = boolean.true
##        else:
##            self.value = boolean.false
        return


class ResourceLiteral(Literal):
    """
    A resource Literal
    """
    def __init__(self, val):
        self.value = DataTypes.ToResource(val)
        return


