import os
DBNAME=os.environ.get("ODS_TEST_DB","ods:test")


from Ft.Ods.StorageManager.Adapters import Constants
from Ft.Ods.StorageManager import Adapters
from Ft.Ods.Collections import DictionaryBase

class DummyDictionary(DictionaryBase.DictionaryBase):

    def _4ods_getSubType(self):
        return Constants.Types.STRING

    def _4ods_getKeyType(self):
        return Constants.Types.STRING

    def _4ods_getKeyRepositoryId(self):
        return -1

    def _4ods_getSubRepositoryId(self):
        return -1

    def _4ods_getChanges(self):
        return self.changes

    def _4ods_setByKey(self,key,value):
        self._values[key] = value

    def _4ods_getByKey(self,key):
        return self._values[key]

    def _4ods_deleteByKey(self,key):
        del self._values[key]

    def _4ods_initValueKeys(self):
        pass

    def _4ods_prepareKeyChanges(self):
        pass

    def has_key(self,key):
        return self._values.has_key(key)

    def keys(self):
        return self._values.keys()


    def _4ods_unprepareValue(self,value):
        return value

    def _4ods_prepareValue(self,value):
        return value

    def _4ods_initValueValues(self):
        pass

    def _4ods_prepareValueChanges(self):
        pass


    def values(self):
        return self._values.values()


def Test(tester):

    tester.startGroup("Dictionary Base %s Driver" % tester.test_data['driver'])

    #Can't have a full DB here
    tester.startTest("Init DB")
    manager = Adapters.GetManager()
    adapter = Adapters.GetAdapter()
    if manager.exists(DBNAME):
        manager.reinit(DBNAME,adapter)
    else:
        manager.create(DBNAME)
        manager.init(DBNAME)

    tester.testDone()
    

    #Test the low level Dictionary Base
    from Ft.Ods import Database
    db = Database.Database()
    db.open(DBNAME)
    try:

        tester.startTest("Creation")
        tx = db.new()
        tx.begin()
        d = DummyDictionary(db,None,None,-1,None,-1,{'1':'a','2':'b','3':'c'})
        d2 = DummyDictionary(db,None,None,-1,None,-1,{'1':'a','2':'b','3':'c'})
        d3 = DummyDictionary(db,None,None,-1,None,-1,None)
        tester.testDone()

        tester.startTest('__cmp__')

        tester.compare(1,d == {'1':'a','2':'b','3':'c'})
        tester.compare(0,d == {'1':'a','2':'b'})
        tester.compare(0,d == d2)
        tester.compare(0,d == d3)

        tester.testDone()

        tester.startTest("__len__")
        tester.compare(3,len(d))
        tester.testDone()


        tester.startTest('items')
        tester.compare([('2', 'b'), ('3', 'c'), ('1', 'a')],d.items())
        tester.testDone()




        tester.startTest("cardinality")
        tester.compare(3,d.cardinality())
        tester.testDone()

        tester.startTest("is_empty")
        tester.compare(0,d.is_empty())
        tester.compare(1,d3.is_empty())
        tester.testDone()

        t1 = DictionaryBase.Association('2','b')
        t2 = DictionaryBase.Association('7','h')

        tester.startTest("contains_element")
        tester.compare(1,d.contains_element(t1))
        tester.compare(0,d.contains_element(t2))
        tester.testDone()

        tester.startTest("insert_element")
        d.insert_element(t2)
        tester.compare(1,d.contains_element(t2))
        tester.testDone()

        tester.startTest("remove_element")
        d.remove_element(t2)
        tester.compare(0,d.contains_element(t2))
        tester.testDone()

        tester.startTest("copy")

        d4 = d.copy(deep=0)
        d5 = d.copy(deep=1)


        tester.compare(0,len(d4))
        tester.compare(1,d5.keys() == d.keys())
        tester.testDone()

        tx.abort()
        tester.groupDone()
    finally:
        db.close()
    return


