import sys

from Ft.Server.Common import CreationParams, ResourceTypes

import test_helper

def _MakeStatement(doc, pred, obj):
    path = doc.getAbsolutePath()
    return (path, pred, obj, '', 'ftss://'+path)

def test_create(tester):

    tester.startTest("Create a XSLT Document Definition")

    repo = test_helper.GetRepo(tester)
    ddRoot = repo.fetchResource('/test')
    dd = ddRoot.createXsltDocumentDefinition("def1",SRC1,CreationParams.CreationParams())
    tester.testDone()

    tester.startTest("Create a Second Document Definition")
    dd2 = ddRoot.createXsltDocumentDefinition("def2",SRC2,CreationParams.CreationParams())
    dd2.addBaseDocumentDefinition(dd)
    repo.txCommit()
    tester.testDone()

    tester.startTest("Get All Document Definition Paths")
    repo = test_helper.GetRepo(tester)
    names = repo.getAllDocumentDefinitionPaths()
    tester.compare(2, len(names))
    tester.compareIn(names,'/test/def1')
    tester.compareIn(names,'/test/def2')
    repo.txRollback()
    tester.testDone()

    return


def test_create_document(tester):

    tester.startTest("Create Document in base def")
    repo = test_helper.GetRepo(tester)
    test = repo.fetchResource('/test')
    doc = test.createDocument('DOC1',DOC1,docDef='/test/def1',forcedType=ResourceTypes.ResourceType.XML_DOCUMENT)

    dd = repo.fetchResource('/test').fetchResource('def1')
    statements = [_MakeStatement(doc, 'NAME', 'Mike'),
                  _MakeStatement(doc, 'NAME', 'Uche'),
                  ]
    test_helper.TestXmlDocumentRdf(tester,
                                   repo,
                                   '/test/DOC1',
                                   len(DOC1),
                                   tester.test_data['userName'],
                                   None,
                                   None,
                                   'text/xml',
                                   '/test/def1',
                                   docDefStmts=statements)
                           
    mds = dd.getMetaDocumentUris()
    tester.compare(1,len(mds))
    tester.compareIn(mds,doc.getAbsolutePath())
    repo.txCommit()
    tester.testDone()


    tester.startTest("Fetch MetaDocument")
    repo = test_helper.GetRepo(tester)
    test = repo.fetchResource('/test')
    doc = test.fetchResource('DOC1')
    dd = test.fetchResource('/test').fetchResource('def1')
    tester.compare(dd,doc.getDocumentDefinition())
    statements = [_MakeStatement(doc, 'NAME', 'Mike'),
                  _MakeStatement(doc, 'NAME', 'Uche'),
                  ]
    test_helper.TestXmlDocumentRdf(tester,
                                   repo,
                                   '/test/DOC1',
                                   len(DOC1),
                                   tester.test_data['userName'],
                                   None,
                                   None,
                                   'text/xml',
                                   '/test/def1',
                                   docDefStmts=statements)
    repo.txRollback()
    tester.testDone()


    
    tester.startTest("Create Document in derived def")
    repo = test_helper.GetRepo(tester)
    test = repo.fetchResource('/test')


    doc = test.createDocument('DOC2',DOC1,docDef='/test/def2',forcedType=ResourceTypes.ResourceType.XML_DOCUMENT)

    dd1 = test.fetchResource('/test').fetchResource('def1')
    dd = test.fetchResource('/test').fetchResource('def2')
    statements = [_MakeStatement(doc, 'NAME', 'Mike'),
                  _MakeStatement(doc, 'NAME', 'Uche'),
                  _MakeStatement(doc, 'NAME2', 'Mike'),
                  _MakeStatement(doc, 'NAME2', 'Uche'),
                  ]
    test_helper.TestXmlDocumentRdf(tester,
                                   repo,
                                   '/test/DOC2',
                                   len(DOC1),
                                   tester.test_data['userName'],
                                   None,
                                   None,
                                   'text/xml',
                                   dd.getAbsolutePath(),
                                   docDefStmts=statements)
    repo.txCommit()
    tester.testDone()


    tester.startTest("Doc Def with Ext Modules and and xsl:include")
    tester.warning("Not Tested")
    tester.testDone()



def test_update_document(tester):

    tester.startTest("Update Document in base def")
    repo = test_helper.GetRepo(tester)
    test = repo.fetchResource('/test')
    doc = test.fetchResource('DOC1')
    doc.setContent(DOC2)
    dd = test.fetchResource('/test').fetchResource('def1')
    statements = [_MakeStatement(doc, 'NAME', 'Vicki'),
                  _MakeStatement(doc, 'NAME', 'Stacey'),
                  ]
    test_helper.TestXmlDocumentRdf(tester,
                                   repo,
                                   '/test/DOC1',
                                   len(DOC2),
                                   tester.test_data['userName'],
                                   None,
                                   None,
                                   'text/xml',
                                   dd.getAbsolutePath(),
                                   docDefStmts=statements)
    repo.txCommit()
    tester.testDone()

    tester.startTest("Fetch Modified Meta Document")
    repo = test_helper.GetRepo(tester)
    test = repo.fetchResource('/test')
    doc = test.fetchResource('DOC1')

    dd = test.fetchResource('/test').fetchResource('def1')
    statements = [_MakeStatement(doc, 'NAME', 'Vicki'),
                  _MakeStatement(doc, 'NAME', 'Stacey'),
                  ]
    test_helper.TestXmlDocumentRdf(tester,
                                   repo,
                                   '/test/DOC1',
                                   len(DOC2),
                                   tester.test_data['userName'],
                                   None,
                                   None,
                                   'text/xml',
                                   dd.getAbsolutePath(),
                                   docDefStmts=statements)
    repo.txRollback()
    tester.testDone()



    tester.startTest("Update Document in derived def")
    repo = test_helper.GetRepo(tester)
    test = repo.fetchResource('/test')
    doc = test.fetchResource('DOC2')
    doc.setContent(DOC2)

    dd = test.fetchResource('/test').fetchResource('def2')
    dd1 = test.fetchResource('/test').fetchResource('def1')
    statements = [_MakeStatement(doc, 'NAME', 'Vicki'),
                  _MakeStatement(doc, 'NAME', 'Stacey'),
                  _MakeStatement(doc, 'NAME2', 'Vicki'),
                  _MakeStatement(doc, 'NAME2', 'Stacey'),
                  ]
    test_helper.TestXmlDocumentRdf(tester,
                                   repo,
                                   '/test/DOC2',
                                   len(DOC2),
                                   tester.test_data['userName'],
                                   None,
                                   None,
                                   'text/xml',
                                   dd.getAbsolutePath(),
                                   docDefStmts=statements)
    repo.txCommit()
    tester.testDone()


def test_delete_document(tester):

    tester.startTest("Delete Document in base def")
    repo = test_helper.GetRepo(tester)
    test = repo.fetchResource('/test')
    doc = test.fetchResource('DOC1')
    doc.delete()

    res = test.getModel().complete('/test/DOC1',None,None)
    tester.compare(0,len(res))
    tester.compare(0,test.hasResource('DOC1'))
    repo.txCommit()
    tester.testDone()

    tester.startTest("Delete Document in derived def")
    repo = test_helper.GetRepo(tester)
    test = repo.fetchResource('/test')
    doc = test.fetchResource('DOC2')
    doc.delete()

    res = test.getModel().complete('/test/DOC2',None,None)
    tester.compare(0,len(res))
    tester.compare(0,test.hasResource('DOC2'))
    repo.txCommit()
    tester.testDone()


    tester.startTest("Removal of Meta Doc URIS")
    repo = test_helper.GetRepo(tester)
    test = repo.fetchResource('/test')
    dd = test.fetchResource('/test').fetchResource('def2')
    dd1 = test.fetchResource('/test').fetchResource('def1')
    tester.compare(0,len(dd.getMetaDocumentUris()))
    tester.compare(0,len(dd1.getMetaDocumentUris()))
    repo.txCommit()
    tester.testDone()




def test_modify(tester):


    tester.startTest("Update a Doc Def")
    repo = test_helper.GetRepo(tester)    
    ddRoot = repo.fetchResource('/test')
    docDef = ddRoot.fetchResource('def1')
    docDef.setContent(SRC3)
    repo.txCommit()
    tester.testDone()

    tester.startTest("Test that the DOC1 was modified")
    repo = test_helper.GetRepo(tester)
    test = repo.fetchResource('/test')
    doc = test.fetchResource('DOC1')
    dd = test.fetchResource('/test').fetchResource('def1')
    statements = [_MakeStatement(doc, 'new_name', 'Vicki'),
                  _MakeStatement(doc, 'new_name', 'Stacey'),
                  ]
    test_helper.TestXmlDocumentRdf(tester,
                                   repo,
                                   '/test/DOC1',
                                   len(DOC2),
                                   tester.test_data['userName'],
                                   None,
                                   None,
                                   'text/xml',
                                   dd.getAbsolutePath(),
                                   docDefStmts=statements)
    repo.txRollback()
    tester.testDone()





def test_clean(tester):

    tester.startTest("clean Document Definition")


    repo = test_helper.GetRepo(tester)
    if repo.hasResource('/test'):
        repo.deleteResource('/test')
    repo.createContainer('/test',1)
 

    repo.txCommit()
    tester.testDone()


DOC1="""<?xml version = "1"?><foo xmlns:ft = 'foo.com'><ft:name>Mike</ft:name><ft:name>Uche</ft:name></foo>"""
DOC2="""<?xml version = "1"?><foo xmlns:ft = 'foo.com'><ft:name>Vicki</ft:name><ft:name>Stacey</ft:name></foo>"""

SRC1 = """<?xml version='1.0'?>
<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:ftss="http://xmlns.4suite.org/reserved"
  xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'
  xmlns:ft = 'foo.com'
  version="1.0"
>

  <xsl:param name='ftss:absolute-path'/>

  <xsl:template match='/'>
    <rdf:RDF>
      <xsl:apply-templates select='foo/ft:name'/>
    </rdf:RDF>
  </xsl:template>

  <xsl:template match='ft:name'>
    <rdf:Description about='{$ftss:absolute-path}'>
      <NAME><xsl:value-of select='.'/></NAME>
    </rdf:Description>
  </xsl:template>
</xsl:stylesheet>"""


SRC2 = """<?xml version='1.0'?>
<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:ftss="http://xmlns.4suite.org/reserved"
  xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'
  xmlns:ft = 'foo.com'
  version="1.0"
>

  <xsl:param name='ftss:absolute-path'/>

  <xsl:template match='/'>
    <rdf:RDF>
      <xsl:apply-templates select='foo/ft:name'/>
    </rdf:RDF>
  </xsl:template>

  <xsl:template match='ft:name'>
    <rdf:Description about='{$ftss:absolute-path}'>
      <NAME2><xsl:value-of select='.'/></NAME2>
    </rdf:Description>
  </xsl:template>



</xsl:stylesheet>"""
#"



SRC3 = """<?xml version='1.0'?>
<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:ftss="http://xmlns.4suite.org/reserved"
  xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'
  xmlns:ft = 'foo.com'
  version="1.0"
>

  <xsl:param name='ftss:absolute-path'/>

  <xsl:template match='/'>
    <rdf:RDF>
      <xsl:apply-templates select='foo/ft:name'/>
    </rdf:RDF>
  </xsl:template>

  <xsl:template match='ft:name'>
    <rdf:Description about='{$ftss:absolute-path}'>
      <new_name><xsl:value-of select='.'/></new_name>
    </rdf:Description>
  </xsl:template>
</xsl:stylesheet>"""



def Test(tester):
    test_clean(tester)
    test_create(tester)

    test_create_document(tester)
    test_update_document(tester)

    test_modify(tester)
    test_delete_document(tester)
    test_clean(tester)

