############################################################################
#
# File Name: 		Literal.py
#
# Documentation:	http://docs.ftsuite.com/4ODS/Literal.py.html
#


from Ft.Ods import PersistentObject

from Ft.Ods.StorageManager.Adapters import Constants

class Literal(PersistentObject.PersistentObject):
    def __init__(self):
        PersistentObject.PersistentObject.__init__(self)
        self.__dict__['_lid'] = 0


    def same_as(aLiteral):
        return self._lid == aLiteral._lid

    def copy():
        return None

    def _4ods_getLid(self):
        return self.__dict__['_lid']

    def _4ods_setLid(self,id):
        self.__dict__['_lid'] = id

    def _4ods_getId(self):
        return self.__dict__['_lid']    

    def _4ods_getPersistentType(self):
        return Constants.ObjectTypes.LITERAL

    readOnlyAttributes = ('_lid',)
    readWriteAttributes = ()
    relationships = ()

    tupleNames = ('_lid',)
    tupleTypes = (Constants.Types.UNSIGNED_LONG,)
    tupleIds = (None,)
