#!/usr/bin/python
########################################################################
#
# File Name:            FILE
#
# Documentation:        http://docs.4suite.org/4ODS/Parsers/GenerateModule.py.html
#

#Desc.
#WWW: http://4suite.org/4ODS        e-mail: support@4suite.org

#Copyright (c) 1999 Fourthought, Inc., USA.   All Rights Reserved.
#See  http://4suite.org/COPYRIGHT  for license and copyright information

import os

import OdlUtil


def GenerateStubs(mod,params,modDir):

    #try and make our directory from the baseDir
    modDir = os.path.join(params.curDir, mod.name)
    
    if not os.path.exists(modDir):
        os.makedirs(modDir)
    elif os.path.exists(os.path.join(modDir, '__init__.py')):
        os.remove(os.path.join(modDir, '__init__.py'))

    mod_file = open(os.path.join(modDir, '__init__.py'), 'w')
    OdlUtil.WriteFileHeader(mod_file,mod.name)
    mod_file.close()




