/****************************************************************************
** $Id: rs_actionselectbase.cpp,v 1.3 2003/09/15 12:58:47 andrew Exp $
**
** Copyright (C) 2001-2003 RibbonSoft. All rights reserved.
**
** This file is part of the qcadlib Library project.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid qcadlib Professional Edition licenses may use 
** this file in accordance with the qcadlib Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.ribbonsoft.com for further details.
**
** Contact info@ribbonsoft.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#include "rs_actionselectbase.h"



RS_ActionSelectBase::RS_ActionSelectBase(const char* name,
        RS_EntityContainer& container,
        RS_GraphicView& graphicView)
        :RS_ActionInterface(name,
                    container, graphicView) {}



/**
 * Default behaviour of this method is triggering the predecesing
 * action and finishing this one when the enter key is pressed.
 */
void RS_ActionSelectBase::keyReleaseEvent(RS_KeyEvent* e) {
    //std::cout << "RS_ActionSelectBase::keyReleaseEvent: key: "
    //<< e->key() << "\n";

    if (e->key()==Qt::Key_Return && predecessor!=NULL) {
        //std::cout << "  calling predecessor\n";
        //predecessor->trigger();
        //init(-1);
        finish();
        //init(getStatus()-1);
    }
}



void RS_ActionSelectBase::updateMouseCursor() {
    graphicView->setMouseCursor(RS2::SelectCursor);
}


// EOF
