/***************************************************************************
                          rxtxcommon.cpp  -  QSSTV
                             -------------------
    begin                : Fri Jun 15 2001
    copyright            : (C) 2001 by Johan Maes
    email                : on1mh@pandora.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "rxtxcommon.h"
#include "qsstvglobal.h"

//#define RXTXCOMMONDEBUG

rxtxCommon::rxtxCommon()
{
	timer=NULL;
	dumpActive=FALSE;
}

rxtxCommon::~rxtxCommon()
{

}

void rxtxCommon::calculateTiming()
{
  double endTime;
  double visible;
#ifdef RXTXCOMMONDEBUG							
	debug("calculate Timing");
#endif
	eTxRxState lstate=PHASET0;
	lstate=getNextState(lstate);
	startTime=(sstvparam.imageTime*((double)(lineCounter)))/sstvparam.numberOfLines;
	endTime=(sstvparam.imageTime*((double)(lineCounter+1)))/sstvparam.numberOfLines;
	visible=endTime-startTime-sstvparam.hs.t -sstvparam.bp.t-sstvparam.f1.t
    		-sstvparam.f2.t-sstvparam.f3.t -sstvparam.f4.t-sstvparam.f5.t-sstvparam.fp.t;
	time1PerPixel=visible/((double)sstvparam.numberOfPixels*3.);
	time2PerPixel=visible/((double)sstvparam.numberOfPixels*3.);
	do
		{
			switch (lstate)
				{
				case PHASET1:
					 hsTime=startTime+=sstvparam.hs.t;
			  break;
				case PHASET2:
					 bpTime=startTime+=sstvparam.bp.t;
				break;
				case PHASET3:
				case PHASET4:
				case PHASET5: break;
				case PHASET6: // Green
					{
						switch(sstvparam.colorScheme)
							{
								case GBR:
								case RGB:
								case GBR2:
								case XYZOE:
								case XYZOE2: p6Time=startTime+=visible/3.; break;
								default:
#ifdef RXTXCOMMONDEBUG
								 debug("calculateTiming colorScheme P6 error %d",sstvparam.colorScheme);
#endif
								break;
							}
					}
				break;
				case PHASET7: //blue line
					{
						switch(sstvparam.colorScheme)
							{
								case GBR:
								case RGB:
								case GBR2:
								case XYZOE2: p7Time=startTime+=visible/3.;  break;
								default:
#ifdef RXTXCOMMONDEBUG
								 debug("calculateTiming colorScheme P7 error %d",sstvparam.colorScheme);
#endif
							  break;
							}
					}
				break;			
				case PHASET8: // red line
					{
						switch(sstvparam.colorScheme)
							{
								case GBR:
								case RGB:
								case GBR2:
								case XYZOE2: p8Time=startTime+=visible/3.; break;
								case XYZOE:	
									 p8Time=startTime+=2.*visible/3.;
									 time2PerPixel=2.*visible/((double)sstvparam.numberOfPixels*3.);
								break;
								default:
#ifdef RXTXCOMMONDEBUG
								 debug("calculateTiming colorScheme P8 error %d",sstvparam.colorScheme);
#endif
								break;
							}
					}
				break;							
				case PHASET9: f1Time=startTime+=sstvparam.f1.t; break;
				case PHASETA: f2Time=startTime+=sstvparam.f2.t; break;
				case PHASETB: f3Time=startTime+=sstvparam.f3.t; break;
				case PHASETC: f4Time=startTime+=sstvparam.f4.t; break;
				case PHASETD: f5Time=startTime+=sstvparam.f5.t; break;
				case PHASETE: fpTime=startTime+=sstvparam.fp.t; break;
				case NEXTRGB:
				case NEXTXYZOE:
				case NEXTXYZOE2: break;
				default:
#ifdef RXTXCOMMONDEBUG
				 debug("calculateTiming state:%s error %s",stateString[lstate],sstvparam.name);
#endif
			  break;	
				}
		lstate=getNextState(lstate);
		}
	while (lstate!=PHASET0);
}

void rxtxCommon::initAllCounters()
{
	imageSampleCounter=0;
	stateSampleCounter=0;
	lineCounter=0;
	state=STARTPIC;
	pixelCounter=0;
	linePixelCounter=0;
#ifdef  DEBUGQSSTV
	sampleCounter=0;
#endif
}

#ifdef  DEBUGQSSTV
void rxtxCommon::sendToDebugger()
{
	deb->debugFields.sampleCounter=sampleCounter;
	deb->debugFields.imageSampleCounter=imageSampleCounter;
	deb->debugFields.stateSampleCounter=stateSampleCounter;
	deb->debugFields.state=state;
	deb->debugFields.sample=sample;
	deb->save();
}
#endif
