/* Copyright (C) 2003 Nikos Chantziaras.
 *
 * This file is part of the QTads program.  This program is free
 * software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 */

#ifndef QTADSDIALOG_H
#define QTADSDIALOG_H

#include "config.h"

#include <vector>
#include <qdialog.h>


class QVBoxLayout;
class QHBoxLayout;
class QLabel;


/* A QDialog class that is able to add QPushButtons after it has been
 * created.  Use addButton() to add buttons.  The dialog is always
 * modal.  Use start() instead of exec() to show the dialog.
 */
class QTadsDialog: public QDialog {
	Q_OBJECT

  private:
	struct ButtonItem {
		ButtonItem( QPushButton* b, int i )
		: button(b), id(i) {}

		QPushButton* button;
		int id;
	};
	typedef std::vector<ButtonItem> ButtonVector;

	QVBoxLayout* fMainLayout;
	QHBoxLayout* fUpperLayout;
	QHBoxLayout* fButtonLayout;
	QLabel* fText;
	ButtonVector fButtons;
	int fButtonCount;
	int fResult;

  public:
	// `text' is the dialog's information text.
	QTadsDialog( const QString& text, QWidget* parent = 0, const char* name = 0,
		     WFlags f = 0 );

	// Adds a button.  `text' is the buttons's text.  `isDefault'
	// indicates if this should be the default button.
	void
	addButton( const QString& text, bool isDefault = false );

	// Call this instead of exec().  The return value is the index
	// of the clicked button.  The index is 1-based (in the order
	// in which buttons have been added with addButton()).  You can
	// call exec() too, but that doesn't make much sense since it
	// doesn't return the clicked button's index.  If the user
	// cancels the dialog without clicking any of the buttons, 0 is
	// returned.
	int
	start();

  private slots:
	// *DO NOT* call this slot directly!  It assumes that the call
	// is the result of an emitted signal and needs the sender's
	// address.
	void
	clickHandler();
};


#endif // QTADSDIALOG_H
