/* Copyright (C) 2003 Nikos Chantziaras.
 *
 * This file is part of the QTads program.  This program is free
 * software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 */

#ifndef QTADSSTATUSLINE_H
#define QTADSSTATUSLINE_H

#include "config.h"

#include <qhbox.h>


/* The statusline can display text to the left and right
 * simultaneously.
 */
class QTadsStatusLine: public QHBox {
	Q_OBJECT

  private:
	class QLabel* fLeft;   // The left part of the statusline.
	class QLabel* fRight;  // The right one.
	QString fLeftText;     // The text of the left part.
	QString fRightText;    // The text of the right part.

  public:
	QTadsStatusLine( QWidget* parent, const char* name = 0, WFlags f = 0 );

	// Display `text' to the left part of the statusline.  Existing
	// text will be cleared.
	void
	leftText( const QString& text );

	// Display `text' to the right part of the statusline.
	// Existing text will be cleared.
	void
	rightText( const QString& text );
};


#endif // QTADSSTATUSLINE_H
