/* Copyright (C) 2003 Nikos Chantziaras.
 *
 * This file is part of the QTads program.  This program is free
 * software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 */

#include "qtadsvmhostifc.h"

#include <qstring.h>

#include "t3std.h"
#include "os.h"

#include "qtadsio.h"

QTadsCVmHostIfc::QTadsCVmHostIfc( const char* argv0 )
{
	char buf[OSFNMAX];

	// Create the resource loader for character mapping files in
	// the same directory as the executable.
	os_get_special_path(buf, sizeof(buf), argv0, OS_GSP_T3_RES);
	cmap_loader_ = new CResLoader(buf);

	// Set the executable filename in the loader, if available.
	if (os_get_exe_filename(buf, sizeof(buf), argv0))
		cmap_loader_->set_exe_filename(buf);

	// Allow any I/O operations initially.
	io_safety_ = VM_IO_SAFETY_MINIMUM;
}
