# Written by Hyriand
# see LICENSE.txt for license information

from qt import *
import codecs

class TorrentDrop(QPushButton):
    def __init__(self, parent = None, name = None):
        QPushButton.__init__(self, parent, name)
        self.setText("Open")
        self.setAcceptDrops(1)
    
    def dragEnterEvent(self, event):
        if QUriDrag.canDecode(event) or event.provides("text/x-moz-url"):
            event.accept()
    
    def dropEvent(self, event):
        l = QString()
        if event.provides("text/x-moz-url"):
            url = str(codecs.utf_16_decode(str(event.encodedData("text/x-moz-url")))[0]).split("\n")[0].strip()
            self.emit(PYSIGNAL("urisDropped(const QString&)"), (url,))
        elif QTextDrag.decode(event, l):
            self.emit(PYSIGNAL('urisDropped(const QString&)'), (l,))
