/***************************************************************************
                          qextensionwidget.cpp  -  description
                             -------------------
    begin                : Sun Aug 20 2000
    copyright            : (C) 2000 by M. Herder
    email                : http://quiteinsane.sf.net/contact.html
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2 as     *
 *   published by the Free Software Foundation.                            *
 *                                                                         *
 ***************************************************************************/

#include "./pics/fileopen.xpm"
#include "qextensionwidget.h"
#include "qdoublespinbox.h"
#include "qxmlconfig.h"

#include <qapplication.h>
#include <qarray.h>
#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qcolor.h>
#include <qdir.h>
#include <qfile.h>
#include <qfiledialog.h>
#include <qgroupbox.h>
#include <qhbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qlistbox.h>
#include <qmessagebox.h>
#include <qnamespace.h>
#include <qpalette.h>
#include <qpixmap.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qslider.h>
#include <qspinbox.h>
#include <qstring.h>
#include <qtextstream.h>
#include <qtoolbutton.h>
#include <qwhatsthis.h>
#include <qwidgetlist.h>
#include <qwidgetstack.h>

QExtensionWidget::QExtensionWidget(QWidget* parent,const char* name,
                                   bool modal,WFlags f)
                 :QDialog(parent,name,modal,f)
{
  setCaption(tr("QuiteInsane - Options"));
  initWidget();
  loadSettings();
}
QExtensionWidget::~QExtensionWidget()
{
}
/**  */
void QExtensionWidget::initWidget()
{
  QString qs;
  int subspacing;
  subspacing = 7;
	QPixmap* pixmap = new QPixmap((const char **)fileopen);
//the main layout
	mpMainLayout = new QGridLayout(this,5,2);
  mpMainLayout->setMargin(8);
  mpMainLayout->setSpacing(5);
//create mpWhatsThisButton in a HBox
	QWidget* wtwidget = new QWidget(this);
  QHBoxLayout* qhbwt = new QHBoxLayout( wtwidget,4);
  mpWhatsThisButton = QWhatsThis::whatsThisButton(wtwidget);
	mpWhatsThisButton->setAutoRaise(FALSE);	
  qhbwt->addStretch(1);
  qhbwt->addWidget(mpWhatsThisButton);
  mpMainLayout->addWidget(wtwidget,0,1);
  if(!xmlConfig->boolValue("ENABLE_WHATSTHIS_BUTTON",false))
    wtwidget->hide();
//mpPageListBox
  mpPageListBox = new QListBox(this);
  mpMainLayout->addMultiCellWidget(mpPageListBox,1,4,0,0);

//mpTitleLabel
  mpTitleLabel = new QLabel(this);
  mpMainLayout->addWidget(mpTitleLabel,1,1);

//horizontal separator
  QFrame* sep1 = new QFrame(this);
  sep1->setFrameStyle(QFrame::HLine|QFrame::Sunken);
  sep1->setLineWidth(2);
  mpMainLayout->addWidget(sep1,2,1);

//mpPagesStack
  mpPagesStack = new QWidgetStack(this);
  mpMainLayout->addWidget(mpPagesStack,3,1);

//buttons
  QHBox* bhb = new QHBox(this);
	QPushButton* qpb1 = new QPushButton(tr("&OK"),bhb);
  connect(qpb1,SIGNAL(clicked()),this,SLOT(accept()));
  QWidget* dummy = new QWidget(bhb);
  bhb->setStretchFactor(dummy,1);
	QPushButton* qpb2 = new QPushButton(tr("&Cancel"),bhb);
  connect(qpb2,SIGNAL(clicked()),this,SLOT(reject()));
  mpMainLayout->addMultiCellWidget(bhb,5,5,0,1);

//metric system
  QWidget* opage = new QWidget(mpPagesStack);
  QGridLayout* sublayout = new QGridLayout(opage,4,1);
  sublayout->setMargin(15);
  sublayout->setSpacing(subspacing);
  sublayout->setRowStretch(3,1);
  mpRadioMM = new QRadioButton(tr("&Millimetre"),opage);
  mpRadioCM = new QRadioButton(tr("C&entimetre"),opage);
  mpRadioInch = new QRadioButton(tr("&Inch"),opage);
  sublayout->addWidget(mpRadioMM,0,0);
  sublayout->addWidget(mpRadioCM,1,0);
  sublayout->addWidget(mpRadioInch,2,0);
  mpBGroupMetricSystem = new QButtonGroup(0);
  mpBGroupMetricSystem->insert(mpRadioMM);
  mpBGroupMetricSystem->insert(mpRadioCM);
  mpBGroupMetricSystem->insert(mpRadioInch);
  mpRadioMM->setChecked(TRUE);
  mpPagesStack->addWidget(opage,0);
  mpPageListBox->insertItem(tr("Metric system"));

//Layout
  opage = new QWidget(mpPagesStack);
  sublayout = new QGridLayout(opage,5,1);
  sublayout->setMargin(15);
  sublayout->setSpacing(subspacing);
  sublayout->setRowStretch(4,1);
  mpRadioScrollLayout = new QRadioButton(tr("&Scrollview"),opage);
  mpRadioTabLayout = new QRadioButton(tr("&Tabwidget"),opage);
  mpRadioListLayout = new QRadioButton(tr("&List"),opage);
  mpWhatsThisCheckBox = new QCheckBox(tr("&Enable context help buttons"),
                                       opage);
  sublayout->addWidget(mpRadioScrollLayout,0,0);
  sublayout->addWidget(mpRadioTabLayout,1,0);
  sublayout->addWidget(mpRadioListLayout,2,0);
  sublayout->addWidget(mpWhatsThisCheckBox,3,0);
  mpBGroupLayout = new QButtonGroup(0);
  mpBGroupLayout->insert(mpRadioScrollLayout);
  mpBGroupLayout->insert(mpRadioTabLayout);
  mpBGroupLayout->insert(mpRadioListLayout);
  mpRadioScrollLayout->setChecked(true);
  mpWhatsThisCheckBox->setChecked(true);
  mpPagesStack->addWidget(opage,1);
  mpPageListBox->insertItem(tr("Layout"));

//scanner
  opage = new QWidget(mpPagesStack);
  sublayout = new QGridLayout(opage,5,1);
  sublayout->setMargin(15);
  sublayout->setSpacing(subspacing);
  sublayout->setRowStretch(4,1);
  mpCheckIoMode = new QCheckBox (tr("Use &non blocking IO if available"),opage);
  sublayout->addWidget(mpCheckIoMode,0,0);
  mpCheckIoMode->setChecked(TRUE);
  mpTranslationsCheckBox = new QCheckBox (tr("&Enable backend translations (restart required)"),
                                          opage);
  sublayout->addWidget(mpTranslationsCheckBox,1,0);
  mpTranslationsCheckBox->setChecked(true);
  mpTransPathCheckBox = new QCheckBox (tr("&Set path to backend translations (restart required)"),
                                       opage);
  sublayout->addWidget(mpTransPathCheckBox,2,0);

  QHBox* transhb = new QHBox(opage);
  new QLabel(tr("Translation path:"),transhb);
  mpEditTransPath = new QLineEdit(transhb);
  mpEditTransPath->setText(xmlConfig->stringValue("BACKEND_TRANSLATIONS_PATH",
                                                 QString::null));
	mpButtonTransPath = new QToolButton(transhb);
  mpButtonTransPath->setPixmap(*pixmap);
  transhb->setStretchFactor(mpEditTransPath,1);
  sublayout->addWidget(transhb,3,0);
	connect(mpButtonTransPath,SIGNAL(clicked()),this,
          SLOT(slotChangeTransPath()));
	connect(mpTransPathCheckBox,SIGNAL(toggled(bool)),transhb,
          SLOT(setEnabled(bool)));
  mpTransPathCheckBox->setChecked(false);
  transhb->setEnabled(false);

  mpPagesStack->addWidget(opage,2);
  mpPageListBox->insertItem(tr("Scanner"));

//Preview
  opage = new QWidget(mpPagesStack);
  sublayout = new QGridLayout(opage,4,1);
  sublayout->setMargin(15);
  sublayout->setSpacing(subspacing);
  sublayout->setRowStretch(3,1);
  mpSmoothPreviewCheckBox = new QCheckBox(tr("&Use smooth scaling"),opage);
  sublayout->addWidget(mpSmoothPreviewCheckBox,0,0);
  mpContinousUpdateCheckBox = new QCheckBox(tr("&Enable continous update"),opage);;
  sublayout->addWidget(mpContinousUpdateCheckBox,1,0);
  QHBox* pvhbox = new QHBox(opage);
  mpLimitPreviewCheckBox = new QCheckBox(tr("&Limit preview resolution"),pvhbox);
  mpLimitPreviewSpin = new QSpinBox(25,20000,1,pvhbox);
  pvhbox->setStretchFactor(mpLimitPreviewCheckBox,1);
  sublayout->addWidget(pvhbox,2,0);

  mpPagesStack->addWidget(opage,3);
  mpPageListBox->insertItem(tr("Preview"));

//automatic selection
  opage = new QWidget(mpPagesStack);
  sublayout = new QGridLayout(opage,7,2);
  sublayout->setMargin(15);
  sublayout->setSpacing(subspacing);
  sublayout->setRowStretch(6,1);
  sublayout->setColStretch(0,1);
  QLabel* collabel = new QLabel(tr("Standard deviation factor (color)"),opage);
  mpAutoColorSpin = new QDoubleSpinBox(opage);
  mpAutoColorSpin->setRange(1,500);
  mpAutoColorSpin->setValue(120);
  QLabel* graylabel = new QLabel(tr("Standard deviation factor (grayscale)"),opage);
  mpAutoGraySpin = new QDoubleSpinBox(opage);
  mpAutoGraySpin->setRange(1,500);
  mpAutoGraySpin->setValue(120);
  QLabel* sizelabel = new QLabel(tr("Minimal size (percent)"),opage);
  mpAutoSizeSpin = new QDoubleSpinBox(opage);
  mpAutoSizeSpin->setRange(1,100);
  mpAutoSizeSpin->setValue(5);
  QGroupBox* autogb = new QGroupBox(1,Qt::Horizontal,
                                    tr("Background gray value is"),opage);
  QHBox* autohb1 = new QHBox(autogb);
  autohb1->setSpacing(5);
  mpAutoSmallerRadio = new QRadioButton(tr("smaller than (black background):"),autohb1);
  mpAutoSmallerSpin = new QSpinBox(0,255,1,autohb1);
  autohb1->setStretchFactor(mpAutoSmallerRadio,1);

  QHBox* autohb2 = new QHBox(autogb);
  autohb2->setSpacing(5);
  mpAutoGreaterRadio = new QRadioButton(tr("greater than (white background):"),autohb2);
  mpAutoGreaterSpin = new QSpinBox(0,255,1,autohb2);
  autohb2->setStretchFactor(mpAutoGreaterRadio,1);

  mpAutoCheckBox = new QCheckBox(tr("Enable automatic preview selection"),opage);
  mpAutoCheckBox->setChecked(false);

  mpAutoTemplateCheckBox = new QCheckBox(tr("Disable automatic preview selection, "
                                       "when template is selected in preview window"),opage);
  mpAutoTemplateCheckBox->setChecked(true);

  mpAutoButtonGroup = new QButtonGroup(this);
  mpAutoButtonGroup->hide();
  mpAutoButtonGroup->insert(mpAutoSmallerRadio);
  mpAutoButtonGroup->insert(mpAutoGreaterRadio);
  mpAutoSmallerRadio->setChecked(true);

  sublayout->addWidget(collabel,0,0);
  sublayout->addWidget(mpAutoColorSpin,0,1);
  sublayout->addWidget(graylabel,1,0);
  sublayout->addWidget(mpAutoGraySpin,1,1);
  sublayout->addWidget(sizelabel,2,0);
  sublayout->addWidget(mpAutoSizeSpin,2,1);
  sublayout->addMultiCellWidget(autogb,3,3,0,1);
  sublayout->addMultiCellWidget(mpAutoCheckBox,4,4,0,1);
  sublayout->addMultiCellWidget(mpAutoTemplateCheckBox,5,5,0,1);

  mpPagesStack->addWidget(opage,4);
  mpPageListBox->insertItem(tr("Auto-selection"));

//Miscelleanous
  opage = new QWidget(mpPagesStack);
  sublayout = new QGridLayout(opage,2,1);
  sublayout->setMargin(15);
  sublayout->setSpacing(subspacing);
  sublayout->setRowStretch(1,1);
  //size warning
  QHBox* warnhb = new QHBox(opage);
  mpWarningLabel = new QLabel(tr("Size warning (in MB)"),warnhb);
  mpWarningSpinBox = new QSpinBox(1,512,1,warnhb);
  warnhb->setStretchFactor(mpWarningLabel,1);
  sublayout->addWidget(warnhb,0,0);

  mpPagesStack->addWidget(opage,5);
  mpPageListBox->insertItem(tr("Miscellaneous"));

//style
  opage = new QWidget(mpPagesStack);
  sublayout = new QGridLayout(opage,2,2);
  sublayout->setMargin(15);
  sublayout->setSpacing(subspacing);
  sublayout->setRowStretch(5,1);
  sublayout->setColStretch(0,1);
  QLabel* stylelabel = new QLabel(tr("Style (restart required)"),opage);
  mpStyleCombo = new QComboBox(opage);
  sublayout->addMultiCellWidget(stylelabel,0,0,0,1);
  sublayout->addMultiCellWidget(mpStyleCombo,1,1,0,1);
  mpStyleCombo->insertItem(tr("Default"),0);
  mpStyleCombo->insertItem(tr("CDE"),1);
  mpStyleCombo->insertItem(tr("Motif"),2);
  mpStyleCombo->insertItem(tr("Motif Plus"),3);
  mpStyleCombo->insertItem(tr("Platinum"),4);
  mpStyleCombo->insertItem(tr("Windows"),5);
  mpPagesStack->addWidget(opage,6);
  mpPageListBox->insertItem(tr("Style"));

  connect(mpPageListBox,SIGNAL(highlighted(int)),
          this,SLOT(slotChangePage(int)));

	mpMainLayout->setRowStretch(3,1);
  mpMainLayout->setColStretch(0,1);
  mpMainLayout->setColStretch(1,1);
  mpMainLayout->activate();
  mpPageListBox->setCurrentItem(0);
  mpPageListBox->setMinimumWidth(mpPageListBox->maxItemWidth()+4);
  mpPagesStack->raiseWidget(0);
  createWhatsThisHelp();
}
/**  */
bool QExtensionWidget::nonBlockingIO()
{
	return mpCheckIoMode->isChecked();
}

/**  */
void QExtensionWidget::loadSettings()
{
  mpBGroupMetricSystem->setButton(xmlConfig->intValue("METRIC_SYSTEM",0));
  mpBGroupLayout->setButton(xmlConfig->intValue("LAYOUT",0));
  mpSmoothPreviewCheckBox->setChecked(xmlConfig->boolValue("PREVIEW_SMOOTH_SCALING",false));
  mpLimitPreviewSpin->setValue(xmlConfig->intValue("PREVIEW_SIZE_LIMIT",300));
  mpLimitPreviewCheckBox->setChecked(xmlConfig->boolValue("PREVIEW_DO_LIMIT_SIZE",false));
  mpTranslationsCheckBox->setChecked(xmlConfig->boolValue("ENABLE_BACKEND_TRANSLATIONS",true));
  mpWhatsThisCheckBox->setChecked(xmlConfig->boolValue("ENABLE_WHATSTHIS_BUTTON",true));
  mpCheckIoMode->setChecked(xmlConfig->boolValue("IO_MODE",true));
  mpContinousUpdateCheckBox->setChecked(xmlConfig->boolValue("PREVIEW_CONTINOUS_UPDATE",true));
  mpTransPathCheckBox->setChecked(xmlConfig->boolValue("USE_BACKEND_TRANSLATIONS_PATH",false));
  mpEditTransPath->setText(xmlConfig->stringValue("BACKEND_TRANSLATIONS_PATH",QString::null));
  mpAutoColorSpin->setValue(xmlConfig->intValue("AUTOSELECT_COLOR_FACTOR",8));
  mpAutoGraySpin->setValue(xmlConfig->intValue("AUTOSELECT_GRAY_FACTOR",15));
  mpAutoSizeSpin->setValue(xmlConfig->intValue("AUTOSELECT_SIZE",2));
  mpAutoCheckBox->setChecked(xmlConfig->boolValue("AUTOSELECT_ENABLE",false));
  mpAutoButtonGroup->setButton(xmlConfig->intValue("AUTOSELECT_BG_TYPE",0));
  mpAutoSmallerSpin->setValue(xmlConfig->intValue("AUTOSELECT_MAXIMAL_GRAY_VALUE",100));
  mpAutoGreaterSpin->setValue(xmlConfig->intValue("AUTOSELECT_MINIMAL_GRAY_VALUE",155));
  mpAutoTemplateCheckBox->setChecked(xmlConfig->boolValue("AUTOSELECT_TEMPLATE_DISABLE",true));
  mpWarningSpinBox->setValue(xmlConfig->intValue("SCAN_SIZE_WARNING",2));
  QString qs;
  int index = 0;
  qs = xmlConfig->stringValue("STYLE",QString::null);
  if(qs == "-style=cde")
    index = 1;
  else if(qs == "-style=motif")
    index = 2;
  else if(qs == "-style=motifplus")
    index = 3;
  else if(qs == "-style=platinum")
    index = 4;
  else if(qs == "-style=windows")
    index = 5;
  mpStyleCombo->setCurrentItem(index);
}
/**  */
void QExtensionWidget::slotChangeTransPath()
{
  QString qs;
  qs = QFileDialog::getExistingDirectory(xmlConfig->stringValue("BACKEND_TRANSLATIONS_PATH",
                                                             QString::null),0,0);
  if(!qs.isEmpty())
	{
    mpEditTransPath->setText(qs);
    xmlConfig->stringValue("BACKEND_TRANSLATIONS_PATH",qs);
  }
}
/**  */
void QExtensionWidget::createWhatsThisHelp()
{
//io mode
  QWhatsThis::add(mpCheckIoMode,tr("Activate this check box to enable "
															"non-blocking IO. If you encounter "
															"problems with non-blocking IO, you can "
                              "try to disable this. Be warned that this "
                              "will result in a freeze of the GUI"
                              "while you are scanning."));
//translations
  QWhatsThis::add(mpTranslationsCheckBox,tr("Activate this check box to enable "
															"the backend translations. Changing this option will "
                              "have no effect until you restart QuiteInsane."));
//translation path
  QWhatsThis::add(mpTransPathCheckBox,tr("If you activate this check box, you can "
															"specify a path to the backend translations. Otherwise "
                              "QuiteInsane will use the default path. Changing this "
                              "option will have no effect until you restart QuiteInsane."));
  QWhatsThis::add(mpEditTransPath,tr("Use this lineedit to specify the path to "
															"the backend translations. Changing the path "
                              "will have no effect until you restart QuiteInsane."));
  QWhatsThis::add(mpButtonTransPath,tr("Click this button to open a file dialog "
															"which allows you to set the path for the backend "
                              "translations."));
//metric system mm
  QWhatsThis::add(mpRadioMM,tr("Display all linear dimensions with unit "
														 "millimetre (mm)."));
//metric system inch
  QWhatsThis::add(mpRadioInch,tr("Display all linear dimensions with unit "
														 "inch."));
//metric system cm
  QWhatsThis::add(mpRadioCM,tr("Display all linear dimensions with unit "
														 "centimetre (cm)."));
//layout scrollview
  QWhatsThis::add(mpRadioScrollLayout,tr("If you activate this radio button, "
														   "QuiteInsane will display all options."
                               "in a single scroll view."));
//layout scrollview
  QWhatsThis::add(mpRadioTabLayout,tr("If you activate this radio button, "
														   "QuiteInsane will display every option "
                               "group in a seperate page of a tab widget."));
//layout list
  QWhatsThis::add(mpRadioListLayout,tr("If you activate this radio button, "
                               "QuiteInsane will display a listview, "
                               "which shows the available option groups."));
//continous update
  QWhatsThis::add(mpContinousUpdateCheckBox,tr("If you activate this checkbox, the "
										   "preview will be updated continously during "
                       "a preview scan."));
//smooth scaling size
  QWhatsThis::add(mpSmoothPreviewCheckBox,
                  tr("Select this checkbox to enable smooth scaling "
                     "for the preview window. This results in better preview images, "
                     "but also slows down resizing of the preview window."));
//whatsthis buttons
  QWhatsThis::add(mpWhatsThisCheckBox,
                  tr("Select this checkbox to enable the built-in context help "
                     "buttons (\"What's this\" buttons). Disabling this option "
                     "only makes sense, if the window-manager supplies its own "
                     "context help buttons in the window titlebar."));
//whatsthis buttons
  QWhatsThis::add(mpStyleCombo,
                  tr("Change the style of the plugin. "
                     "The availabilty of the listed styles depends on the Qt library. "
                     "It's possible, that not every style listed here is available. "
                     "Changes to this option require a restart of the plugin."));
//size warning
  QWhatsThis::add(mpWarningSpinBox,tr("When the expected scan size exceeds the adjusted size, "
                               "then the image information in the upper left corner of the "
                               "scan-dialog is displayed with a red background."));
//auto-selection color
  QWhatsThis::add(mpAutoColorSpin,tr("Use this spinbox to adjust the automatic selection "
                               "of color images. Increase the value, if the detected "
                               "scan-area is bigger then the image size. Decrease the value, "
                               "if the detected scan-area is smaller then the image size."));
//auto-selection gray
  QWhatsThis::add(mpAutoGraySpin,tr("Use this spinbox to adjust the automatic selection "
                               "of grayscale images. Increase the value, if the detected "
                               "scan-area is bigger then the image size. Decrease the value, "
                               "if the detected scan-area is smaller then the image size."));
//auto-selection enable
  QWhatsThis::add(mpAutoCheckBox,tr("If you select this checkbox, the automatic scan-area "
                               "selection is started after a preview scan. You can also start "
                               "the scan-area selection manually by clicking the \"Automatic "
                               "selection\" button in the preview window."));
//auto-selection
  QWhatsThis::add(mpAutoGreaterRadio,tr("Select this radio button, if the scanner cover is white."));
//auto-selection
  QWhatsThis::add(mpAutoSmallerRadio,tr("Select this radio button, if the scanner cover is "
                               "black/dark."));
//auto-selection
  QWhatsThis::add(mpAutoGreaterSpin,tr("Only lines/rows with an average gray-value greater than "
                               "the selected value are interpreted as background."));
//auto-selection
  QWhatsThis::add(mpAutoSmallerSpin,tr("Only lines/rows with an average gray-value smaller than "
                               "the selected value are interpreted as background."));
//auto-selection minimal size
  QWhatsThis::add(mpAutoSizeSpin,tr("Use this spinbox to select the minimal size of preview images. "
                               "The value is multiplied with the maximal image width/height. E.g. a "
                               "value of 0.01 means, that the minimal preview size equals one "
                               "percent of the scan-area. This value is used to ensure, that e.g "
                               "small spots (like dust) aren't interpreted as images."));
}
/**  */
void QExtensionWidget::slotChangePage(int index)
{
  mpPagesStack->raiseWidget(index);
  mpTitleLabel->setText("<b>"+mpPageListBox->currentText()+"</b>");
}
/**  */
void QExtensionWidget::accept()
{
  QIN::MetricSystem ms = QIN::Millimetre;
  QIN::Layout nl = QIN::ScrollLayout;
  QString qs;

  xmlConfig->setBoolValue("USE_BACKEND_TRANSLATIONS_PATH",mpTransPathCheckBox->isChecked());
  xmlConfig->setStringValue("BACKEND_TRANSLATIONS_PATH",mpEditTransPath->text());
  xmlConfig->setBoolValue("PREVIEW_SMOOTH_SCALING",mpSmoothPreviewCheckBox->isChecked());
  xmlConfig->setBoolValue("ENABLE_BACKEND_TRANSLATIONS",mpTranslationsCheckBox->isChecked());
  xmlConfig->setBoolValue("ENABLE_WHATSTHIS_BUTTON",mpWhatsThisCheckBox->isChecked());
  xmlConfig->setBoolValue("PREVIEW_CONTINOUS_UPDATE",mpContinousUpdateCheckBox->isChecked());
  xmlConfig->setIntValue("PREVIEW_SIZE_LIMIT",mpLimitPreviewSpin->value());
  xmlConfig->setBoolValue("PREVIEW_DO_LIMIT_SIZE",mpLimitPreviewCheckBox->isChecked());
  if(mpRadioMM->isChecked())
    ms = QIN::Millimetre;
  else if(mpRadioCM->isChecked())
    ms = QIN::Centimetre;
  else if(mpRadioInch->isChecked())
    ms = QIN::Inch;
  xmlConfig->setIntValue("METRIC_SYSTEM",ms);

  if(mpRadioScrollLayout->isChecked())
    nl = QIN::ScrollLayout;
  else if(mpRadioTabLayout->isChecked())
    nl = QIN::TabLayout;
  else if(mpRadioListLayout->isChecked())
    nl = QIN::ListLayout;
  xmlConfig->setIntValue("LAYOUT",nl);
  xmlConfig->setBoolValue("IO_MODE",mpCheckIoMode->isChecked());

  xmlConfig->setIntValue("AUTOSELECT_COLOR_FACTOR",mpAutoColorSpin->value());
  xmlConfig->setIntValue("AUTOSELECT_GRAY_FACTOR",mpAutoGraySpin->value());
  xmlConfig->setIntValue("AUTOSELECT_SIZE",mpAutoSizeSpin->value());
  xmlConfig->setBoolValue("AUTOSELECT_ENABLE",mpAutoCheckBox->isChecked());
  if(mpAutoSmallerRadio->isChecked())
    xmlConfig->setIntValue("AUTOSELECT_BG_TYPE",0);
  else
    xmlConfig->setIntValue("AUTOSELECT_BG_TYPE",1);
  xmlConfig->setIntValue("AUTOSELECT_MAXIMAL_GRAY_VALUE",mpAutoSmallerSpin->value());
  xmlConfig->setIntValue("AUTOSELECT_MINIMAL_GRAY_VALUE",mpAutoGreaterSpin->value());
  xmlConfig->setBoolValue("AUTOSELECT_TEMPLATE_DISABLE",mpAutoTemplateCheckBox->isChecked());
  xmlConfig->setIntValue("SCAN_SIZE_WARNING",mpWarningSpinBox->value());
  int index;
  index = mpStyleCombo->currentItem();
  if(index == 1)
    qs = "-style=cde";
  else if(index == 2)
    qs = "-style=motif";
  else if(index == 3)
    qs = "-style=motifplus";
  else if(index == 4)
    qs = "-style=platinum";
  else if(index == 5)
    qs = "-style=windows";
  else
    qs = QString::null;
  xmlConfig->setStringValue("STYLE",qs);

  QDialog::accept();
}
/**  */
void QExtensionWidget::setPage(int index)
{
  mpPageListBox->setSelected(index,true);
  slotChangePage(index);
  if(index>-1)
  {
    mpPageListBox->hide();
    mpMainLayout->setColStretch(0,0);
    mpMainLayout->setColStretch(1,1);
    mpMainLayout->activate();
    resize(minimumSizeHint().width(),height());
  }
  else
  {
    mpPageListBox->show();
    mpMainLayout->setColStretch(0,1);
    mpMainLayout->setColStretch(1,1);
  }
}
