/*
 * This Game is distributed under the GNU GENERAL PUBLIC LICENSE 
 * version 2. See COPYING for details.                           
 *                                                               
 * Copyright (C) 1999-2002 Harry Storbacka                      
*/

#include <ClanLib/display.h>
#include <ClanLib/core.h>
#include <ClanLib/gl.h>

#include "graphics.h"
#include "object_3d.h"
#include "race_text.h"
#include "debug.h"
#include "config.h"
#include "game_config.h"
#include "car_config.h"
#include "car_loader.h"
#include "car_sfx.h"

std::vector<std::string> CarLoader::car_list;
bool CarLoader::inited = false;


void CarLoader::init()
{
	if( inited ) return;

	// Load car list
	CL_String list_path = "data/car_list.lst";
	
	CL_InputSourceProvider *input = CL_InputSourceProvider::create_file_provider("");
	CL_InputSource *file = input->open_source( list_path );
	
	bool a = true;
	while( a )
	{
		std::string name = RaceText::read_line(file).get_string();

		if( name == "#end" )
			a = false;
		else
			car_list.push_back(name);
	}

	inited = true;
}

void CarLoader::load_cars()
{
	if( !inited ) init();

	for( int i=0; i<8; i++ )
		load_car(i);
}


void CarLoader::load_car(int car_num)
{
	CL_String car_path = DATADIR;
	car_path += "cars/";
	car_path += car_list[Config::cc->car[car_num]];
	car_path += "/";
	
	Config::cc->dir_path[car_num] = car_path;
	
	car_path += car_list[Config::cc->car[car_num]];
	car_path += ".res";
	
	Config::cc->res_path[car_num] = car_path;
	
//	cout << "Path of the [car].res we're trying to load: " << endl;
//	cout << car_path.get_string() << endl;
	
	RaceDebug::print( CL_String("Resources: ") + car_path, 7 );
	CL_ResourceManager res( car_path, false );
	
//	cout << "Name of the resource we're trying to load: " << endl;
//	cout << car_type.get_string() << endl;
	
	// GRAPHICS 
	
	//Gfx::CarGfx->car[car_num] = CL_Surface::load( car_type.get_string(), &res );
	
	if( Gfx::CarGfx->car[car_num] != NULL )
		delete Gfx::CarGfx->car[car_num];
	
	// load car 3d model
/*	CL_Resource car_res = res.get_resource( "model" );
	car_res.load();
	
	CL_String full_path = car_res.get_full_location();
	CL_String path("model", &res);
//	cout << "car model path: " << full_path.get_string() << endl;
*/	
//	Gfx::CarGfx->car[car_num] = new Object3D(full_path);
	Gfx::CarGfx->car[car_num] = Object3D::load("model", &res);
	
	// load texture
	
//	std::cout << "loading car texture" << std::endl;
	CL_Surface *tmp_tex = CL_Surface::load("texture", &res);
	Gfx::CarGfx->texture[car_num] = Texture(tmp_tex);
//	std::cout << "loading car texture -- done" << std::endl;
	
	// SOUND
	
	#ifdef RACE_SOUND
		RaceDebug::print("loading sounds", 11);
		
		CL_String h("sound/engine/high");
		CL_String l("sound/engine/low");
		CL_String s("sound/engine/start");

//		delete CarSfx::engine_high[car_num];
//		delete CarSfx::engine_low[car_num];
		
		CarSfx::engine_high.push_back( CL_SoundBuffer::load( h, &res ) );
		CarSfx::engine_low.push_back( CL_SoundBuffer::load( l, &res ) );
		
		if( car_num == 1 )
			CarSfx::engine_start = CL_SoundBuffer::load( s, &res );
		
		Config::cc->change_pitch_h[car_num] = CL_Boolean( "sound/engine/change_pitch_h", &res );
		Config::cc->change_pitch_l[car_num] = CL_Boolean( "sound/engine/change_pitch_l", &res );
	
	#endif // RACE_SOUND
	
	// VALUES
	
	Config::cc->road_speed[car_num] = CL_Integer( "road_speed", &res ) /100;
	Config::cc->terrain_speed[car_num] = CL_Integer( "terrain_speed", &res ) /100;
	Config::cc->turn_delay[car_num] = CL_Integer( "turn_delay", &res ) /100;
	
	Config::cc->loaded[car_num] = true; // car is loaded.
}


