#ifndef race_misc_config
#define race_misc_config

#include <ClanLib/display.h>

class CarConfig;

class Config
{
 public:
	static bool load_config();
	static bool save_config();
	
	static CarConfig *cc;
	
	static float water_level;
	
	static float difficulty_level;
	static short race_length;
	static short final_positions;
	
	static std::vector<std::string> selected_tracks;
	static std::vector<std::string> names;

	static short screen_width;
	static short screen_height;
	
	static short num_players;
	static short num_ai;
	static short num_cars;
	static short save_texture;
	
	static int selected_theme;
	static int sfx_on;
	static int music_on;
	
	static int random_theme;
	
	static bool abandon_season;
	
	static bool mirror_fill;
	 // true: flip every second texture to make seamles (good for i.e. plasma based textures)
	 // false: no flipping
	
	static bool big_road_texture; // todo
	 // true: use one texture as road (makes texture blurry)
	 // false: make a exact mesh where texture is repeated. (not blurry unless texture is blurry)
	
	static int terrain_resolution;
	static char screen_resolution;
	
	// KEYS
	
	static CL_Key one_player_key_gas;
	static CL_Key one_player_key_brakes;
	static CL_Key one_player_key_left;
	static CL_Key one_player_key_right;
	
	// THEME VARIABLES
	
	static float road_speed;
	static float terrain_speed;
	static float skid_speed_decrease;
	static float no_gas_speed_decrease;
	static float brakes_speed_decrease;
	static float update_dir_timer;
	static char tyre_grip;
	
	static CL_String theme_path;
	static CL_String theme_name;
	
	static bool in_editor; // TODO: remove?
	
	// SOUND
	
	static float engine_sound_radius;
	
	// TRACK
	
	static char tile_size;
	static char map_tiles_x;
	static char map_tiles_y;
};

#endif


