#include <ClanLib/core.h>
#include <ClanLib/display.h>

#include "menu_gfx.h"
#include "../debug.h"
#include "../config.h"

CL_Surface* MenuGfx::bg               = NULL;
CL_Surface* MenuGfx::submenu_frame_bg = NULL;
CL_Surface* MenuGfx::title_options    = NULL;
CL_Surface* MenuGfx::title_credits    = NULL;

void MenuGfx::init()
{
	RaceDebug::print( "Resources: resources/menu.res", 7 );

	CL_String path = DATADIR;
	path += "resources/menu.res";
	CL_ResourceManager *res = new CL_ResourceManager( path, false );
	
	MenuGfx::bg = CL_Surface::load( "Menu/bg", res );
	MenuGfx::submenu_frame_bg = CL_Surface::load( "Menu/submenu_frame_bg", res );
	
	MenuGfx::title_options = CL_Surface::load( "Menu/title_options", res );
	MenuGfx::title_credits = CL_Surface::load( "Menu/title_credits", res );
}

