#include <ClanLib/core.h>
#include <ClanLib/display.h>
#include <ClanLib/gl.h>
#include <ClanLib/gui.h>

#ifdef WIN32
	#pragma warning (disable:4355)
#endif

#include "../menu_gfx.h"
#include "../../game_config.h"
#include "../../debug.h"
#include "options_graphics.h"

OptionsGraphics::OptionsGraphics(CL_Component *parent, CL_StyleManager *style)
:
	CL_Component(
			CL_Rect(145, 150, CL_Display::get_width(), CL_Display::get_height()),
			parent,
			style),
		scroll_terrain_res( CL_Rect( 240, 10, 420,  30 ), 30, 150, true, this, style ),
		label_terrain_res(  CL_Rect(  10, 10,  30, 50 ), "Terrain resolution", this, style ),
		scroll_screen_res( CL_Rect( 240, 40, 420,  60 ), 0, 2, true, this, style ),
		label_screen_res(  CL_Rect(  10, 40,  30, 70 ), "Terrain resolution", this, style )
{
	RaceDebug::print( "OptionsGraphics: constructor", 9 );

	on_terrain_res(Config::terrain_resolution);
	scroll_terrain_res.set_value(Config::terrain_resolution);

	on_screen_res(Config::screen_resolution);
	scroll_screen_res.set_value(Config::screen_resolution);

	slots.connect( sig_paint(), this,  &OptionsGraphics::on_paint );
	slots.connect( scroll_terrain_res.sig_value_changed(), this, &OptionsGraphics::on_terrain_res );
	slots.connect( scroll_screen_res.sig_value_changed(), this, &OptionsGraphics::on_screen_res );
}

void OptionsGraphics::on_paint()
{
	MenuGfx::submenu_frame_bg->put_screen(0,0);
}

void OptionsGraphics::on_terrain_res(int num)
{
	CL_String str = "Terrain resolution: ";
	str += num;
	label_terrain_res.set_text(str);
	Config::terrain_resolution = num;
}

void OptionsGraphics::on_screen_res(int num)
{
	CL_String str = "Screen resolution: ";
	
	switch( num )
	{
		case 0: str += "640x480"; break;
		case 1: str += "800x600"; break;
		case 2: str += "1024x768"; break;
	}
	
	label_screen_res.set_text(str);
}
