/*
 * This Game is distributed under the GNU GENERAL PUBLIC LICENSE
 * version 2. See COPYING for details.
 *
 * Copyright (C) 1999-2002,  Harry Storbacka <harrysto@nic.fi> 
 * 
 * Race homepage: http://race.sourceforge.net
*/
  
#include <ClanLib/application.h>
#include <ClanLib/display.h>
#include <ClanLib/core.h>
#include <ClanLib/jpeg.h>
#include <ClanLib/png.h>
#include <ClanLib/gui.h>
#include <ClanLib/gl.h>

#include <iostream>
#include <cstdio>
#include <cmath>

#ifdef WIN32
#define RACE_SOUND
#endif

#ifdef RACE_SOUND
	#include <ClanLib/sound.h>

	#ifdef RACE_VORBIS
		 #include <ClanLib/vorbis.h>
	#endif
#endif

// 

#include "race.h"
#include "config.h"
#include "game_config.h"
#include "game_data.h"
#include "graphics.h"
#include "fonts.h"
#include "debug.h"
#include "info_gfx.h"
#include "track.h"
#include "keyboard.h"
#include "race_opengl.h"

// menu
#include "menu/GUI/stylemanager_opengl.h"
#include "menu/mainmenu.h"
#include "menu/menu_gfx.h"

// sounds
#include "music.h"
#include "menu_sfx.h"
#include "car_sfx.h"
#include "track_sfx.h"


RaceApplication app; // don't delete ;)


char *RaceApplication::get_title()
{
	return "Race 0.7.0 - http://race.sf.net #race @ irc.openprojects.net";
}

int RaceApplication::main(int argc, char** argv)
{
#ifdef _DEBUG
	CL_ConsoleWindow console("Race debug window");
	console.redirect_stdio();

	std::cout << "Testing debug window" << std::endl;
#endif
	
	try
	{
		bool fullscreen = false;	
		
		if( argc > 1 )
			fullscreen = true;
		
		CL_SetupCore::init();
		CL_SetupGL::init();
		CL_SetupDisplay::init();
		CL_SetupGUI::init();
		CL_SetupJPEG::init();
		CL_SetupPNG::init();
		CL_SetupSound::init();
		
#ifdef RACE_SOUND
	#ifdef RACE_VORBIS
		CL_SetupVorbis::init();
	#endif
#endif	

		srand(time(NULL));
		
		// Set videomode resolution and bpp (bits per pixel)
//		CL_Display::set_videomode(640, 480, 16, fullscreen);
		CL_Display::set_videomode(Config::screen_width, Config::screen_height, 16, fullscreen);


		CL_OpenGL::begin_2d(); // set to init reference count so this isn't called when printing or at put_screen()
		
		init_misc_stuff();
		
		// Setup resources for menu gui:
		RaceDebug::print( "Resources: resources/gui.res", 7 );

		CL_String grpath = DATADIR;
		grpath += "resources/gui.res";
		CL_ResourceManager *resources = new CL_ResourceManager( grpath, false);
		// Setup styles for menu gui:
		CL_StyleManager_OpenGL styles(resources);

		Race_OpenGL::begin_2d();
		MainMenu menu( NULL, &styles );
		cout << "run mainmenu" << endl;
		menu.run();
		
		Config::save_config();
		
		delete resources;
	}
	catch (CL_Error err)
	{
		std::cout << "Exeception caught: " << err.message << std::endl;
	}
	
#ifdef RACE_VORBIS
	CL_SetupVorbis::deinit();
#endif

	CL_SetupCore::deinit();
	CL_SetupGL::deinit();
	CL_SetupDisplay::deinit();
//	CL_SetupSound::deinit(); // makes it segfault at exit 
	CL_SetupJPEG::deinit();
	CL_SetupPNG::deinit();
	CL_SetupGUI::deinit();
	
#ifdef _DEBUG
	console.display_close_message();
#endif
	
	return 0;
}

void RaceApplication::init_misc_stuff()
{
	// OpenGL
	glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
	
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST );
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST );
	glTexEnvf( GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE );
//	glTexEnvf( GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL );
	
	glEnable(GL_BLEND);
	glBlendFunc( GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA );
	
//	glCullFace(GL_BACK);
//	glHint(GL_POLYGON_SMOOTH_HINT, GL_NICEST);
//	glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);
	
	glDepthFunc(GL_LESS);                   // The Type Of Depth Test To Do
	glEnable(GL_DEPTH_TEST);
	glClearDepth(1.0);						// Enables Clearing Of The Depth Buffer
	
	glShadeModel(GL_SMOOTH);                // Enables Smooth Color Shading
	
	glEnable( GL_TEXTURE_2D );

	glColor4f( 1.0f, 1.0f, 1.0f, 1.0f );
	
	// load config etc.
	
	Config::load_config();
	Track::init();

	Music::init();

	// GRAPHICS 

	Gfx::TrackGfx->init();
	Gfx::CarGfx->init();
	
	MenuGfx::init();
	InfoGfx::init();
	
	Fonts::init();
	
	// SOUNDS 
	
	MenuSfx::init();
	TrackSfx::init();
	CarSfx::init();
	
	// misc
	Keyboard::init_keys();
}





