/*
 *  Copyright 2001-2004 Adrian Thurston <adriant@ragel.ca>
 */

/*  This file is part of Ragel.
 *
 *  Ragel is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Ragel is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Ragel; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 */

#ifndef _FGOTOCODEGEN_H
#define _FGOTOCODEGEN_H

#include <iostream>
#include "gotocodegen.h"

/* Forwards. */
struct ParseData;


/*
 * class FGotoCodeGen
 */
class FGotoCodeGen : public GotoCodeGen
{
public:
	FGotoCodeGen( char *fsmName, ParseData *parseData, 
			RedFsmAp *redFsm, std::ostream &out );

	std::ostream &EXEC_ACTIONS();
	std::ostream &FINISH_CASES();
};



/*
 * class CFGotoCodeGen
 */
class CFGotoCodeGen : public FGotoCodeGen
{
public:
	CFGotoCodeGen( char *fsmName, ParseData *parseData, 
			RedFsmAp *redFsm, std::ostream &out );

	std::ostream &CALL( NameInst *name, int targState, bool inFinish );
	std::ostream &RET( bool inFinish );
	std::ostream &CALLE( InlineItem *ilItem, int targState, bool inFinish );

	virtual void writeOutHeader() { C_HEADER(); }
	virtual void writeOutCode();
};


/*
 * class CppFGotoCodeGen
 */
class CppFGotoCodeGen : public FGotoCodeGen
{
public:
	CppFGotoCodeGen( char *fsmName, ParseData *parseData, 
			RedFsmAp *redFsm, std::ostream &out );

	std::ostream &CALL( NameInst *name, int targState, bool inFinish );
	std::ostream &RET( bool inFinish );
	std::ostream &CALLE( InlineItem *ilItem, int targState, bool inFinish );

	virtual void writeOutHeader() { CPP_HEADER(); }
	virtual void writeOutCode();
};


/*
 * class ObjCFGotoCodeGen
 */
class ObjCFGotoCodeGen : public FGotoCodeGen
{
public:
	ObjCFGotoCodeGen( char *fsmName, ParseData *parseData, 
			RedFsmAp *redFsm, std::ostream &out );

	std::ostream &CALL( NameInst *name, int targState, bool inFinish );
	std::ostream &RET( bool inFinish );
	std::ostream &CALLE( InlineItem *ilItem, int targState, bool inFinish );

	virtual void writeOutHeader() { OBJC_HEADER(); }
	virtual void writeOutCode();
};

#endif /* _FGOTOCODEGEN_H */
