/**
 * Test a high character to make sure signedness 
 * isn't messing us up.
 */

#include <stdio.h>
#include <objc/Object.h>

%% Fsm
	# We Want the header portion.
	struct : Object { };
	alphtype unsigned char;

	# Indicate we got the high character.
	action gothigh {
		printf("yes\n");
	}

	main := 0xe8 @gothigh '\n';
%%


#define BUFSIZE 2048

Fsm *fsm;
unsigned char buf[BUFSIZE];

int main()
{
	fsm = [[Fsm alloc] init];
	
	[fsm initFsm];
	while ( 1 ) {
		int len = fread( buf, 1, BUFSIZE, stdin );
		[fsm executeWithData:buf len:len];
		if ( len != BUFSIZE )
			break;
	}
	if ( [fsm finish] > 0 )
		printf("ACCEPT\n");
	else
		printf("FAIL\n");
	
	return 0;
}

