#! /bin/sh
#
#	recite - english text speech synthesizer
#	Copyright (C) 1993 Peter Miller.
#	All rights reserved.
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 1, or (at your option)
#	any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# MANIFEST: Test the english_to_phonemes functionality
#

work=/tmp/$$
PAGER=cat
export PAGER

here=`pwd`
if test $? -ne 0 ; then exit 1; fi

fail()
{
	set +x
	echo FAILED test of english_to_phonemes functionality 1>&2
	cd $here
	rm -rf $work
	exit 1
}
pass()
{
	set +x
	cd $here
	rm -rf $work
	exit 0
}
trap "fail" 1 2 3 15

mkdir $work
if test $? -ne 0 ; then exit 1; fi
cd $work
if test $? -ne 0 ; then fail; fi

#
# with input like this
#
cat > test.in << 'fubar'
The quick brown fox jumps
over the lazy dog
fubar
if test $? -ne 0 ; then fail; fi

#
# expect output like this
#
cat > test.ok << 'fubar'
DHAX kwIH1k brOW1n fAA1ks jAH5mps 
OW5vER DHAX lEY4zIY dAA1g 
fubar
if test $? -ne 0 ; then fail; fi

#
# turn the text into phonemes
#
$here/bin/recite -wp < test.in > test.out
if test $? -ne 0 ; then fail; fi
diff test.ok test.out
if test $? -ne 0 ; then fail; fi

#
# with input like this
#
cat > test.in << 'fubar'
now is the time for all good men
to come to the aid of their party
fubar
if test $? -ne 0 ; then fail; fi

#
# expect output like this
#
cat > test.ok << 'fubar'
nAW4 IHz DHAX tAY5m f(OXR) AOl gUH5d mEH1n 
tUW kAHm tUW DHAX EY4d AHv DH(EXR)2 p(AXR)1tIY 
fubar
if test $? -ne 0 ; then fail; fi

#
# turn the text into phonemes
#
$here/bin/recite -wp < test.in > test.out
if test $? -ne 0 ; then fail; fi
diff test.ok test.out
if test $? -ne 0 ; then fail; fi

#
# with input like this
#
cat > test.in << 'fubar'
It is generally believed that all doctors are turkeys.
This is not correct.
Many doctors are quacks.
fubar
if test $? -ne 0 ; then fail; fi

#
# expect output like this
#
cat > test.ok << 'fubar'
IH1t IHz jIY4nER1AElIY bIHlIYIY4vd DHAEt AOl dAA1ktERz (AXR) tER1kIY1s p(IXR)IYAAd 
DHIHs IHz nAA1t k(OXR)rEH1kt p(IXR)IYAAd 
mEH4nIY dAA1ktERz (AXR) kwAEks p(IXR)IYAAd 
fubar
if test $? -ne 0 ; then fail; fi

#
# turn the text into phonemes
#
$here/bin/recite -wp < test.in > test.out
if test $? -ne 0 ; then fail; fi
diff test.ok test.out
if test $? -ne 0 ; then fail; fi

#
# Only definite negatives are possible.
# The functionality exercised by this test appears to work,
# no other guarantees are made.
#
pass
