// 
// $Id: qalisplanguage.cpp,v 1.1 2000/06/12 10:53:28 amos-cvs Exp $
//
// Implementation of QaLispLanguage class
//
// Jan Borsodi <jb@ez.no>
// Created on: <12-Jun-2000 12:19:28 amos>
//
// Copyright (C) Jan Borsodi.  All rights reserved.


#include "qalisplanguage.hpp"
#include <qstring.h>

/*!
  \class QaLispLanguage qalisplanguage.hpp
  \brief
  \author <a href="mailto:jb@ez.no">Jan Borsodi</a>
  \date Enter current date here

*/

/*!
  Default constructor
*/

QaLispLanguage::QaLispLanguage()
    : QaRegExpLanguage()
{
}

/*!
  Destroys the object
*/

QaLispLanguage::~QaLispLanguage()
{
}

/*!
  Converts the RegExp from plain text into a LISP version.
*/

QString QaLispLanguage::fromPlainText( const QString &s, bool code, MatchType type )
{
    QString str;
    bool inbracket = false;
    bool negated = false;
    for ( unsigned int i = 0; i < s.length(); i++ )
    {
        QChar c = s.at( i );
        if ( inbracket )
        {
            if ( c == ']' )
            {
                str += c;
                inbracket = false;
                negated = false;
            }
            else if ( c == '^' )
            {
                str += c;
                negated = true;
            }
            else if ( c == '"' && code )
            {
                str += "\\";
                str += c;
            }
            else if ( c == '\\' )
            {
                if ( i+1 < s.length() )
                {
                    i++;
                    QChar c2 = s.at( i );
                    if ( c2 == 'w' )
                        str += characters();
                    else if ( c2 == 'W' )
                    {
                        if ( !negated )
                        {
                            str += "^";
                            negated = true;
                        }
                        str += characters();
                    }
                    else if ( c2 == 'c' )
                        str += nonCapitalCharacters();
                    else if ( c2 == 'C' )
                        str += capitalCharacters();
                    else if ( c2 == 'i' )
                        str += wordCharacters();
                    else if ( c2 == 'd' )
                        str += QString( "0-9" );
                    else if ( c2 == 'D' )
                    {
                        if ( !negated )
                        {
                            str += "^";
                            negated = true;
                        }
                        str += QString( "0-9" );
                    }
                    else if ( c2 == 's' )
                        str += QString( "[ \\t\\n\\r\\f]" );
                    else if ( c2 == 'S' )
                    {
                        if ( !negated )
                        {
                            str += "^";
                            negated = true;
                        }
                        str += QString( "[^ \\t\\n\\r\\f]" );
                    }
                    else if ( c2 == 't' )
                        str += QString( "\\t" );
                    else if ( c2 == 'n' )
                        str += QString( "\\n" );
                    else if ( c2 == 'r' )
                        str += QString( "\\r" );
                    else if ( c2 == 'f' )
                        str += QString( "\\f" );
                    else if ( c2 == '\\' )
                        str += "\\\\\\\\";
                    else if ( c2 == '(' || c2 == ')' )
                        str += c2;
                    else
                    {
                        str += c;
                        str += c2;
                    }
                }
                else
                    str += c;
            }
            else
                str += c;
        }
        else
        {
            if ( c == '(' || c == ')' || c == '|' )
            {
                str += QString( "\\\\" ) + c;
            }
            else if ( c == '[' )
            {
                str += c;
                inbracket = true;
            }
            else if ( c == '"' && code )
            {
                str += "\\";
                str += c;
            }
            else if ( c == '\\' )
            {
                if ( i+1 < s.length() )
                {
                    i++;
                    QChar c2 = s.at( i );
                    if ( c2 == 'w' )
                        str += QString( "[" ) + characters() + QString( "]" );
                    else if ( c2 == 'W' )
                        str += QString( "[^" ) + characters() + QString( "]" );
                    else if ( c2 == 'c' )
                        str += QString( "[%1]" ).arg( nonCapitalCharacters() );
                    else if ( c2 == 'C' )
                        str += QString( "[%1]" ).arg( capitalCharacters() );
                    else if ( c2 == 'i' )
                        str += QString( "[%1]" ).arg( wordCharacters() );
                    else if ( c2 == 'I' )
                        str += identifiers();
                    else if ( c2 == 'd' )
                        str += QString( "[0-9]" );
                    else if ( c2 == 'D' )
                        str += QString( "[^0-9]" );
                    else if ( c2 == 's' )
                        str += QString( "[ \\t\\n\\r\\f]" );
                    else if ( c2 == 'S' )
                        str += QString( "[^ \\t\\n\\r\\f]" );
                    else if ( c2 == 't' )
                        str += QString( "\\t" );
                    else if ( c2 == 'n' )
                        str += QString( "\\n" );
                    else if ( c2 == 'r' )
                        str += QString( "\\r" );
                    else if ( c2 == 'f' )
                        str += QString( "\\f" );
                    else if ( c2 == '(' || c2 == ')' )
                        str += c2;
                    else if ( c2 == '\\' )
                        str += "\\\\\\\\";
                    else
                    {
                        str += c;
                        str += c2;
                    }
                }
                else
                    str += c;
            }
            else
                str += c;
        }
    }
    if ( code )
    {
        if ( type == QaRegExpLanguage::Multiple )
        {
            str = QString( "(while (search-forward-regexp \"%1\" nil t)\n"
                           "       (buffer-substring (match-beginning 0) (match-end 0)))" )
                .arg( str );
        }
        else if ( type == QaRegExpLanguage::Split )
        {
        }
        else
        {
            str = QString( "(search-forward-regexp \"%1\" nil t)" )
                .arg( str );
        }
    }
    return str;
}
