// 
// $Id: qaregexpwidget.hpp,v 1.4 2000/06/12 10:53:28 amos-cvs Exp $
//
// Definition of QRegExpWidget class
//
// Jan Borsodi <jb@ez.no>
// Created on: <21-Jul-1999 21:22:47 amos>
//
// Copyright (C) Jan Borsodi.  All rights reserved.

#ifndef QREGEXPWIDGET_HPP
#define QREGEXPWIDGET_HPP

#include <qaregexp.hpp>

#include "qaregexplanguage.hpp"

#include <qframe.h>
#include <qlayout.h>
#include <qwidget.h>
#include <qstring.h>
#include <qmultilinedit.h>
#include <qtextbrowser.h>
#include <qlabel.h>
#include <qspinbox.h>
#include <qmainwindow.h>
#include <qpopupmenu.h>
#include <qsplitter.h>
#include <qlistbox.h>
#include <qsize.h>
#include <qlineedit.h>
#include <qevent.h>
#include <qcolor.h>
#include <qobject.h>

class QaRegExpWidget : public QMainWindow
{
    Q_OBJECT
public:
    enum MatchType
    {
        Single,
        Multiple,
        Split
    };
    QaRegExpWidget( QWidget *parent = 0, const char *name = 0 );
    virtual ~QaRegExpWidget();

//      QString convertText( const QString &s );
    QString toHtml( const QString &s );
    void updateMatch();
    void updateOutput();
    void updateOutputMultiple();
    void updateConversion();

    bool loadFile( const QString &name );

    QString version() const;

    QString outputType() const;
    void setOutputType( const QString &str );

public slots:
    void doTextChange( const QString &t );
    void textChange( const QString &t );
    void setExpression( const QString &t );
    void theTextHasChanged();
    void valueChange( int val );
    void valueChangeMultiple( int val );
    void multiTextChanged();
    void doNormal();
    void doMultiple();
    void doSplit();

    void doAbout();
    void doAboutQt();

    void doLoad();
    void doLoadText();
    void doSave();

    void doCompleteOutput();

    void doCase();
    void doSingleLine();
    void doNewLine();
    void doAutomatic();

    void doLoadHistory( int id );

    void doPlain();
    void doLisp();
    void doPerl();
    void doPHP();
    void doQt();

    void doBackColor();
    void doSelectColor();

    void doFunctionKey( int id );
    void doShiftedFunctionKey( int id );

//      void doF1();

//      void doShiftF1();

public:
    virtual void polish();

protected:
    virtual void resizeEvent( QResizeEvent *e );
    void addToHistory( const QString &name, bool infront = true );
    void rebuildHistory();

private:
//      QString wordCharacters() const;
//      QString characters() const;
//      QString capitalCharacters() const;
//      QString nonCapitalCharacters() const;
//      QString identifiers() const;

//      QString toLisp( const QString &s );

    QString configPath() const;
    QString hexColor( const QColor &c ) const;
    QColor fromHex( const QString &s ) const;
    QString selectColor() const;
    void saveConfig();
    void loadConfig();

private:
    QaRegExpLanguage *Language;
    QaRegExpLanguage PlainLanguage;

    QVBoxLayout *Lay;
    QMultiLineEdit *Edit;
    QMultiLineEdit *PatDisp;
    QLineEdit *RegEd;
    QTextBrowser *TextVu;
    QLabel *ErrLabel;
    QLabel *SpeedLabel;
//    QSpinBox *Sub;
    QListBox *Sub;
    QListBox *Matches;
    QaRegExp Reg;
    QWidget *SubWidget;
    QWidget *MatchWidget;
    QLabel *SubLabel;
    QLabel *MatchLabel;
    QString EditString;
    QString ConversionText;
    QWidget *Central;
    MatchType Matching;
    int MatchCount;
    int SubMatch;
    int NumLines;
    bool SingleLine;
    QSize WSize;
    QColor Back, Select;

    bool Update;
    bool Automatic;
    bool Loading;

    QSplitter *MainSplit;
    QSplitter *RightSplit;
    QSplitter *SubSplit;

    QPopupMenu *FileMenu;
    QPopupMenu *MatchMenu;
    QPopupMenu *ModesMenu;
    QPopupMenu *OutputMenu;
    QPopupMenu *EditMenu;
    QPopupMenu *HelpMenu;
    QPopupMenu *HistoryMenu;

    QStringList OldFiles;

    int FileLoadTextID;
    int MatchNormalID;
    int MatchMultipleID;
    int MatchSplitID;
    int MatchCaseID;
    int SingleLineID;
    int NewLineID;
    int AutomaticID;
    int SubValue;

    int EditBackColorID;
    int EditSelectColorID;

    int PlainTextID;
    int LispID;
    int PerlID;
    int PHPID;
    int QtID;

    int CompleteID;
};

#endif // QREGEXPWIDGET_HPP
