\name{RepositoryThemes}
\alias{repositoryThemes}
\alias{RepositoryThemes}
\alias{themes}
\alias{getReposThemePkgs}
\alias{loadRepThemes}
\alias{repThemeNames}
\title{Repository Themes}
\description{
  Repository themes allow a repository maintainer to specify a set of
  packages within their repository that can be downloaded as a
  collection by other users.  Clients using \code{reposTools} can
  specify one of these themes to their installation calls, acquiring
  the particular set of packages listed as being part of the theme.
}
\section{Basic Information}{
  The purpose of repository themes is to allow various subsets of a
  repository's packages to be downloaded easily and conveniently.  As
  the size of a repository grows, there are likely to be small
  collections of packages which have a logical connection to each other
  which users will often want to download together, but it can become
  unwieldy to do so using \code{\link{install.packages2}} in the
  traditional manner.  By specifying a theme, all the
  desired packages can be downloaded quickly and easily.
  
  Themes have a basic structure, which is modeled by the class
  \code{\link{reposTheme-class}}.  Every theme has a name to reference
  it by, a description, information about the repository it is a part
  of, as well as a list of \code{\link{pkgInfo}} objects defining the
  packages that are included in the theme.  This definition is then
  written in a XML file by the repository maintainer (or using the XML
  authoring function \code{\link{writeThemesXML}}) which is in turn read
  in by the \code{\link{genRepos}} function during repository generation
  to create a repository infrastructure file named
  \code{reposThemes.rda} that allows client functions to see
  which themes are available from a repository.

  For the client side user, if one uses the \code{theme} argument to
  \code{\link{install.packages2}}, then \code{reposTools} will seek out
  the specified theme(s) in the set of repositories it is instructed to
  look at and download any packages being marked as being part of that
  theme.
}
\section{XML structure}{
  The repository theme information is contained in an XML file written
  by the repository maintainer (or \code{\link{writeThemesXML}}) called
  \code{repThemes.xml}.  The XML structure for a set of repository
  themes is defined as follows.

  The \code{repositoryThemes} tag defines the primary XML block that is
  specifying the themes for a particular repository.  Since every
  \code{repThemes.xml} file corresponds to a particular repository,
  there should only be one of these blocks per file, and it should
  contain all other XML information.

  Every individual theme is contained in a \code{theme} tag block.
  Every theme for this particular repository needs to be defined as a
  \code{theme} block.

  Within every theme are four main subblocks: The \code{themeName} tag
  block specifies the name of the theme, the \code{themeDesc} tag
  provides for a description of this theme, the \code{themeRepos}
  tag specifies the URL of the repository this theme belongs to and the
  \code{themePackages} tag block specifies what packages are contained
  within that theme. 

  Inside of the \code{themePackages} tag block are a series of
  \code{package} tag blocks, one for every package in the theme.

  The \code{package} blocks contain one or two tags each.  Every
  \code{package} block has a \code{packageName} tag block specifying the
  name of the package, and there is an optional \code{packageVersion}
  tag which allows the maintainer to specify a particular version of
  that package.

  An example of a three package theme is below.  Two of the packages
  have versions specified, and one does not.
  \preformatted{
    <?xml version="1.0"?>
    <repositoryThemes>
       <theme>
         <themeName>Testing</themeName>
	 <themeDesc>This is a small test theme</themeDesc>
	 <themeRepos>http://www.bioconductor.org/repository/</themeRepos>
	 <themePackages>
           <package>
             <packageName>Biobase</packageName>
	     <packageVersion>1.4.2</packageVersion>
           </package>
           <package>
             <packageName>ROC</packageName>
           </package>
           <package>
             <packageName>Ruuid</packageName>
             <packageVersion>1.3.3</packageVersion>
           </package>
         </themePackages>
      </theme>
    </repositoryThemes>
  }
}
\author{Jeff Gentry}
\seealso{\code{\link{writeThemesXML}}, \code{\link{install.packages2}},
  \code{\link{pkgInfo}}, \code{\link{genRepos}}}
\examples{
   ## Need something here
}
\keyword{utilities}

