#ifndef MODIFIER_H
#define MODIFIER_H

#include "../../module.h"

#include <regex.h>
#include <string>
#include <vector>
using namespace std;

class Modifier : public Module
{
public:
        Modifier();
        ~Modifier();
        
        virtual string getName() {
                return "Modifier";
        }

        virtual const DataSetMap& get_module_info() {
                return get_module_info_instance();
        }
        static const DataSetMap &get_module_info_instance();

        static void destroy_module_info() {
                if (moduleInfo)
                        delete moduleInfo;
                moduleInfo = 0;
        }                
private:
        static DataSetMap* moduleInfo;
                        
private:
        void clearFilter();
        void clearReplace();
        bool doReplace(const string& original, string& modified);
        int nextIndex(vector<int>& indexes, int cpos);
        bool checkMask(const bool* mask, int start, int end);
        void setMask(bool* mask, int start, int end);
        
        vector<regex_t> replace;
        vector<string> replaceWith;
        string replaceVar;

        vector<regex_t> filter;
        string filterVar;
        bool filtered;
        
        // true if we are currently processing an update via receiveOutput
        bool groupUpdate;
        
protected:
        void updated(const string& keyName, const DataSet& data);
        void outputReceived(const DataSetMap& output);
};

#endif
