#include <dlfcn.h>
#include <sys/types.h>
#include <dirent.h>
#include <iostream>
using namespace std;

#include "common.h"
#include "plugin.h"

Plugins* Plugins::instance_ = 0;

Plugins::Plugins()
{
}

void Plugins::load(const string& pluginDir)
{
        if (verbose)
                cout << "Plugin dir: \"" << pluginDir << "\"" << endl;
        DIR* dir = opendir(pluginDir.c_str());

        if (dir) {
                struct dirent *ent;
                while ((ent = readdir(dir))) {
                        char* ext;
                        if ((ext = strrchr(ent->d_name, '.'))) {
                                if (string(ext) == ".so") {
                                        string pluginFilename = pluginDir + '/' + ent->d_name;
                                        loadPlugin(pluginFilename);
                                }
                        }
                }
                closedir(dir);
        }
}

void Plugins::loadPlugin(const string& fileName)
{
        void* pluginHandle = 0;
        typedef int startup_pl();
        startup_pl* plugin_startup;

#ifdef RTLD_NOW
        static const int flag = RTLD_NOW;
#else
        static const int flag = 0;
#endif
        
        if ((pluginHandle = dlopen(fileName.c_str(), flag))) {
                if ((plugin_startup = (startup_pl*) dlsym(pluginHandle, "plugin_startup"))) {
                        int retval = plugin_startup();
                        if (retval == 0) {
                                Plugin *p = new Plugin(fileName, pluginHandle);
                                addPlugin(p);
                                if (verbose)
                                        cout << "loaded plugin: \"" << fileName << "\"" << endl;
                        } else {
                                dlclose(pluginHandle);
                        }
                } else {
                        dlclose(pluginHandle);
                        cerr << fileName << " : incompatable plugin" << endl;
                }
        } else {
                cerr << "plugin load failed: " << dlerror() << endl;
        }
}

Plugins::~Plugins()
{
        for (vector<Plugin*>::iterator i = loaded.begin(); i != loaded.end(); ++i) {
                if ((*i)->handle) {
                        dlclose((*i)->handle);
                        if (verbose)
                                cout << "unloaded plugin \"" << (*i)->name << "\"" << endl;
                }
                delete (*i);
        }
}

void Plugins::addPlugin(Plugin* p) {
        loaded.push_back(p);
}
